/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.GXFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.IOUtils;

public class FileItem {
    private GXFile gxFile;
    private String sourceFileName;
    private String fieldName;
    private byte[] fieldByteString;
    private boolean formField;

    public FileItem() {
    }

    public FileItem(String name, boolean formField, String fieldName, InputStream stream) {
        this(null, name, formField, fieldName, stream);
    }

    public FileItem(String fileOriginalName, String filePathLocation, boolean formField, String fieldName, InputStream stream) {
        this.fieldName = fieldName;
        this.formField = formField;
        if (formField) {
            try {
                this.fieldByteString = IOUtils.toByteArray((InputStream)stream);
            }
            catch (IOException e) {
                System.err.println("Error converting to byte[] in FileItem: " + e);
            }
        } else {
            this.sourceFileName = fileOriginalName;
            this.gxFile = new GXFile(filePathLocation, ResourceAccessControlList.Private);
            this.gxFile.create(stream);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        if (this.gxFile != null) {
            return this.gxFile.getName();
        }
        return "";
    }

    public String getAbsolutePath() {
        if (this.gxFile != null) {
            return this.gxFile.getAbsolutePath();
        }
        return "";
    }

    public String getPath() {
        if (this.gxFile != null) {
            return this.gxFile.getFilePath();
        }
        return "";
    }

    public long getSize() {
        if (this.gxFile != null) {
            return this.gxFile.getLength();
        }
        return 0L;
    }

    public String getString(String charset) throws UnsupportedEncodingException {
        if (this.gxFile != null) {
            return new String(this.gxFile.toBytes(), charset);
        }
        try {
            return new String(this.fieldByteString, charset);
        }
        catch (IOException e) {
            System.err.println("Error reading FileItem String: " + e);
            return "";
        }
    }

    public boolean isFormField() {
        return this.formField;
    }

    public void delete() {
        if (this.gxFile != null) {
            this.gxFile.delete();
        }
    }

    public void write(String wFile) {
        if (Application.getGXServices().get("Storage") == null) {
            this.gxFile.copy(wFile);
            this.gxFile.delete();
        }
    }
}

