/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.PrivateUtilities;
import com.genexus.fileupload.IFileItemIterator;
import com.genexus.fileupload.IFileItemStream;
import com.genexus.webpanels.FileItem;
import java.io.InputStream;
import java.util.Vector;

public class FileItemCollection {
    protected Vector<FileItem> vector = new Vector();

    public FileItemCollection(IFileItemIterator lstParts, String rootPath) {
        if (lstParts != null) {
            try {
                while (lstParts.hasNext()) {
                    IFileItemStream item = lstParts.next();
                    String formFieldNameWithExtension = item.getName();
                    String temporalFilePath = item.getName();
                    if (!item.isFormField()) {
                        temporalFilePath = rootPath + PrivateUtilities.getTempFileName("tmp");
                    }
                    InputStream stream = item.openStream();
                    FileItem fileItem = new FileItem(formFieldNameWithExtension, temporalFilePath, item.isFormField(), item.getFieldName(), stream);
                    this.vector.add(fileItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getCount() {
        return this.vector.size();
    }

    public void clear() {
        this.vector.clear();
    }

    public boolean hasitembyname(String name) {
        for (int i = 0; i < this.vector.size(); ++i) {
            FileItem fileItem = this.vector.get(i);
            if (name.compareToIgnoreCase(fileItem.getFieldName()) != 0) continue;
            return true;
        }
        return false;
    }

    public FileItem itembyname(String name) {
        for (int i = 0; i < this.vector.size(); ++i) {
            FileItem fileItem = this.vector.get(i);
            if (name.compareToIgnoreCase(fileItem.getFieldName()) != 0) continue;
            return fileItem;
        }
        return new FileItem();
    }

    public FileItem item(int i) {
        return this.vector.get(i);
    }
}

