/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.GXutil;
import com.genexus.GxRestService;
import com.genexus.ModelContext;
import com.genexus.db.DynamicExecute;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.ws.rs.core.Response;
import jakarta.ws.rs.Consumes;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import json.org.json.JSONArray;

@Path(value="/gxmulticall")
@jakarta.ws.rs.Path(value="/gxmulticall")
public class GXMultiCall
extends GxRestService {
    private static final String METHOD_EXECUTE = "execute";

    @POST
    @jakarta.ws.rs.POST
    @javax.ws.rs.Consumes(value={"application/json"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @jakarta.ws.rs.Produces(value={"application/json;charset=UTF-8"})
    public Object gxMultiCall(String jsonStr) throws Exception {
        super.init("POST");
        String procName = ((HttpContextWeb)this.context.getHttpContext()).GetNextPar().toLowerCase();
        ModelContext modelContext = ModelContext.getModelContext((Class)Application.gxCfg);
        String appPackage = modelContext.getNAME_SPACE();
        if (!appPackage.equals("")) {
            appPackage = appPackage + ".";
        }
        String restProcName = procName + "_services_rest";
        try {
            Class<?> clazz = Class.forName(appPackage + restProcName);
        }
        catch (ClassNotFoundException cnf) {
            this.builder = Response.notFound();
            this.cleanup();
            return this.builder.build();
        }
        Class<?> myClass = Class.forName(appPackage + procName);
        Method[] methods = myClass.getMethods();
        Class<?>[] parameters = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equalsIgnoreCase(METHOD_EXECUTE)) continue;
            parameters = method.getParameterTypes();
        }
        JSONArray jsonArr = new JSONArray(jsonStr);
        UserInformation ui = Application.getConnectionManager().createUserInformation(Namespace.getNamespace(modelContext.getNAME_SPACE()));
        int remoteHandle = ui.getHandle();
        for (int i = 0; i < jsonArr.length(); ++i) {
            JSONArray procParms = new JSONArray(jsonArr.getJSONArray(i).toString());
            int parmCount = procParms.length();
            Object[] params = new Object[parmCount];
            for (int j = 0; j < parmCount; ++j) {
                params[j] = GXutil.convertObjectTo((Object)procParms.getString(j), parameters[j]);
            }
            DynamicExecute.dynamicExecute((ModelContext)modelContext, (int)remoteHandle, (Class)modelContext.packageClass, (String)(appPackage + procName), (Object[])params);
        }
        Application.cleanupConnection(remoteHandle);
        this.builder = Response.okWrapped();
        this.builder.type("application/json");
        this.builder.entity((Object)"");
        this.cleanup();
        return this.builder.build();
    }

    @Override
    protected boolean IntegratedSecurityEnabled() {
        return false;
    }

    @Override
    protected int IntegratedSecurityLevel() {
        return 0;
    }

    protected String EncryptURLParameters() {
        return "NO";
    }

    private String parsePostData(int len, InputStream in) {
        if (len <= 0) {
            return new String();
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        byte[] postedBytes = new byte[len];
        try {
            int inputLen;
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                throw new IllegalArgumentException("err.io.short_read : length " + len + " read : " + offset + " Content: \n" + new String(postedBytes));
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            String postedBody = new String(postedBytes, 0, len, "8859_1");
            return postedBody;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

