/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.internet.HttpContext;
import com.genexus.webpanels.FileItem;
import com.genexus.webpanels.FileItemCollection;
import com.genexus.webpanels.GXWebObjectStub;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.HttpUtils;
import com.genexus.webpanels.WebApplicationStartup;
import com.genexus.ws.rs.core.IResponseBuilder;
import com.genexus.ws.rs.core.Response;
import java.io.InputStream;
import json.org.json.JSONArray;
import json.org.json.JSONObject;
import org.apache.commons.io.FilenameUtils;

public class GXObjectUploadServices
extends GXWebObjectStub {
    boolean isRestCall = false;
    IResponseBuilder builder = null;

    public IResponseBuilder doInternalRestExecute(HttpContext context) throws Exception {
        this.isRestCall = true;
        this.doExecute(context);
        return this.builder;
    }

    public void doInternalExecute(HttpContext context) throws Exception {
        this.doExecute(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(HttpContext context) throws Exception {
        block25: {
            String savedFileName = "";
            String fileName = "";
            String ext = "";
            WebApplicationStartup.init(Application.gxCfg, context);
            context.setStream();
            try {
                String fileDirPath = Preferences.getDefaultPreferences().getPRIVATE_PATH();
                ModelContext modelContext = new ModelContext(Application.gxCfg);
                modelContext.setHttpContext((IHttpContext)context);
                ModelContext.getModelContext().setHttpContext((IHttpContext)context);
                context.setContext(modelContext);
                if (((HttpContextWeb)context).isMultipartContent()) {
                    context.setContentType("text/plain");
                    FileItemCollection postedFiles = context.getHttpRequest().getPostedparts();
                    JSONArray jsonArray = new JSONArray();
                    int len = postedFiles.getCount();
                    for (int i = 0; i < len; ++i) {
                        String keyId = HttpUtils.getUploadFileKey();
                        FileItem file = postedFiles.item(i);
                        if (file.isFormField()) continue;
                        ext = CommonUtil.getFileType((String)file.getName());
                        fileName = CommonUtil.getFileName((String)file.getName()) + "." + ext;
                        long fileSize = file.getSize();
                        savedFileName = file.getPath();
                        JSONObject jObj = new JSONObject();
                        jObj.put("name", (Object)fileName);
                        jObj.put("size", fileSize);
                        jObj.put("extension", (Object)ext);
                        jObj.put("path", (Object)HttpUtils.getUploadFileId(keyId));
                        jsonArray.put((Object)jObj);
                        if (savedFileName.isEmpty()) continue;
                        HttpUtils.CacheUploadFile(keyId, savedFileName, fileName, ext);
                    }
                    JSONObject jObjResponse = new JSONObject();
                    jObjResponse.put("files", (Object)jsonArray);
                    ((HttpContextWeb)context).writeText(jObjResponse.toString());
                    context.getResponse().flushBuffer();
                    break block25;
                }
                String keyId = HttpUtils.getUploadFileKey();
                String contentType = context.getHeader("Content-Type");
                String gxFileName = context.getHeader("x-gx-filename");
                String fName = "";
                if (!gxFileName.isEmpty()) {
                    ext = FilenameUtils.getExtension((String)gxFileName);
                    fName = FilenameUtils.getBaseName((String)gxFileName);
                } else {
                    ext = this.getExtension(contentType);
                }
                fileName = PrivateUtilities.getTempFileName("", fName, "tmp");
                String filePath = fileDirPath + fileName;
                fileName = fileName.replaceAll(".tmp", "." + ext);
                try (InputStream is = context.getRequest().getInputStream().getInputStream();){
                    FileItem fileItem = new FileItem(filePath, false, "", is);
                    savedFileName = fileItem.getPath();
                    JSONObject jObj = new JSONObject();
                    jObj.put("object_id", (Object)HttpUtils.getUploadFileId(keyId));
                    if (!this.isRestCall) {
                        context.getResponse().setContentType("application/json");
                        context.getResponse().setStatus(201);
                        context.getResponse().setHeader("GeneXus-Object-Id", keyId);
                        ((HttpContextWeb)context).writeText(jObj.toString());
                        context.getResponse().flushBuffer();
                    } else {
                        String jsonResponse = jObj.toString();
                        this.builder = Response.statusWrapped((int)201).entityWrapped((Object)jsonResponse);
                        this.builder.header("GeneXus-Object-Id", (Object)keyId);
                    }
                    if (!savedFileName.isEmpty()) {
                        HttpUtils.CacheUploadFile(keyId, savedFileName, fileName, ext);
                    }
                }
            }
            catch (Throwable e) {
                context.sendResponseStatus(404, e.getMessage());
            }
            finally {
                if (!this.isRestCall) {
                    ModelContext.deleteThreadContext();
                }
            }
        }
    }

    @Override
    protected boolean IntegratedSecurityEnabled() {
        return Application.getClientPreferences().getProperty("EnableIntegratedSecurity", "0").equals("1");
    }

    @Override
    protected int IntegratedSecurityLevel() {
        return 3;
    }

    @Override
    protected String IntegratedSecurityPermissionPrefix() {
        return "";
    }

    @Override
    protected String EncryptURLParameters() {
        return "NO";
    }

    private String getExtension(String contentType) {
        if (contentType.startsWith("image/jpg") || contentType.startsWith("application/jpg")) {
            return "jpg";
        }
        if (contentType.startsWith("image/jpeg") || contentType.startsWith("application/jpeg")) {
            return "jpeg";
        }
        if (contentType.startsWith("image/tiff")) {
            return "tif";
        }
        if (contentType.startsWith("image/png")) {
            return "png";
        }
        if (contentType.startsWith("audio/x-wav")) {
            return "wav";
        }
        if (contentType.startsWith("video/mpeg")) {
            return "mpg";
        }
        if (contentType.startsWith("video/quicktime")) {
            return "mov";
        }
        if (contentType.startsWith("audio/x-caf")) {
            return "caf";
        }
        if (contentType.startsWith("audio/mpeg")) {
            return "mp3";
        }
        if (contentType.startsWith("audio/x-pn-realaudio")) {
            return "ram";
        }
        if (contentType.startsWith("audio/vnd.rn-realaudio")) {
            return "ram";
        }
        if (contentType.startsWith("application/pdf")) {
            return "pdf";
        }
        if (contentType.startsWith("text/rtf")) {
            return "rtf";
        }
        if (contentType.startsWith("text/plain")) {
            return "txt";
        }
        if (contentType.startsWith("image/bmp")) {
            return "bmp";
        }
        if (contentType.startsWith("image/gif")) {
            return "gif";
        }
        if (contentType.startsWith("audio/mp4")) {
            return "m4a";
        }
        if (contentType.startsWith("audio/x-m4a")) {
            return "m4a";
        }
        if (contentType.startsWith("audio/aiff")) {
            return "aif";
        }
        if (contentType.startsWith("audio/3gpp")) {
            return "a3gpp";
        }
        if (contentType.startsWith("video/3gpp2")) {
            return "3g2";
        }
        if (contentType.startsWith("video/3gpp")) {
            return "3gp";
        }
        if (contentType.startsWith("video/mp4")) {
            return "mp4";
        }
        if (contentType.startsWith("video/x-msvideo")) {
            return "avi";
        }
        if (contentType.startsWith("video/x-divx")) {
            return "divx";
        }
        if (contentType.startsWith("application/zip")) {
            return "zip";
        }
        if (contentType.startsWith("application/x-gzip")) {
            return "gz";
        }
        if (contentType.startsWith("application/x-tar")) {
            return "tar";
        }
        if (contentType.startsWith("application/x-rar-compressed")) {
            return "rar";
        }
        return "tmp";
    }

    @Override
    protected void init(HttpContext context) {
    }
}

