/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.ApplicationContext;
import com.genexus.GXutil;
import com.genexus.IHttpContext;
import com.genexus.LocalUtil;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.URLRouter;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.internet.HttpContext;
import com.genexus.security.GXResult;
import com.genexus.security.GXSecurityProvider;
import com.genexus.servlet.ServletException;
import com.genexus.servlet.http.HttpServlet;
import com.genexus.servlet.http.ICookie;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletResponse;
import com.genexus.specific.java.LogManager;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.WebApplicationStartup;
import java.util.Enumeration;

public abstract class GXWebObjectStub
extends HttpServlet {
    public static ILogger logger = null;
    protected ModelContext context;
    protected int remoteHandle = -1;
    protected transient LocalUtil localUtil;
    protected static final int SECURITY_GXOBJECT = 3;
    protected static final int SECURITY_HIGH = 2;
    protected static final int SECURITY_LOW = 1;
    private static final int HTTP_RESPONSE_BUFFER_SIZE = 131072;

    protected abstract void doExecute(HttpContext var1) throws Exception;

    protected abstract void init(HttpContext var1) throws Exception;

    protected abstract boolean IntegratedSecurityEnabled();

    protected abstract int IntegratedSecurityLevel();

    protected abstract String IntegratedSecurityPermissionPrefix();

    protected abstract String EncryptURLParameters();

    public GXWebObjectStub() {
    }

    public GXWebObjectStub(int remoteHandle, ModelContext context) {
        this.remoteHandle = remoteHandle;
        this.context = context;
        UserInformation ui = Application.getConnectionManager().getUserInformationNoException(remoteHandle);
        this.localUtil = ui == null ? Application.getConnectionManager().createUserInformation(Namespace.getNamespace(context.getNAME_SPACE())).getLocalUtil() : ui.getLocalUtil();
    }

    private void dumpRequestInfo(HttpContext httpContext) {
        IHttpServletRequest request = httpContext.getRequest();
        StringBuffer sBuffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        sBuffer.append("Request Information");
        sBuffer.append(nl + "Url: ");
        sBuffer.append(request.getRequestURL());
        sBuffer.append(nl + "HttpHeaders: " + nl);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            sBuffer.append(header);
            sBuffer.append(":");
            sBuffer.append(request.getHeader(header));
        }
        sBuffer.append(nl + "HttpCookies: " + nl);
        ICookie[] cookies = httpContext.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                sBuffer.append(cookies[i].getName());
                sBuffer.append(":");
                sBuffer.append(cookies[i].getValue());
            }
        }
        logger.debug(sBuffer.toString());
    }

    protected void callExecute(String method, IHttpServletRequest req, IHttpServletResponse res) throws ServletException {
        HttpContextWeb httpContext = null;
        try {
            httpContext = new HttpContextWeb(method, req, res, this.getWrappedServletContext());
            this.callExecute(method, req, res, httpContext);
        }
        catch (Exception e) {
            this.handleException(e, httpContext);
        }
    }

    protected void callExecute(String method, IHttpServletRequest req, IHttpServletResponse res, HttpContext httpContext) throws ServletException {
        this.initialize(req, res);
        try {
            boolean useAuthentication;
            String gxcfg = this.getWrappedServletContext().getInitParameter("gxcfg");
            if (gxcfg != null) {
                Class<?> gxcfgClass;
                ModelContext.gxcfgPackageClass = gxcfgClass = Class.forName(gxcfg);
                ApplicationContext appContext = ApplicationContext.getInstance();
                appContext.setServletEngine(true);
                Application.init(gxcfgClass);
            }
            if (logger.isDebugEnabled()) {
                this.dumpRequestInfo(httpContext);
            }
            if (!(useAuthentication = this.IntegratedSecurityEnabled())) {
                this.callDoExecute(httpContext);
            } else {
                this.init(httpContext);
                if (this.IntegratedSecurityLevel() == 3) {
                    httpContext.doNotCompress(true);
                }
                new WebApplicationStartup();
                WebApplicationStartup.init(((Object)((Object)this)).getClass(), httpContext);
                boolean[] flag = new boolean[]{false};
                boolean[] permissionFlag = new boolean[]{false};
                String reqUrl = req.getRequestURL().toString();
                if (req.getMethod().equals("POST")) {
                    reqUrl = this.EncryptURLParameters().equals("SESSION") ? "" : req.getHeader("Referer");
                } else {
                    String queryString = req.getQueryString();
                    if (queryString != null) {
                        reqUrl = reqUrl + "?" + queryString;
                    }
                }
                ModelContext modelContext = ModelContext.getModelContext(((Object)((Object)this)).getClass());
                modelContext.setHttpContext((IHttpContext)httpContext);
                ApplicationContext.getInstance().setPoolConnections(!Namespace.createNamespace(modelContext).isRemoteGXDB());
                String loginObject = Application.getClientContext().getClientPreferences().getProperty("IntegratedSecurityLoginWeb", "");
                loginObject = GXutil.getClassName(loginObject);
                String loginObjectURL = URLRouter.getURLRoute((String)loginObject.toLowerCase(), (String[])new String[0], (String[])new String[0], (String)httpContext.getRequest().getContextPath(), (String)modelContext.getPackageName());
                String permissionPrefix = this.IntegratedSecurityPermissionPrefix();
                if (this.IntegratedSecurityLevel() == 3) {
                    String token = req.getHeader("Authorization");
                    if (token != null && token.length() > 0) {
                        token = token.replace("OAuth ", "");
                        GXResult gXResult = GXSecurityProvider.getInstance().checkaccesstoken(-2, modelContext, token, flag);
                    } else {
                        token = "";
                        GXSecurityProvider.getInstance().checksession(-2, modelContext, reqUrl, flag);
                    }
                    if (!flag[0]) {
                        String OauthRealm = "OAuth realm=\"" + httpContext.getRequest().getServerName() + "\"";
                        httpContext.getResponse().addHeader("WWW-Authenticate", OauthRealm);
                        httpContext.sendResponseStatus(401, "Not Authorized");
                    } else {
                        this.callDoExecute(httpContext);
                    }
                } else if (this.IntegratedSecurityLevel() == 1) {
                    GXSecurityProvider.getInstance().checksession(-2, modelContext, reqUrl, flag);
                    if (!flag[0]) {
                        ((HttpContextWeb)httpContext).redirect(loginObjectURL, true);
                    } else {
                        this.callDoExecute(httpContext);
                    }
                } else {
                    GXSecurityProvider.getInstance().checksessionprm(-2, modelContext, reqUrl, permissionPrefix, flag, permissionFlag);
                    if (permissionFlag[0]) {
                        this.callDoExecute(httpContext);
                    } else {
                        String notAuthorizedObject = Application.getClientContext().getClientPreferences().getProperty("IntegratedSecurityNotAuthorizedWeb", "");
                        notAuthorizedObject = GXutil.getClassName(notAuthorizedObject);
                        String notAuthorizedObjectURL = URLRouter.getURLRoute((String)notAuthorizedObject.toLowerCase(), (String[])new String[0], (String[])new String[0], (String)httpContext.getRequest().getContextPath(), (String)modelContext.getPackageName());
                        if (flag[0]) {
                            ((HttpContextWeb)httpContext).redirect(notAuthorizedObjectURL, true);
                        } else {
                            ((HttpContextWeb)httpContext).redirect(loginObjectURL, true);
                        }
                    }
                }
            }
            httpContext.setResponseCommited();
            httpContext.flushStream();
        }
        catch (Throwable e) {
            if (!res.isCommitted()) {
                res.reset();
            }
            this.handleException(e, httpContext);
        }
    }

    protected void handleException(Throwable e, HttpContext httpContext) throws ServletException {
        logger.error("Web Execution Error", e);
        if (logger.isDebugEnabled() && httpContext != null) {
            this.dumpRequestInfo(httpContext);
        }
        throw new ServletException(PrivateUtilities.getStackTraceAsString(e));
    }

    private void initialize(IHttpServletRequest req, IHttpServletResponse res) {
        if (logger == null) {
            logger = LogManager.initialize((String)req.getServletContext().getRealPath("/"), GXWebObjectStub.class);
        }
        this.setResponseBufferSize(res);
    }

    private void setResponseBufferSize(IHttpServletResponse res) {
        Integer bSize = 0;
        try {
            bSize = Application.getClientContext().getClientPreferences().getHttpBufferSize();
            if (res != null && !res.isCommitted() && bSize > 0) {
                res.setBufferSize(bSize.intValue());
            }
        }
        catch (Throwable e) {
            logger.error("Could not set bufferSize", e);
        }
    }

    private void callDoExecute(HttpContext httpContext) throws Throwable {
        this.doExecute(httpContext);
    }
}

