/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.ClientContext;
import com.genexus.CommonUtil;
import com.genexus.GXutil;
import com.genexus.HTMLDocType;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.common.interfaces.IGXWindow;
import com.genexus.db.IDataStoreProvider;
import com.genexus.fileupload.IFileItemIterator;
import com.genexus.fileupload.servlet.ServletFileUpload;
import com.genexus.internet.GXNavigationHelper;
import com.genexus.internet.HttpContext;
import com.genexus.internet.HttpRequest;
import com.genexus.internet.HttpRequestWeb;
import com.genexus.internet.HttpResponse;
import com.genexus.internet.MsgList;
import com.genexus.servlet.IRequestDispatcher;
import com.genexus.servlet.IServletContext;
import com.genexus.servlet.IServletInputStream;
import com.genexus.servlet.IServletOutputStream;
import com.genexus.servlet.http.Cookie;
import com.genexus.servlet.http.HttpServletResponse;
import com.genexus.servlet.http.ICookie;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletResponse;
import com.genexus.servlet.http.IHttpSession;
import com.genexus.util.Base64;
import com.genexus.util.FastByteArrayOutputStream;
import com.genexus.util.GXFile;
import com.genexus.webpanels.ContextPath;
import com.genexus.webpanels.FileItem;
import com.genexus.webpanels.FileItemCollection;
import com.genexus.webpanels.HttpUtils;
import com.genexus.webpanels.IContextPath;
import com.genexus.webpanels.WebSession;
import com.genexus.webpanels.WebUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpContextWeb
extends HttpContext {
    private static Logger log = LogManager.getLogger(HttpContextWeb.class);
    HttpResponse httpRes;
    HttpRequest httpReq;
    protected IServletContext servletContext;
    protected boolean useOldQueryStringFormat;
    protected Vector<String> parms;
    private Hashtable<String, String> namedParms;
    private Hashtable<String, String[]> postData;
    private boolean useNamedParameters;
    private int currParameter;
    protected IHttpServletRequest request;
    protected IHttpServletResponse response;
    protected String requestMethod;
    protected String contentType = "";
    protected boolean SkipPushUrl = false;
    protected boolean Redirected = false;
    private Hashtable<String, String> cookies;
    private boolean streamSet = false;
    private WebSession webSession;
    private FileItemCollection fileItemCollection;
    private IFileItemIterator lstParts;
    private boolean ajaxCallAsPOST = false;
    private String sTmpDir;
    private boolean firstParConsumed = false;
    private static final Pattern USERAGENT_SEARCH_BOT = Pattern.compile("Googlebot|AhrefsBot|bingbot|MJ12bot", 2);
    private static final Pattern MULTIMEDIA_GXI_GRID_PATTERN = Pattern.compile("(\\w+)(_\\d{4})$");
    private static final Pattern EDGE_BROWSER_VERSION_REGEX = Pattern.compile(" Edg[\\w]{0,3}\\/([0-9]+)\\.", 2);
    private static final String GXEVENT_PARM = "gxevent";
    private static final String SAME_SITE_NONE = "None";
    private static final String SAME_SITE_LAX = "Lax";
    private static final String SAME_SITE_STRICT = "Strict";
    private static final String SET_COOKIE = "Set-Cookie";
    public static final int BROWSER_OTHER = 0;
    public static final int BROWSER_IE = 1;
    public static final int BROWSER_NETSCAPE = 2;
    public static final int BROWSER_OPERA = 3;
    public static final int BROWSER_UP = 4;
    public static final int BROWSER_POCKET_IE = 5;
    public static final int BROWSER_FIREFOX = 6;
    public static final int BROWSER_CHROME = 7;
    public static final int BROWSER_SAFARI = 8;
    public static final int BROWSER_EDGE = 9;
    public static final int BROWSER_INDEXBOT = 20;
    private String contextPath;
    private static Boolean customRedirect;
    String sameSiteMode;

    public boolean isMultipartContent() {
        return ServletFileUpload.isMultipartContent((IHttpServletRequest)this.request);
    }

    @Override
    public String getResource(String path) {
        int port;
        if (path.length() == 0) {
            return "";
        }
        String protocol = "http";
        if (this.getHttpSecure() == 1) {
            protocol = "https";
        }
        String portS = (port = this.httpReq.getServerPort()) == 80 || port == 443 ? "" : ":" + port;
        return protocol + "://" + this.httpReq.getServerHost() + portS + this.getResourceRelative(path);
    }

    @Override
    public String getResourceRelative(String path) {
        return this.getResourceRelative(path, true);
    }

    @Override
    public String getResourceRelative(String path, boolean includeBasePath) {
        if (Application.getExternalProvider() != null && !path.isEmpty()) {
            if (CommonUtil.isAbsoluteURL((String)path)) {
                return path;
            }
            GXFile gxFile = new GXFile(path);
            String pathURL = gxFile.getAbsolutePath();
            if (CommonUtil.isAbsoluteURL((String)pathURL)) {
                return pathURL;
            }
        }
        try {
            File file = new File(path);
            if (file.getPath().compareTo(file.getAbsolutePath()) != 0) {
                return path;
            }
        }
        catch (Exception e) {
            return path;
        }
        if (path.length() == 0) {
            return "";
        }
        String ContextPath2 = null;
        try {
            ContextPath2 = this.request.getContextPath();
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        String Resource = path;
        String basePath = this.getDefaultPath();
        if (Resource.startsWith(basePath) && Resource.length() >= basePath.length()) {
            Resource = Resource.substring(basePath.length());
        }
        if (ContextPath2 != null && !ContextPath2.equals("") && Resource.startsWith(ContextPath2)) {
            return Resource.replace('\\', '/');
        }
        Resource = Resource.replace('\\', '/');
        if (includeBasePath) {
            Resource = Resource.startsWith("/") ? ContextPath2 + Resource : ContextPath2 + "/" + Resource;
        } else if (Resource.startsWith("/")) {
            Resource = Resource.substring(1);
        }
        String baseName = FilenameUtils.getBaseName((String)Resource);
        Resource = CommonUtil.replaceLast((String)Resource, (String)baseName, (String)PrivateUtilities.encodeFileName(baseName));
        return Resource;
    }

    private IFileItemIterator parseMultiParts() {
        if (this.lstParts == null) {
            try {
                this.sTmpDir = Preferences.getDefaultPreferences().getPRIVATE_PATH();
                if (this.request != null && ServletFileUpload.isMultipartContent((IHttpServletRequest)this.request)) {
                    ServletFileUpload upload = new ServletFileUpload();
                    upload.setUploadHeaderEncoding("UTF-8");
                    this.lstParts = upload.getItemIterator(this.request);
                }
            }
            catch (Exception e) {
                log.error("parseMultiParts", (Throwable)e);
            }
        }
        return this.lstParts;
    }

    public FileItemCollection getPostedparts() {
        if (this.fileItemCollection == null) {
            this.fileItemCollection = new FileItemCollection(this.parseMultiParts(), this.sTmpDir);
        }
        return this.fileItemCollection;
    }

    @Override
    public HttpContext copy() {
        try {
            HttpContextWeb o = new HttpContextWeb(this.requestMethod, this.request, this.response, this.servletContext);
            this.copyCommon(o);
            super.copyCommon(o);
            return o;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void copyCommon(HttpContextWeb o) {
        o.cookies = this.cookies;
        o.webSession = this.webSession;
        o.httpRes = this.httpRes;
        o.httpReq = this.httpReq;
        o.postData = this.postData;
        o.parms = this.parms;
        o.namedParms = this.namedParms;
        o.streamSet = this.streamSet;
        o.isCrawlerRequest = o.isCrawlerRequest();
    }

    public HttpContextWeb(String requestMethod, IHttpServletRequest req, IHttpServletResponse res, IServletContext servletContext) throws IOException {
        this(ClientContext.getModelContext().getClientPreferences().getProperty("UseNamedParameters", "1").equals("1"), requestMethod, req, res, servletContext);
    }

    public HttpContextWeb(boolean useNamedParameters, String requestMethod, IHttpServletRequest req, IHttpServletResponse res, IServletContext servletContext) throws IOException {
        this.request = req;
        this.response = res;
        if (this.isForward()) {
            requestMethod = "GET";
        }
        this.requestMethod = requestMethod;
        this.servletContext = servletContext;
        this.GX_msglist = new MsgList();
        this.postData = null;
        this.cookies = new Hashtable();
        this.httpRes = new HttpResponse(this);
        this.httpReq = new HttpRequestWeb(this);
        this.webSession = new WebSession(req);
        this.GX_webresponse = this.httpRes;
        this.useUtf8 = true;
        this.parms = new Vector();
        this.namedParms = new Hashtable();
        this.useNamedParameters = useNamedParameters;
        this.loadParameters(req.getQueryString());
        this.isCrawlerRequest = this.isCrawlerRequest();
    }

    private void loadParameters(String value) {
        this.initpars();
        this.parms.clear();
        this.namedParms.clear();
        boolean oneParm = false;
        if (value != null && value.length() > 0) {
            String parm;
            this.useOldQueryStringFormat = !this.useNamedParameters || !this.removeInternalParms(value).contains("=");
            String value1 = value.charAt(0) == '?' ? value.substring(1) : value;
            String[] elements = this.useOldQueryStringFormat ? value1.split(",") : value1.split("&");
            oneParm = elements.length > 0;
            for (int i = 0; i < elements.length && (parm = elements[i]).indexOf("gx-no-cache=") == -1; ++i) {
                if (this.useOldQueryStringFormat) {
                    this.parms.addElement(parm);
                    continue;
                }
                String parameterValue = "";
                if (parm.split("=").length > 1) {
                    parameterValue = parm.split("=")[1];
                }
                this.parms.addElement(parameterValue);
                this.namedParms.put(parm.split("=")[0].toLowerCase(), parameterValue);
            }
        }
        if (this.requestMethod.equalsIgnoreCase("POST") && oneParm && this.parms.size() == 0) {
            this.ajaxCallAsPOST = this.tryLoadAjaxCallParms();
        }
    }

    public void initpars() {
        this.currParameter = -1;
    }

    private boolean tryLoadAjaxCallParms() {
        Hashtable<String, String[]> parsePostData;
        if (!this.isMultipartContent() && (parsePostData = this.getPostData()) != null) {
            String[] postParm = null;
            String gxEvent = "";
            postParm = parsePostData.get("GXEvent");
            if (postParm != null) {
                gxEvent = postParm[0];
            }
            String gxAction = "";
            postParm = parsePostData.get("GXAction");
            if (postParm != null) {
                gxAction = postParm[0];
            }
            if (gxEvent != null && !gxEvent.trim().equals("")) {
                try {
                    Pattern pattern = Pattern.compile("GXParm([0-9]+)");
                    Vector<String> indexedParms = new Vector<String>();
                    Enumeration<String> postParms = parsePostData.keys();
                    while (postParms.hasMoreElements()) {
                        String name = postParms.nextElement();
                        Matcher matcher = pattern.matcher(name);
                        if (!matcher.matches()) continue;
                        int parmIdx = Integer.parseInt(matcher.group(1));
                        int sizeDiff = parmIdx - indexedParms.size();
                        for (int i = 0; i <= sizeDiff; ++i) {
                            indexedParms.add("");
                        }
                        String parm = "";
                        postParm = parsePostData.get(name);
                        if (postParm == null) continue;
                        parm = postParm[0];
                        indexedParms.setElementAt(parm, parmIdx);
                    }
                    this.parms.clear();
                    this.parms.add(gxEvent);
                    if (gxAction != null && !gxAction.trim().equals("")) {
                        this.parms.add(gxAction);
                    }
                    for (int i = 0; i < indexedParms.size(); ++i) {
                        this.parms.add((String)indexedParms.elementAt(i));
                    }
                    return true;
                }
                catch (Throwable ex) {
                    log.error("Reading Ajax as Post Data", ex);
                }
            }
        }
        return false;
    }

    @Override
    public void parseGXState(JSONObject tokenValues) {
        try {
            Iterator it = tokenValues.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.isFileParm(key)) continue;
                HttpUtils.pushValue(this.getPostData(), key, tokenValues.get(key).toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Hashtable<String, String[]> getPostData() {
        block9: {
            if (this.postData == null) {
                String contentType = this.request.getContentType();
                if (this.ajaxCallAsPOST || this.isForward()) {
                    return new Hashtable<String, String[]>();
                }
                try {
                    this.postData = contentType != null && (contentType.contains("application/json") || contentType.contains("text/xml")) ? new Hashtable() : (ServletFileUpload.isMultipartContent((IHttpServletRequest)this.request) ? HttpContextWeb.parseMultipartPostData(this.getPostedparts()) : HttpContextWeb.parsePostData(this.request, this.request.getInputStream()));
                    String[] value = this.postData.get("GXState");
                    if (value == null) break block9;
                    try {
                        String[] valuestr = value;
                        String decoded = valuestr[0];
                        if (this.useBase64ViewState()) {
                            decoded = new String(Base64.decode((String)decoded), "UTF8");
                        }
                        JSONObject tokenValues = null;
                        try {
                            tokenValues = new JSONObject(decoded);
                        }
                        catch (JSONException jex) {
                            log.debug("GXState JSONObject error (1)", (Throwable)jex);
                            char c = '\u0000';
                            decoded = decoded.replace(Character.toString(c), "");
                            tokenValues = new JSONObject(decoded);
                        }
                        this.parseGXState(tokenValues);
                    }
                    catch (Exception ex) {
                        log.debug("GXState JSONObject error (2)", (Throwable)ex);
                    }
                }
                catch (IOException e) {
                    this.postData = new Hashtable();
                    log.debug("GetPostData", (Throwable)e);
                }
            }
        }
        return this.postData;
    }

    @Override
    public String GetPar(String parameter) {
        if (this.useOldQueryStringFormat) {
            return this.GetNextPar();
        }
        String parm = this.namedParms.get(parameter.toLowerCase());
        if (!this.ajaxCallAsPOST && parm != null) {
            parm = GXutil.URLDecode(parm);
        }
        return parm == null ? "" : parm;
    }

    @Override
    public String GetFirstPar(String parameter) {
        if (this.useOldQueryStringFormat) {
            return this.GetNextPar();
        }
        if (!this.firstParConsumed && this.namedParms.containsKey(GXEVENT_PARM)) {
            this.firstParConsumed = true;
            return this.GetPar(GXEVENT_PARM);
        }
        return this.GetPar(parameter);
    }

    @Override
    public String GetNextPar() {
        ++this.currParameter;
        String parm = "";
        if (this.currParameter < this.parms.size()) {
            parm = this.parms.elementAt(this.currParameter).toString();
            if (!this.ajaxCallAsPOST) {
                parm = GXutil.URLDecode(parm);
            }
        }
        return parm;
    }

    @Override
    public byte setHeader(String header, String value) {
        if (this.getResponse() == null) {
            return 0;
        }
        this.response.setHeader(header, value.replace("\n", "%0a").replace("\r", "%0d"));
        return 0;
    }

    @Override
    public void setDateHeader(String header, int value) {
        this.response.setDateHeader(header, (long)value);
    }

    @Override
    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    @Override
    public String getRequestMethod() {
        return this.requestMethod;
    }

    public boolean isForward() {
        String callMethod = (String)this.getRequest().getAttribute("gx_webcall_method");
        return callMethod != null && callMethod.equalsIgnoreCase("forward");
    }

    public boolean forwardAsWebCallMethod() {
        if (this.context != null) {
            return ((Preferences)this.context.getPreferences()).getProperty("WEB_CALL_METHOD", "Redirect").equalsIgnoreCase("Forward");
        }
        return false;
    }

    @Override
    public String getContextPath() {
        if (this.getResponse() == null) {
            return "";
        }
        if (this.contextPath == null) {
            if (this.servletContext.getServerInfo().startsWith("ApacheJServ")) {
                this.contextPath = "";
            } else {
                IContextPath path = ContextPath.getIContextPath(this.servletContext);
                try {
                    this.contextPath = path == null ? "" : path.getContextPath(this.request);
                }
                catch (Exception e) {
                    log.warn("Could not find getContextPath", (Throwable)e);
                }
                if (this.contextPath == null) {
                    this.contextPath = "";
                }
            }
        }
        return this.contextPath;
    }

    @Override
    public void setContextPath(String path) {
    }

    public String getRealPath(String path) {
        String realPath = path;
        File file = new File(path);
        if (!file.isAbsolute() || !file.exists()) {
            if (path.startsWith(this.getContextPath())) {
                path = path.substring(this.getContextPath().length());
            }
            if ((realPath = this.servletContext.getRealPath(path)) == null) {
                realPath = this.getDefaultPath() + File.separator + path;
            }
        }
        return realPath;
    }

    @Override
    public IHttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public String getReferer() {
        String referer;
        if (!this.isLocalStorageSupported()) {
            String referer2 = this.getNavigationHelper(false).getRefererUrl(this.getRequestNavUrl());
            return referer2 == null ? "" : referer2;
        }
        String temp = this.cgiGet("sCallerURL");
        String string = referer = temp != null ? temp : "";
        if (referer == "") {
            GXNavigationHelper nav = this.getNavigationHelper(false);
            String selfUrl = this.getRequestNavUrl();
            if (nav.count() > 0) {
                referer = nav.peekUrl(selfUrl);
            }
            if (referer == "" && this.request != null && this.request.getHeader("Referer") != null) {
                temp = this.request.getHeader("Referer");
                referer = !selfUrl.equals(temp) ? temp : referer;
            }
        }
        try {
            URL url = new URL(referer);
            String query = StringUtils.isNotEmpty((String)url.getQuery()) ? "?" + url.getQuery() : "";
            referer = url.getPath() + query;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return referer;
    }

    @Override
    public short setWrkSt(int handle, String wrkst) {
        this.webPutSessionValue("GX_WRKST", wrkst.toUpperCase());
        return 1;
    }

    @Override
    public String getApplicationId(int handle) {
        String appId = this.request.getHeader("GXApplicationIdentifier");
        if (appId != null) {
            return appId;
        }
        return "";
    }

    @Override
    public String getWorkstationId(int handle) {
        String wrkstId = (String)this.getSessionValue("GX_WRKST");
        if (wrkstId == null || wrkstId.equals("")) {
            wrkstId = this.request.getRemoteAddr();
        }
        return wrkstId;
    }

    @Override
    public short setUserId(int handle, String user, String dataSource) {
        this.webPutSessionValue("GX_USERID", user.toUpperCase());
        return 1;
    }

    @Override
    public String getUserId(String key, ModelContext context, int handle, String dataSource) {
        if (key.equalsIgnoreCase("server") && !Application.getClientPreferences().getLOGIN_AS_USERID()) {
            return GXutil.userId(key, context, handle, dataSource);
        }
        String user = (String)this.getSessionValue("GX_USERID");
        if (user == null || user.length() == 0) {
            return this.request.getRemoteUser() == null ? "" : this.request.getRemoteUser();
        }
        return user;
    }

    @Override
    public String getUserId(String key, ModelContext context, int handle, IDataStoreProvider dataStore) {
        if (key.equalsIgnoreCase("server") && !Application.getClientPreferences().getLOGIN_AS_USERID()) {
            return GXutil.userId(key, context, handle, dataStore);
        }
        String user = (String)this.getSessionValue("GX_USERID");
        if (user == null || user.length() == 0) {
            return this.request.getRemoteUser() == null ? "" : this.request.getRemoteUser();
        }
        return user;
    }

    @Override
    public String getRemoteAddr() {
        String address = this.getHeader("X-Forwarded-For");
        if (address.length() > 0) {
            return address;
        }
        address = this.request.getRemoteAddr();
        return address == null ? "" : address;
    }

    @Override
    public boolean isSmartDevice() {
        String userAgent = this.request.getHeader("USER-AGENT");
        if (userAgent != null) {
            if (userAgent.indexOf("Windows CE") != -1) {
                return true;
            }
            if (userAgent.indexOf("iPhone") != -1) {
                return true;
            }
            if (userAgent.indexOf("BlackBerry") != -1) {
                return true;
            }
            if (userAgent.indexOf("Opera Mini") != -1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLocalStorageSupported() {
        boolean supported;
        block8: {
            supported = true;
            try {
                String NotSupported = this.getCookie("GXLocalStorageSupport");
                boolean bl = supported = NotSupported == null || NotSupported.equals("");
                if (!supported) break block8;
                switch (this.getBrowserType()) {
                    case 1: {
                        try {
                            if (this.context != null && this.context.getClientPreferences() != null) {
                                float ver = Float.parseFloat(this.getBrowserVersion());
                                HTMLDocType docType = this.context.getClientPreferences().getDOCTYPE();
                                boolean docTypeDefined = docType != HTMLDocType.NONE && docType != HTMLDocType.UNDEFINED;
                                supported = ver >= 9.0f && docTypeDefined;
                            }
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return supported;
    }

    @Override
    public boolean exposeMetadata() {
        return this.context.getClientPreferences().getEXPOSE_METADATA();
    }

    @Override
    public int getBrowserType() {
        String userAgent = this.request.getHeader("USER-AGENT");
        if (userAgent != null) {
            if (userAgent.indexOf("Edg") != -1) {
                return 9;
            }
            if (userAgent.toUpperCase().indexOf("CHROME") != -1) {
                return 7;
            }
            if (userAgent.toUpperCase().indexOf("FIREFOX") != -1) {
                return 6;
            }
            if (userAgent.indexOf("MSIE") != -1) {
                if (userAgent.indexOf("Windows CE") != -1) {
                    return 5;
                }
                return 1;
            }
            if (userAgent.toUpperCase().indexOf("SAFARI") != -1) {
                return 8;
            }
            if (userAgent.indexOf("Trident") != -1) {
                return 1;
            }
            if (userAgent.toUpperCase().indexOf("OPERA") != -1) {
                return 3;
            }
            if (userAgent.toUpperCase().indexOf("MOZILLA/") != -1) {
                return 2;
            }
            if (userAgent.toUpperCase().indexOf("UP.Browser") != -1) {
                return 4;
            }
            if (USERAGENT_SEARCH_BOT.matcher(userAgent).find()) {
                return 20;
            }
        }
        return 0;
    }

    @Override
    public boolean isIE55() {
        return this.getBrowserType() == 1 && this.getBrowserVersion().trim().startsWith("5");
    }

    @Override
    public String getBrowserVersion() {
        String userAgent = this.request.getHeader("USER-AGENT");
        switch (this.getBrowserType()) {
            case 9: {
                Matcher matcher = EDGE_BROWSER_VERSION_REGEX.matcher(userAgent);
                if (!matcher.find() || matcher.group(1) == null) break;
                return matcher.group(1);
            }
            case 1: 
            case 5: {
                int i = userAgent.indexOf("MSIE");
                if (i >= 0) {
                    int i2 = userAgent.indexOf(";", i);
                    if (i2 == -1) break;
                    String version = userAgent.substring(i + 4, i2).trim();
                    return version.startsWith("7") && userAgent.toLowerCase().indexOf("trident") >= 0 ? "8" : version;
                }
                i = userAgent.indexOf("rv:");
                int i2 = userAgent.indexOf(".", i);
                return userAgent.substring(i + 3, i2).trim();
            }
            case 3: {
                int i = userAgent.indexOf("Opera") + 6;
                int i2 = userAgent.indexOf(" ", i);
                if (i2 == -1) break;
                return userAgent.substring(i, i2).trim();
            }
            case 6: {
                int i = userAgent.indexOf("Firefox/") + 8;
                int i2 = userAgent.indexOf(" ", i);
                if (i2 != -1) {
                    return userAgent.substring(i, i2).trim();
                }
                return userAgent.substring(i).trim();
            }
            case 7: {
                int i = userAgent.indexOf("Chrome/") + 7;
                int i2 = userAgent.indexOf(" ", i);
                if (i2 == -1) break;
                return userAgent.substring(i, i2).trim();
            }
            case 8: {
                int i = userAgent.indexOf("Version/") + 8;
                int i2 = userAgent.indexOf(" ", i);
                if (i2 == -1) break;
                return userAgent.substring(i, i2).trim();
            }
            case 2: {
                int i = userAgent.indexOf("Mozilla/") + 8;
                int i2 = userAgent.indexOf(" ", i);
                if (i2 == -1) break;
                return userAgent.substring(i, i2).trim();
            }
            case 4: {
                int i = userAgent.indexOf("UP.Browser/") + 8;
                int i2 = userAgent.indexOf("-", i);
                if (i2 == -1) break;
                return userAgent.substring(i, i2).trim();
            }
        }
        return "";
    }

    @Override
    public Object getSessionValue(String name) {
        block5: {
            try {
                if (this.request == null) break block5;
                Object obj = null;
                IHttpSession session = this.request.getSession(false);
                if (session != null) {
                    try {
                        obj = session.getAttribute(CommonUtil.upper((String)name));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                return obj;
            }
            catch (Exception e) {
                log.error(String.format("Failed getting sessionValue '%s'", name), (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public void webPutSessionValue(String name, Object value) {
        if (this.request != null) {
            try {
                this.request.getSession(true).setAttribute(CommonUtil.upper((String)name), value);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void webPutSessionValue(String name, long value) {
        if (this.request != null) {
            try {
                this.request.getSession(true).setAttribute(CommonUtil.upper((String)name), (Object)new Long(value));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void webPutSessionValue(String name, double value) {
        if (this.request != null) {
            try {
                this.request.getSession(true).setAttribute(CommonUtil.upper((String)name), (Object)new Double(value));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void webSessionId(String[] id) {
        id[0] = this.webSessionId();
    }

    @Override
    public String webSessionId() {
        if (this.request != null) {
            return this.request.getSession(true).getId();
        }
        return "0";
    }

    @Override
    public ICookie[] getCookies() {
        ICookie[] cookies = new ICookie[]{};
        if (this.request != null) {
            try {
                cookies = this.request.getCookies();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cookies;
    }

    @Override
    public String getCookie(String name) {
        if (this.cookies.containsKey(name)) {
            return WebUtils.decodeCookie(this.cookies.get(name));
        }
        if (this.request != null) {
            try {
                ICookie[] cookies = this.request.getCookies();
                if (cookies != null) {
                    for (int i = 0; i < cookies.length; ++i) {
                        ICookie cookie = cookies[i];
                        if (!cookie.getName().equalsIgnoreCase(name)) continue;
                        return WebUtils.decodeCookie(cookie.getValue());
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed getting cookie", (Throwable)e);
            }
        }
        return "";
    }

    @Override
    public byte setCookieRaw(String name, String value, String path, Date expiry, String domain, double secure) {
        return this.setCookieRaw(name, value, path, expiry, domain, secure, Preferences.getDefaultPreferences().getcookie_httponly_default());
    }

    public byte setCookieRaw(String name, String value, String path, Date expiry, String domain, double secure, Boolean httpOnly) {
        if (this.response != null) {
            Cookie cookie = new Cookie(name, value);
            if (path.trim().length() > 0) {
                cookie.setPath(path.trim());
            }
            if (!expiry.equals(CommonUtil.nullDate())) {
                long expiryTime = (expiry.getTime() - new Date().getTime()) / 1000L;
                if (expiryTime < 0L) {
                    expiryTime = 0L;
                }
                cookie.setMaxAge((int)expiryTime);
            }
            if (domain.trim().length() > 0) {
                cookie.setDomain(domain.trim());
            }
            cookie.setSecure(secure != 0.0);
            if (this.servletContext.getMajorVersion() >= 3) {
                cookie.setHttpOnly(httpOnly.booleanValue());
            }
            this.response.addCookie((ICookie)cookie);
            this.cookies.put(name, value);
        }
        return 0;
    }

    @Override
    public byte setCookie(String name, String value, String path, Date expiry, String domain, double secure, Boolean httpOnly) {
        return this.setCookieRaw(name, WebUtils.encodeCookie(value), path, expiry, domain, secure, httpOnly);
    }

    @Override
    public byte setCookie(String name, String value, String path, Date expiry, String domain, double secure) {
        return this.setCookieRaw(name, WebUtils.encodeCookie(value), path, expiry, domain, secure);
    }

    @Override
    public String getServerName() {
        String host = this.getHeader("X-Forwarded-Host");
        if (host.length() > 0) {
            return host;
        }
        String serverNameProperty = ModelContext.getModelContext().getPreferences().getProperty("SERVER_NAME", "");
        if (!StringUtils.isBlank((String)serverNameProperty)) {
            return serverNameProperty;
        }
        if (this.request != null) {
            return this.request.getServerName();
        }
        return "";
    }

    @Override
    public int getServerPort() {
        String port = this.getHeader("X-Forwarded-Port");
        if (port.length() > 0) {
            return Integer.parseInt(port);
        }
        String serverPortProperty = ModelContext.getModelContext().getPreferences().getProperty("SERVER_PORT", "");
        if (!StringUtils.isBlank((String)serverPortProperty)) {
            return Integer.parseInt(serverPortProperty);
        }
        String serverNameProperty = ModelContext.getModelContext().getPreferences().getProperty("SERVER_NAME", "");
        if (serverNameProperty.indexOf(58) != -1) {
            return 80;
        }
        if (this.request != null) {
            return this.request.getServerPort();
        }
        return 80;
    }

    @Override
    public String getScriptPath() {
        String path;
        if (this.request != null && (path = this.request.getRequestURI()) != null) {
            if (path.startsWith("http")) {
                path = this.request.getServletPath();
            }
            if (path != null) {
                int pos = path.lastIndexOf(47);
                if (pos >= 0) {
                    return path.substring(0, pos + 1);
                }
                return path;
            }
        }
        return "";
    }

    @Override
    public int getHttpSecure() {
        String protocol = this.getHeader("X-Forwarded-Proto");
        if (protocol != null && !protocol.equals("")) {
            return protocol.equalsIgnoreCase("https") ? 1 : 0;
        }
        String serverProtocolProperty = ModelContext.getModelContext().getPreferences().getProperty("SERVER_PROTOCOL", "");
        if (!StringUtils.isBlank((String)serverProtocolProperty)) {
            return serverProtocolProperty.equalsIgnoreCase("https") ? 1 : 0;
        }
        if (this.request != null && this.request.getScheme() != null) {
            return this.request.getScheme().equalsIgnoreCase("http") ? 0 : 1;
        }
        return 0;
    }

    @Override
    public byte setContentType(String type) {
        if (this.getResponse() == null) {
            return 1;
        }
        this.contentType = type;
        if (type.equalsIgnoreCase("text/html") && this.useUtf8) {
            type = type + "; charset=utf-8";
        }
        this.response.setContentType(type);
        return 1;
    }

    @Override
    public byte responseContentType(String type) {
        this.setContentType(type);
        return 0;
    }

    @Override
    public String getHeader(String header) {
        String out = this.request.getHeader(header);
        if (out == null) {
            return "";
        }
        return out;
    }

    @Override
    public void sendError(int error) {
        try {
            this.disableResponseEncoding();
            this.response.sendError(error);
        }
        catch (Exception e) {
            log.error("Error " + error, (Throwable)e);
        }
    }

    private void disableResponseEncoding() {
        if (this.compressed) {
            this.setHeader("Content-Encoding", "identity");
        }
    }

    @Override
    public void setQueryString(String qs) {
        this.loadParameters(qs);
    }

    private String removeInternalParms(String query) {
        int idx = (query = this.removeEventPrefix(query)).indexOf(GXNavigationHelper.POPUP_LEVEL);
        if (idx == 1) {
            return "";
        }
        if (idx > 1) {
            query = query.substring(0, idx - 1);
        }
        if ((idx = query.indexOf("gx-no-cache=")) >= 0) {
            idx = idx > 0 ? idx - 1 : idx;
            query = query.substring(0, idx);
        }
        return query;
    }

    @Override
    public String getQueryString() {
        try {
            String query = this.request.getQueryString();
            if (query == null || query.length() == 0) {
                return "";
            }
            if (query.startsWith("?")) {
                query = query.substring(1);
            }
            return this.removeInternalParms(query);
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String removeEventPrefix(String query) {
        if (this.isAjaxEventMode()) {
            int comIdx = query.indexOf(",");
            if (comIdx == -1) {
                comIdx = query.indexOf("&");
            }
            if (comIdx != -1) {
                query = query.substring(comIdx + 1);
            }
        }
        return query;
    }

    @Override
    public String getPackage() {
        String sPath = this.request.getRequestURI();
        if (sPath.indexOf(46) >= 0) {
            return sPath.substring(sPath.lastIndexOf(47) + 1, sPath.lastIndexOf(46) + 1);
        }
        return "";
    }

    @Override
    public String cgiGet(String parm) {
        Hashtable<String, String[]> parsePostData = this.getPostData();
        if (parsePostData != null) {
            String[] val = parsePostData.get(parm.toUpperCase());
            if (val != null) {
                return val[0];
            }
            val = parsePostData.get(parm);
            if (val != null) {
                return val[0];
            }
        }
        return this.getHeader(parm);
    }

    @Override
    public boolean isFileParm(String parm) {
        if (ServletFileUpload.isMultipartContent((IHttpServletRequest)this.request)) {
            return this.getPostedparts().hasitembyname(parm);
        }
        return false;
    }

    @Override
    public String cgiGetFileName(String parm) {
        FileItemCollection files = this.getPostedparts();
        FileItem fileItem = files.itembyname(parm);
        if (fileItem != null) {
            String fileName = fileItem.getName();
            int dDelimIdx = fileName.lastIndexOf("\\");
            if (dDelimIdx != -1 && dDelimIdx < fileName.length() - 1) {
                fileName = fileName.substring(dDelimIdx + 1);
            }
            return CommonUtil.getFileName((String)fileName);
        }
        return "";
    }

    @Override
    public String cgiGetFileType(String parm) {
        FileItemCollection files = this.getPostedparts();
        FileItem fileItem = files.itembyname(parm);
        if (fileItem != null) {
            return CommonUtil.getFileType((String)fileItem.getName());
        }
        return "";
    }

    @Override
    public void getMultimediaValue(String internalName, String[] blobVar, String[] uriVar) {
        String type = this.cgiGet(internalName + "Option");
        if (type.compareTo("file") == 0) {
            if (blobVar[0] != null && blobVar[0].trim().length() != 0) {
                String filename = this.cgiGetFileName(internalName);
                String filetype = this.cgiGetFileType(internalName);
                uriVar[0] = GXFile.getCompleteFileName(filename, filetype);
            }
            if (blobVar[0] == null || blobVar[0].trim().length() == 0) {
                blobVar[0] = this.cgiGet(internalName + "_gxBlob");
            }
            if (blobVar[0] == null || blobVar[0].trim().length() == 0) {
                uriVar[0] = "";
            }
        } else {
            Matcher matcher = MULTIMEDIA_GXI_GRID_PATTERN.matcher(internalName);
            uriVar[0] = matcher.matches() ? this.cgiGet(matcher.group(1) + "_GXI" + matcher.group(2)) : this.cgiGet(internalName + "_GXI");
            blobVar[0] = "";
        }
    }

    @Override
    public void changePostValue(String ctrl, String value) {
        this.getPostData().put(ctrl, new String[]{value});
    }

    @Override
    public void deletePostValue(String ctrl) {
        this.getPostData().remove(ctrl);
    }

    @Override
    public void DeletePostValuePrefix(String sPrefix) {
        Hashtable<String, String[]> postData = this.getPostData();
        Set<String> keys = postData.keySet();
        Vector<String> toDelete = new Vector<String>();
        for (String key : keys) {
            if (key == null || !key.startsWith(sPrefix + "nRC_GXsfl_")) continue;
            toDelete.addElement(key);
        }
        Iterator itr = toDelete.iterator();
        while (itr.hasNext()) {
            postData.remove(itr.next());
        }
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.httpRes;
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.httpReq;
    }

    @Override
    public void setHttpRequest(HttpRequest httpReq) {
        this.httpReq = httpReq;
    }

    @Override
    public IHttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(IHttpServletRequest request) {
        this.request = request;
    }

    private static Hashtable<String, String[]> parseMultipartPostData(FileItemCollection fileItemCollection) {
        return HttpUtils.parseMultipartPostData(fileItemCollection);
    }

    public static Hashtable<String, String[]> parsePostData(IHttpServletRequest request, IServletInputStream in) {
        try {
            return HttpUtils.parsePostData(in);
        }
        catch (IllegalArgumentException e) {
            return HttpUtils.parsePostData(request);
        }
    }

    private boolean useCustomRedirect() {
        if (customRedirect == null) {
            String serverInfo = this.servletContext.getServerInfo();
            customRedirect = new Boolean(System.getProperty("gx.custom.redirect") != null);
        }
        return customRedirect;
    }

    @Override
    public String getDefaultPath() {
        if (this.servletContext == null) {
            return "";
        }
        String path = this.servletContext.getRealPath("/");
        if (path == null && this.servletContext.getAttribute(this.servletContext.getTEMPDIR()) != null) {
            return ((File)this.servletContext.getAttribute(this.servletContext.getTEMPDIR())).getAbsolutePath();
        }
        if (path == null && (path = System.getenv("LAMBDA_TASK_ROOT")) == null) {
            path = System.getProperty("LAMBDA_TASK_ROOT");
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public void setDefaultPath(String path) {
    }

    @Override
    public WebSession getWebSession() {
        return this.webSession;
    }

    @Override
    public void redirect(String url) {
        this.redirect(url, false);
    }

    public void redirect(String url, boolean bSkipPushUrl) {
        this.SkipPushUrl = bSkipPushUrl;
        if (!this.Redirected) {
            this.redirect_impl(url, null);
        }
    }

    public void redirect_impl(String url, IGXWindow win) {
        this.redirect_http(url);
    }

    protected void redirect_http(String url) {
        this.Redirected = true;
        if (this.getResponseCommited()) {
            return;
        }
        if (url != null && url.trim().length() != 0) {
            try {
                if (this.forwardAsWebCallMethod()) {
                    IRequestDispatcher dispatcher = this.getRequest().getRequestDispatcher(url);
                    if (dispatcher != null) {
                        this.doForward(dispatcher);
                    } else {
                        this.doRedirect(url);
                    }
                } else {
                    this.pushUrlSessionStorage();
                    if (this.useCustomRedirect()) {
                        this.getResponse().setHeader("Location", url, false);
                        this.getRequest().setAttribute("gx_webcall_method", (Object)"customredirect");
                        this.getResponse().setStatus(HttpServletResponse.getSC_MOVED_TEMPORARILY());
                    } else {
                        this.doRedirect(url);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Redirect : " + e);
            }
        }
        this.setResponseCommited();
    }

    private void doRedirect(String url) throws IOException {
        this.getRequest().setAttribute("gx_webcall_method", (Object)"redirect");
        this.response.setStatus(HttpServletResponse.getSC_MOVED_PERMANENTLY());
        this.response.setHeader("Location", url, false);
        this.sendCacheHeaders();
    }

    public void sendCacheHeaders() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+00"));
        cal.setTime(new Date());
        long utcNow = cal.getTimeInMillis();
        this.getResponse().addDateHeader("Expires", utcNow);
        this.getResponse().addDateHeader("Last-Modified", utcNow);
        this.getResponse().addHeader("Cache-Control", "max-age=0, no-cache, no-store, must-revalidate");
    }

    private void doForward(IRequestDispatcher dispatcher) throws Exception {
        this.getRequest().setAttribute("gx_webcall_method", (Object)"forward");
        dispatcher.forward(this.getRequest(), this.getResponse());
    }

    protected void pushUrlSessionStorage() {
        if (this.context != null && this.context.getHttpContext().isLocalStorageSupported() && !this.SkipPushUrl) {
            this.context.getHttpContext().pushCurrentUrl();
        }
        this.SkipPushUrl = false;
    }

    @Override
    public void setStream() {
        if (this.getResponse() == null) {
            return;
        }
        try {
            if (this.streamSet) {
                return;
            }
            this.streamSet = true;
            if (this.mustUseWriter()) {
                this.setWriter(this.getResponse().getWriter());
            } else {
                String accepts;
                if (this.buffered) {
                    this.buffer = new FastByteArrayOutputStream();
                    this.setOutputStream((OutputStream)this.buffer);
                } else {
                    this.setOutputStream(this.getResponse().getOutputStream().getOutputStream());
                }
                if (this.compressed && (accepts = this.getHeader("Accept-Encoding")) != null && accepts.indexOf("gzip") >= 0) {
                    this.setHeader("Content-Encoding", "gzip");
                    this.setOutputStream(new GZIPOutputStream(this.getOutputStream()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void flushStream() {
        this.proxyCookieValues();
        try {
            if (this.buffered) {
                this.closeOutputStream();
                IHttpServletResponse response = this.getResponse();
                if (this.buffer != null && !response.isCommitted()) {
                    IServletOutputStream stream = response.getOutputStream();
                    response.setContentLength(this.buffer.size());
                    this.buffer.writeToOutputStream(stream.getOutputStream());
                    stream.close();
                }
            } else {
                this.closeOutputStream();
            }
        }
        catch (IOException e) {
            log.error("Error flushing stream", (Throwable)e);
        }
    }

    private void proxyCookieValues() {
        if (this.sameSiteMode == null) {
            String sameSiteModeValue = Application.getClientPreferences().getProperty("SAMESITE_COOKIE", "");
            this.sameSiteMode = sameSiteModeValue.equals(SAME_SITE_NONE) || sameSiteModeValue.equals(SAME_SITE_LAX) || sameSiteModeValue.equals(SAME_SITE_STRICT) ? sameSiteModeValue : "";
        }
        if (!this.sameSiteMode.equals("")) {
            this.addSameSiteCookieAttribute(this.getResponse());
        }
    }

    private void addSameSiteCookieAttribute(IHttpServletResponse response) {
        Collection headers = response.getHeaders(SET_COOKIE);
        boolean firstHeader = true;
        for (String header : headers) {
            if (firstHeader) {
                response.setHeader(SET_COOKIE, String.format("%s; %s", header, "SameSite=" + this.sameSiteMode), false);
                firstHeader = false;
                continue;
            }
            response.addHeader(SET_COOKIE, String.format("%s; %s", header, "SameSite=" + this.sameSiteMode));
        }
    }

    @Override
    public void cleanup() {
        ModelContext.deleteThreadContext();
        if (this.postData != null) {
            this.postData.clear();
            this.postData = null;
        }
        if (this.fileItemCollection != null) {
            for (int j = 0; this.fileItemCollection.getCount() > j; ++j) {
                FileItem fileItem1 = this.fileItemCollection.item(j);
                Object var2_2 = null;
            }
            this.fileItemCollection.clear();
            this.fileItemCollection = null;
            this.lstParts = null;
        }
    }

    public void writeText(String text) {
        if (this.getResponseCommited()) {
            return;
        }
        this._writeText(text);
    }

    @Override
    public boolean isHttpContextNull() {
        return false;
    }

    @Override
    public boolean isHttpContextWeb() {
        return true;
    }
}

