/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.CommonUtil;
import com.genexus.internet.HttpContext;
import com.genexus.servlet.IServletInputStream;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.util.CacheAPI;
import com.genexus.webpanels.BlobsCleaner;
import com.genexus.webpanels.FileItem;
import com.genexus.webpanels.FileItemCollection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.UUID;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static Logger log = LogManager.getLogger(HttpUtils.class);
    static Hashtable nullHashtable = new Hashtable();

    public static Hashtable<String, String[]> parseMultipartPostData(FileItemCollection fileItemCollection) {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        for (int i = 0; i < fileItemCollection.getCount(); ++i) {
            String itemFilePath;
            FileItem item = fileItemCollection.item(i);
            if (item.isFormField()) {
                try {
                    HttpUtils.pushValue(ht, item.getFieldName(), item.getString("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    HttpUtils.pushValue(ht, item.getFieldName(), "");
                }
                continue;
            }
            if (item.getSize() == 0L) {
                itemFilePath = "";
            } else {
                String keyId = HttpUtils.getUploadFileKey();
                itemFilePath = HttpUtils.getUploadFileId(keyId);
                String fileExtension = CommonUtil.getFileType((String)item.getName());
                HttpUtils.CacheUploadFile(keyId, item.getPath(), CommonUtil.getFileName((String)item.getName()) + "." + fileExtension, fileExtension);
            }
            HttpUtils.pushValue(ht, item.getFieldName(), itemFilePath);
        }
        return ht;
    }

    public static Hashtable<String, String[]> parseQueryString(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), sb);
            String val = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), sb);
            HttpUtils.pushValue(ht, key, val.replace("\u0000", ""));
        }
        return ht;
    }

    public static void pushValue(Hashtable<String, String[]> ht, String key, String val) {
        String[] valArray = null;
        if (ht.containsKey(key)) {
            String[] oldVals = ht.get(key);
            valArray = new String[oldVals.length + 1];
            for (int i = 0; i < oldVals.length; ++i) {
                valArray[i] = oldVals[i];
            }
            valArray[oldVals.length] = val;
        } else {
            valArray = new String[]{val};
        }
        ht.put(key, valArray);
    }

    public static Hashtable<String, String[]> parsePostData(IHttpServletRequest request) {
        String paramName = null;
        String[] paramValues = null;
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            paramName = (String)params.nextElement();
            paramValues = request.getParameterValues(paramName);
            String value = "";
            for (int i = 0; i < paramValues.length; ++i) {
                value = String.valueOf(value) + paramValues[i].toString();
            }
            HttpUtils.pushValue(ht, paramName, value);
        }
        return ht;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable<String, String[]> parsePostData(IServletInputStream in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        try (InputStream is = in.getInputStream();){
            Hashtable<String, String[]> hashtable = HttpUtils.parseQueryString(IOUtils.toString((InputStream)is, (String)"8859_1"));
            return hashtable;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            block11: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '+': {
                        stream.write(32);
                        continue block11;
                    }
                    case '%': {
                        try {
                            stream.write(Integer.parseInt(s.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block11;
                        }
                        catch (NumberFormatException numberformatexception) {
                            throw new IllegalArgumentException();
                        }
                        catch (StringIndexOutOfBoundsException stringindexoutofboundsexception) {
                            String rest = s.substring(i);
                            stream.write(s.substring(i).getBytes("UTF8"));
                            if (rest.length() != 2) continue block11;
                            ++i;
                            continue block11;
                        }
                    }
                    default: {
                        stream.write(c);
                    }
                }
            }
        }
        catch (IOException e) {
            return HttpUtils.parseNameVMEncoding(s, sb);
        }
        try {
            sb.append(new String(stream.toByteArray(), "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            sb.append(stream.toByteArray());
        }
        return sb.toString();
    }

    private static String parseNameVMEncoding(String s, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberformatexception) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringindexoutofboundsexception) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static StringBuffer getRequestURL(IHttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = req.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url;
    }

    public static String getUploadFileKey() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getUploadFileId(String keyId) {
        return "gxupload:" + keyId;
    }

    public static void CacheUploadFile(String keyId, String uploadFilePath, String fileName, String fileExtension) {
        try {
            JSONObject jObj = new JSONObject();
            jObj.put("path", (Object)uploadFilePath);
            jObj.put("fileName", (Object)fileName);
            jObj.put("fileExtension", (Object)fileExtension);
            CacheAPI.files().set(keyId, jObj.toString(), 10);
        }
        catch (JSONException e) {
            log.debug("Error Caching Upload File", (Throwable)e);
        }
        BlobsCleaner.getInstance().addBlobFile(uploadFilePath);
    }

    public static boolean isUploadRequest(HttpContext context) {
        return context.getRequest().getRequestURI().endsWith("/gxobject");
    }
}

