/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.CommonUtil;
import com.genexus.internet.HttpContext;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpSession;
import com.genexus.util.Encryption;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class WebSession {
    private IHttpServletRequest request;
    private Hashtable<String, Object> sessionValues;
    private boolean useLocalSession;
    private static Set<String> internalKeys = new HashSet<String>(Arrays.asList(Encryption.AJAX_ENCRYPTION_KEY, HttpContext.GX_NAV_HELPER, HttpContext.GXTheme, HttpContext.GXLanguage));

    public WebSession(IHttpServletRequest request) {
        this.request = request;
        this.sessionValues = null;
        this.updateSessionInvalidated();
    }

    private IHttpSession getSession() {
        return this.getSession(true);
    }

    private IHttpSession getSession(boolean createIfNotExists) {
        if (this.useLocalSession || this.request == null) {
            return null;
        }
        return this.request.getSession(createIfNotExists);
    }

    private void updateSessionInvalidated() {
        this.useLocalSession = this.useLocalSession || Thread.currentThread().getName().startsWith("SubmitThread-") || this.request == null;
    }

    private void putHashValue(String key, Object value) {
        if (this.sessionValues == null) {
            this.sessionValues = new Hashtable();
        }
        this.sessionValues.put(key, value);
    }

    private Object getHashValue(String key) {
        if (this.sessionValues != null) {
            return this.sessionValues.get(key);
        }
        return null;
    }

    private void removeHashValue(String key) {
        if (this.sessionValues != null) {
            this.sessionValues.remove(key);
        }
    }

    private void clearHashValues() {
        if (this.sessionValues != null) {
            this.sessionValues.clear();
            this.sessionValues = null;
        }
    }

    public void invalidate() {
        this.useLocalSession = true;
    }

    public String getId() {
        if (!this.useLocalSession) {
            return this.getSession().getId();
        }
        return "";
    }

    public void setValue(String key, String value) {
        this.setAttribute(key, value);
    }

    public String getValue(String key) {
        return this.getAttribute(key);
    }

    public void remove(String key) {
        this.removeAttribute(key);
    }

    public void setObjectAttribute(String key, Object value) {
        this.updateSessionInvalidated();
        key = this.normalizeKey(key);
        IHttpSession session = this.getSession(true);
        if (this.useLocalSession || session == null) {
            this.putHashValue(key, value);
            return;
        }
        session.setAttribute(key, value);
    }

    public void setAttribute(String key, String value) {
        this.setObjectAttribute(key, value);
    }

    public String getAttribute(String key) {
        Object out = this.getObjectAttribute(key);
        if (out == null) {
            return "";
        }
        return (String)out;
    }

    public Object getObjectAttribute(String key) {
        this.updateSessionInvalidated();
        key = this.normalizeKey(key);
        Object out = null;
        if (this.useLocalSession) {
            return this.getHashValue(key);
        }
        IHttpSession session = this.getSession(false);
        if (session != null) {
            out = session.getAttribute(key);
        }
        return out;
    }

    public void removeAttribute(String key) {
        this.updateSessionInvalidated();
        key = this.normalizeKey(key);
        if (this.useLocalSession) {
            this.removeHashValue(key);
            return;
        }
        IHttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    public void destroy() {
        this.updateSessionInvalidated();
        if (!this.useLocalSession) {
            IHttpSession session = this.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        } else {
            this.clear();
        }
    }

    public void renew() {
        this.updateSessionInvalidated();
        if (!this.useLocalSession) {
            IHttpSession session = this.getSession(false);
            if (session != null) {
                Map<String, Object> internalValues = this.backupInternalKeys(session);
                session.invalidate();
                this.restoreInternalKeys(internalValues);
            }
        } else {
            this.clear();
        }
    }

    private Map<String, Object> backupInternalKeys(IHttpSession session) {
        HashMap<String, Object> internalValues = new HashMap<String, Object>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            Object value;
            String key = (String)e.nextElement();
            if (!internalKeys.contains(key) || (value = this.getObjectAttribute(key)) == null) continue;
            internalValues.put(key, value);
        }
        return internalValues;
    }

    private void restoreInternalKeys(Map<String, Object> internalValues) {
        for (String key : internalValues.keySet()) {
            this.setObjectAttribute(key, internalValues.get(key));
        }
    }

    public void clear() {
        this.updateSessionInvalidated();
        if (!this.useLocalSession) {
            IHttpSession session = this.getSession(false);
            if (session != null) {
                Vector<String> toRemove = new Vector<String>();
                Enumeration e = session.getAttributeNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (internalKeys.contains(key)) continue;
                    toRemove.add(key);
                }
                e = toRemove.elements();
                while (e.hasMoreElements()) {
                    this.remove((String)e.nextElement());
                }
                toRemove.clear();
            }
        } else {
            this.clearHashValues();
        }
    }

    private String normalizeKey(String key) {
        return CommonUtil.rtrim((String)CommonUtil.upper((String)key));
    }

    public static boolean isSessionExpired(IHttpServletRequest request) {
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }
}

