/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.GXutil;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.HttpContext;
import com.genexus.util.Encoder;
import com.genexus.util.Encryption;
import com.genexus.webpanels.GXMultiCall;
import com.genexus.xml.XMLReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class WebUtils {
    public static final ILogger logger = LogManager.getLogger(WebUtils.class);
    public static final String STATIC_DYNURL = "genexus.staticweb.dynurl";
    private static final String gxApplicationClassesFileName = "GXApplicationClasses.txt";
    private static final String gxApplicationServicesClassesFileName = "GeneXus.services";
    private static final String gxApplicationAIServicesClassesFileName = "GeneXusAI.services";
    private static final String gxApplicationChatbotServicesClassesFileName = "Chatbot.services";

    public static String encodeCookie(String parm) {
        return PrivateUtilities.URLEncode(parm, "UTF8");
    }

    public static String decodeCookie(String parm) {
        return Encoder.decodeURL((String)parm);
    }

    public static Date parseDateParm(String valueString) {
        if (valueString.trim().length() == 0 || !Character.isDigit(valueString.trim().charAt(0))) {
            return CommonUtil.nullDate();
        }
        return CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)0, (int)0, (int)0);
    }

    public static Date parseDTimeParm(String valueString) {
        if (valueString.trim().length() == 0) {
            return CommonUtil.nullDate();
        }
        return CommonUtil.ymdhmsToT_noYL((int)((int)CommonUtil.val((String)valueString.substring(0, 4))), (int)((int)CommonUtil.val((String)valueString.substring(4, 6))), (int)((int)CommonUtil.val((String)valueString.substring(6, 8))), (int)((int)CommonUtil.val((String)valueString.substring(8, 10))), (int)((int)CommonUtil.val((String)valueString.substring(10, 12))), (int)((int)CommonUtil.val((String)valueString.substring(12, 14))));
    }

    public static String getDynURL() {
        return PrivateUtilities.addLastChar(WebUtils.getSystemProperty(STATIC_DYNURL), "/");
    }

    public static String getSystemProperty(String property) {
        return PrivateUtilities.getSystemProperty(property, "");
    }

    public static String getHTMLColor(long parm) {
        return "#" + CommonUtil.padl((String)Long.toHexString(parm), (int)6, (String)"0");
    }

    public static String htmlDecode(String str) {
        if (str == null) {
            return "";
        }
        if (str.indexOf("&") < 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        WebUtils.htmlDecode(str, buffer);
        return buffer.toString();
    }

    public static String htmlEncode(String str) {
        return WebUtils.htmlEncode(str, false);
    }

    public static String htmlEncode(String str, boolean inputValue) {
        StringBuilder buffer = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                buffer.append("&lt;");
            } else if (character == '>') {
                buffer.append("&gt;");
            } else if (character == '\'') {
                WebUtils.htmlEncode(39, buffer);
            } else if (character == '&') {
                buffer.append("&amp;");
            } else if (!inputValue) {
                if (character == '\"') {
                    buffer.append("&quot;");
                } else if (character == '\t') {
                    WebUtils.htmlEncode(9, buffer);
                } else if (character == '!') {
                    WebUtils.htmlEncode(33, buffer);
                } else if (character == '#') {
                    WebUtils.htmlEncode(35, buffer);
                } else if (character == '$') {
                    WebUtils.htmlEncode(36, buffer);
                } else if (character == '%') {
                    WebUtils.htmlEncode(37, buffer);
                } else if (character == '(') {
                    WebUtils.htmlEncode(40, buffer);
                } else if (character == ')') {
                    WebUtils.htmlEncode(41, buffer);
                } else if (character == '*') {
                    WebUtils.htmlEncode(42, buffer);
                } else if (character == '+') {
                    WebUtils.htmlEncode(43, buffer);
                } else if (character == ',') {
                    WebUtils.htmlEncode(44, buffer);
                } else if (character == '-') {
                    WebUtils.htmlEncode(45, buffer);
                } else if (character == '.') {
                    WebUtils.htmlEncode(46, buffer);
                } else if (character == '/') {
                    WebUtils.htmlEncode(47, buffer);
                } else if (character == ':') {
                    WebUtils.htmlEncode(58, buffer);
                } else if (character == ';') {
                    WebUtils.htmlEncode(59, buffer);
                } else if (character == '=') {
                    WebUtils.htmlEncode(61, buffer);
                } else if (character == '?') {
                    WebUtils.htmlEncode(63, buffer);
                } else if (character == '@') {
                    WebUtils.htmlEncode(64, buffer);
                } else if (character == '[') {
                    WebUtils.htmlEncode(91, buffer);
                } else if (character == '\\') {
                    WebUtils.htmlEncode(92, buffer);
                } else if (character == ']') {
                    WebUtils.htmlEncode(93, buffer);
                } else if (character == '^') {
                    WebUtils.htmlEncode(94, buffer);
                } else if (character == '_') {
                    WebUtils.htmlEncode(95, buffer);
                } else if (character == '`') {
                    WebUtils.htmlEncode(96, buffer);
                } else if (character == '{') {
                    WebUtils.htmlEncode(123, buffer);
                } else if (character == '|') {
                    WebUtils.htmlEncode(124, buffer);
                } else if (character == '}') {
                    WebUtils.htmlEncode(125, buffer);
                } else if (character == '~') {
                    WebUtils.htmlEncode(126, buffer);
                } else {
                    buffer.append(character);
                }
            } else {
                buffer.append(character);
            }
            character = iterator.next();
        }
        return buffer.toString();
    }

    private static void htmlEncode(Integer i, StringBuilder buffer) {
        String padding = "";
        if (i <= 9) {
            padding = "00";
        } else if (i <= 99) {
            padding = "0";
        }
        String number = padding + i.toString();
        buffer.append("&#" + number + ";");
    }

    private static void htmlDecode(String str, StringBuffer buffer) {
        if (str != null) {
            if (str.indexOf("&") < 0) {
                buffer.append(str);
            } else {
                int length = str.length();
                for (int i = 0; i < length; ++i) {
                    int index;
                    int ch = str.charAt(i);
                    if (ch == 38 && (index = str.indexOf(";", i)) > 0) {
                        String entity = str.substring(i + 1, index);
                        if (entity.charAt(0) == '#' && entity.length() > 1) {
                            try {
                                ch = entity.charAt(1) == 'x' || entity.charAt(1) == 'X' ? (int)((char)Integer.parseInt(entity.substring(2), 16)) : (int)((char)Integer.parseInt(entity.substring(1)));
                                i = index;
                            }
                            catch (Throwable e) {
                                ++i;
                            }
                        } else {
                            i = index;
                            int ch2 = 0;
                            if (entity.equals("quot")) {
                                ch2 = 34;
                            } else if (entity.equals("amp")) {
                                ch2 = 38;
                            } else if (entity.equals("lt")) {
                                ch2 = 60;
                            } else if (entity.equals("gt")) {
                                ch2 = 62;
                            } else if (entity.equals("nbsp")) {
                                ch2 = 32;
                            }
                            if (ch2 != 0) {
                                ch = ch2;
                            } else {
                                buffer.append('&');
                                buffer.append(entity);
                                buffer.append(';');
                            }
                        }
                    }
                    buffer.append((char)ch);
                }
            }
        }
    }

    public static String getEncodedContentDisposition(String value, int browserType) {
        int filenameIdx = value.toLowerCase().indexOf("filename");
        int eqIdx = value.toLowerCase().indexOf("=", filenameIdx);
        if (filenameIdx == -1 || eqIdx == -1 || browserType == 8) {
            return value;
        }
        String filename = value.substring(eqIdx + 1).trim();
        value = value.substring(0, filenameIdx) + String.format("filename*=UTF-8''%1$s; filename=\"%1$s\"", PrivateUtilities.URLEncode(filename, "UTF8"));
        return value;
    }

    protected static Object[] parmsToObjectArray(ModelContext context, String parms, String url) {
        Object[] parmsArray;
        String[] split;
        boolean useNamedParameters;
        String name;
        int questIdx;
        String encKey = WebUtils.parmsEncryptionKey(context);
        parms = WebUtils.decryptParm(parms, encKey);
        if (encKey != null && encKey.length() != 0 && (questIdx = url.indexOf("?")) != -1 && parms.startsWith(name = url.substring(0, questIdx))) {
            parms = parms.substring(name.length());
        }
        boolean endsWithSeparator = false;
        boolean bl = useNamedParameters = ModelContext.getModelContext().getPreferences().getProperty("UseNamedParameters", "1").equals("1") && parms.contains("=");
        if (parms.endsWith(",") && !useNamedParameters || parms.endsWith("=") && useNamedParameters) {
            parms = parms + "_";
            endsWithSeparator = true;
        }
        String[] stringArray = split = useNamedParameters ? parms.split("&") : parms.split(",");
        if (endsWithSeparator) {
            String string = split[split.length - 1] = useNamedParameters ? "_= " : "";
        }
        if (parms.endsWith(",")) {
            parmsArray = new Object[split.length + 1];
            parmsArray[parmsArray.length - 1] = "";
        } else {
            parmsArray = new Object[split.length];
        }
        for (int i = 0; i < split.length; ++i) {
            parmsArray[i] = useNamedParameters ? GXutil.URLDecode(split[i].split("=")[1]) : GXutil.URLDecode(split[i]);
        }
        return parmsArray;
    }

    public static String decryptParm(Object parm, String encryptionKey) {
        String value = parm.toString();
        try {
            if (!encryptionKey.isEmpty()) {
                String strValue = value.toString();
                if (CommonUtil.strcmp((String)CommonUtil.right((String)(strValue = Encryption.uridecrypt64((String)strValue, (String)encryptionKey)), (int)6), (String)Encryption.checksum((String)CommonUtil.left((String)strValue, (int)(CommonUtil.len((String)strValue) - 6)), (int)6)) == 0) {
                    value = CommonUtil.left((String)strValue, (int)(CommonUtil.len((String)strValue) - 6));
                }
            }
            return value;
        }
        catch (Exception exception) {
            return value;
        }
    }

    public static String parmsEncryptionKey(ModelContext context) {
        String keySourceType = Application.getClientPreferences().getUSE_ENCRYPTION();
        if (keySourceType.isEmpty()) {
            return "";
        }
        return WebUtils.getEncryptionKey(context, keySourceType);
    }

    public static String getEncryptionKey(ModelContext context, String keySourceType) {
        String encryptionKey;
        keySourceType = keySourceType.isEmpty() ? Application.getClientPreferences().getUSE_ENCRYPTION() : keySourceType;
        switch (keySourceType.toUpperCase(Locale.ROOT)) {
            case "SESSION": {
                encryptionKey = Encryption.decrypt64((String)((HttpContext)context.getHttpContext()).getCookie("GX_SESSION_ID"), (String)context.getServerKey());
                break;
            }
            default: {
                encryptionKey = context.getSiteKey();
            }
        }
        if (encryptionKey.isEmpty()) {
            logger.error(String.format("Encryption Key cannot be empty - Key Source: %s", keySourceType));
        }
        return encryptionKey;
    }

    private static InputStream getInputStreamFile(Class<?> gxAppClass, String fileName) throws FileNotFoundException {
        InputStream is = gxAppClass.getResourceAsStream(fileName);
        if (is == null) {
            is = new FileInputStream(new File(fileName));
        }
        return is;
    }

    public static void getGXApplicationClasses(Class<?> gxAppClass, Set<Class<?>> rrcs) {
        try (InputStream is = WebUtils.getInputStreamFile(gxAppClass, gxApplicationClassesFileName);){
            BufferedReader input = new BufferedReader(new InputStreamReader(is, "UTF8"));
            String restClass = input.readLine();
            while (restClass != null) {
                try {
                    rrcs.add(Class.forName(restClass));
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Could not load Class from GXApplicationClasses file " + e.getMessage(), (Throwable)e);
                }
                restClass = input.readLine();
            }
            input.close();
            is.close();
            rrcs.add(GXMultiCall.class);
        }
        catch (Exception e) {
            logger.error("Could not load Class from GXApplicationClasses file.", (Throwable)e);
        }
    }

    public static void AddExternalServices(Class<?> gxAppClass, Set<Class<?>> rrcs) {
        WebUtils.AddExternalServicesFile(gxAppClass, rrcs, gxApplicationServicesClassesFileName);
        WebUtils.AddExternalServicesFile(gxAppClass, rrcs, gxApplicationAIServicesClassesFileName);
        WebUtils.AddExternalServicesFile(gxAppClass, rrcs, gxApplicationChatbotServicesClassesFileName);
    }

    public static void AddExternalServicesFile(Class<?> gxAppClass, Set<Class<?>> rrcs, String servicesClassesFileName) {
        try {
            InputStream is = WebUtils.getInputStreamFile(gxAppClass, servicesClassesFileName);
            if (is != null) {
                String xmlstring = PrivateUtilities.BOMInputStreamToStringUTF8(is);
                XMLReader reader = new XMLReader();
                reader.openFromString(xmlstring);
                if (reader.getErrCode() == 0) {
                    while (reader.readType(1, "Service") > 0) {
                        Class serviceClass = WebUtils.processRestService(reader);
                        if (serviceClass == null) continue;
                        rrcs.add(serviceClass);
                    }
                    reader.close();
                }
                is.close();
            }
        }
        catch (FileNotFoundException is) {
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error loading External Services classes ", (Throwable)e);
        }
        catch (IOException ioe) {
            logger.error("Error loading External Services classes ", (Throwable)ioe);
        }
    }

    public static Class processRestService(XMLReader reader) {
        String className = reader.getAttributeByName("fullName");
        try {
            return Class.forName(className + "_services_rest");
        }
        catch (ClassNotFoundException e) {
            logger.warn("Error loading rest service: '" + className + "_services_rest'", (Throwable)e);
            return null;
        }
    }
}

