/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.CommonUtil;
import com.genexus.cryptography.Utils;
import com.genexus.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

public class GXCertificate {
    private X509Certificate _cert;
    private int _lastError;
    private String _lastErrorDescription;
    private String _alias;
    private PrivateKey _privateKey;
    private PublicKey _publicKey;
    private static KeyStore trustStore;

    public GXCertificate() {
    }

    public GXCertificate(String certPath, String storePassword) {
        this.load(certPath, storePassword);
    }

    public GXCertificate(String certPath, String storePassword, String pKeyPassword) {
        this.load(certPath, storePassword, pKeyPassword);
    }

    public int fromBase64(String base64Data) {
        try {
            byte[] dataBuffer = Base64.decode((String)base64Data);
            ByteArrayInputStream bI = new ByteArrayInputStream(dataBuffer);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this._cert = (X509Certificate)cf.generateCertificate(bI);
        }
        catch (CertificateException e) {
            this.setError(1);
            Utils.logError((Exception)e);
        }
        return this._lastError;
    }

    public int load(String certPath, String storePassword) {
        return this.load(certPath, storePassword, storePassword);
    }

    public int load(String certPath, String storePassword, String pKeyPassword) {
        this.setError(0);
        try (FileInputStream inStream = new FileInputStream(certPath);){
            String lowerCertPath = certPath.toLowerCase();
            if (lowerCertPath.endsWith(".pfx") || lowerCertPath.endsWith(".jks") || lowerCertPath.endsWith(".bks") || lowerCertPath.endsWith(".p12")) {
                KeyStore ks = null;
                ks = lowerCertPath.endsWith(".pfx") || lowerCertPath.endsWith(".p12") ? KeyStore.getInstance("PKCS12") : (lowerCertPath.endsWith(".bks") ? KeyStore.getInstance("BKS") : KeyStore.getInstance("JKS"));
                ks.load(inStream, storePassword.toCharArray());
                this._alias = ks.aliases().nextElement();
                this._cert = (X509Certificate)ks.getCertificate(this._alias);
                this._publicKey = this._cert.getPublicKey();
                try {
                    Key key = ks.getKey(this._alias, pKeyPassword.toCharArray());
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    this._privateKey = keyFactory.generatePrivate(keySpec);
                }
                catch (UnrecoverableKeyException e) {
                    this.setError(5);
                }
            } else if (certPath.endsWith(".cer")) {
                CertificateFactory factory2 = CertificateFactory.getInstance("X.509");
                this._cert = (X509Certificate)factory2.generateCertificate(inStream);
                this._publicKey = this._cert.getPublicKey();
            } else {
                this.setError(1);
            }
        }
        catch (FileNotFoundException e) {
            this.setError(3);
        }
        catch (KeyStoreException e) {
            this.setError(1);
            Utils.logError((Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            Utils.logError((Exception)e);
        }
        catch (CertificateException e) {
            this.setError(1);
            Utils.logError((Exception)e);
        }
        catch (IOException e) {
            this.setError(1);
            Utils.logError((Exception)e);
        }
        catch (InvalidKeySpecException e) {
            this.setError(1);
            Utils.logError((Exception)e);
        }
        return 0;
    }

    public String getSerialNumber() {
        String value = "";
        if (this.certLoaded()) {
            value = this._cert.getSerialNumber().toString();
            value = new BigInteger(value).toString(16);
        }
        return value;
    }

    public String getSubject() {
        String value = "";
        if (this.certLoaded()) {
            value = this._cert.getSubjectDN().getName();
        }
        return value;
    }

    public int getVersion() {
        int value = 0;
        if (this.certLoaded()) {
            value = this._cert.getVersion();
        }
        return value;
    }

    public String getIssuer() {
        String value = "";
        if (this.certLoaded()) {
            value = this._cert.getIssuerDN().getName();
        }
        return value;
    }

    public String getThumbprint() {
        return "";
    }

    public Date getNotAfter() {
        Date value = CommonUtil.resetTime((Date)CommonUtil.nullDate());
        if (this.certLoaded()) {
            value = this._cert.getNotAfter();
        }
        return value;
    }

    public Date getNotBefore() {
        Date value = CommonUtil.resetTime((Date)CommonUtil.nullDate());
        if (this.certLoaded()) {
            value = this._cert.getNotBefore();
        }
        return value;
    }

    public PrivateKey getPrivateKey() {
        return this._privateKey;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public String toBase64() {
        String base64Encoded = "";
        if (this.certLoaded()) {
            try {
                base64Encoded = Base64.encodeBytes((byte[])this._cert.getEncoded());
                this.setError(0);
            }
            catch (CertificateEncodingException e) {
                this.setError(6);
                Utils.logError((Exception)e);
            }
        } else {
            this.setError(1);
        }
        return base64Encoded;
    }

    public boolean hasPrivateKey() {
        if (this.certLoaded()) {
            return this._privateKey != null;
        }
        return false;
    }

    public void check() {
        try {
            this._cert.checkValidity();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<X509Certificate> mylist = new ArrayList<X509Certificate>();
            mylist.add(this._cert);
            CertPath cp = cf.generateCertPath(mylist);
            PKIXParameters params = new PKIXParameters(this.getTrustStore());
            params.setRevocationEnabled(false);
            CertPathValidator cpv = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            cpv.validate(cp, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getTrustStore() {
        if (trustStore == null) {
            FileInputStream is = null;
            try {
                String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
                is = new FileInputStream(filename);
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(is, "changeit".toCharArray());
                is.close();
                trustStore = keyStore;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return trustStore;
    }

    public boolean verify() {
        if (this.certLoaded()) {
            return this.verifyCertificateFromCaCerts();
        }
        return false;
    }

    private boolean verifyCertificateFromCaCerts() {
        boolean bl;
        String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        FileInputStream is = new FileInputStream(filename);
        Throwable throwable = null;
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            String password = "changeit";
            keystore.load(is, password.toCharArray());
            Enumeration<String> aliases = keystore.aliases();
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                certs.add((X509Certificate)keystore.getCertificate(alias));
            }
            X509Certificate[] certsArray = certs.toArray(new X509Certificate[certs.size()]);
            bl = GXCertificate.verifyCertificate(this._cert, certsArray);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    GXCertificate.$closeResource(throwable, is);
                    throw throwable3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        GXCertificate.$closeResource(throwable, is);
        return bl;
    }

    private static boolean verifyCertificate(X509Certificate aCertificate, X509Certificate[] aTrustedCertificates) throws GeneralSecurityException {
        aCertificate.checkValidity();
        for (int i = 0; i < aTrustedCertificates.length; ++i) {
            X509Certificate trustedCert = aTrustedCertificates[i];
            try {
                aCertificate.verify(trustedCert.getPublicKey());
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                continue;
            }
        }
        return false;
    }

    private void setError(int errorCode) {
        this.setError(errorCode, "");
    }

    private void setError(int errorCode, String errDsc) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                this._lastErrorDescription = "Certificate could not be loaded";
                break;
            }
            case 2: {
                this._lastErrorDescription = "Certificate is not trusted.";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Certificate was not found";
                break;
            }
            case 4: {
                this._lastErrorDescription = "Certificate not initialized";
                break;
            }
            case 5: {
                this._lastErrorDescription = "Certificate does not contain private key";
                break;
            }
            case 6: {
                this._lastErrorDescription = "Certificate Encoding exception";
                break;
            }
        }
        if (!errDsc.equals("")) {
            this._lastErrorDescription = !this._lastErrorDescription.equals("") ? String.format("%s - %s", this._lastErrorDescription, errDsc) : errDsc;
        }
    }

    public X509Certificate getCertificate() {
        return this._cert;
    }

    public boolean certLoaded() {
        return this._cert != null;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }
}

