/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.cryptography.Constants;
import com.genexus.cryptography.GXCertificate;
import com.genexus.cryptography.Utils;
import com.genexus.cryptography.exception.PrivateKeyNotFoundException;
import com.genexus.cryptography.exception.PublicKeyNotFoundException;
import com.genexus.cryptography.exception.SignatureException;
import com.genexus.cryptography.signing.IPkcsSign;
import com.genexus.cryptography.signing.standards.PKCS1Signature;
import com.genexus.cryptography.signing.standards.PKCS7Signature;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cms.CMSException;

public class GXSigning {
    private GXCertificate _cert;
    private String _alg;
    private String _hashAlgorithm = "SHA256";
    private String _signAlgorithm = "RSA";
    private IPkcsSign _sign;
    private int _lastError;
    private String _lastErrorDescription;
    private Boolean isDirty = true;
    private Boolean _validateCertificates = true;
    private Utils.PKCSStandard _standard = Constants.DEFAULT_DIGITAL_SIGNATURE_STANDARD;

    public String sign(String text, Boolean detached) {
        this.Initialize();
        String signed = "";
        if (!this.anyError().booleanValue()) {
            try {
                this._sign.setCertificate(this._cert.getCertificate());
                if (this._standard == Utils.PKCSStandard.PKCS7) {
                    ((PKCS7Signature)this._sign).setDetached(detached);
                }
                signed = this._sign.sign(text.getBytes("UTF-8"));
            }
            catch (PrivateKeyNotFoundException e) {
                this.setError(5);
            }
            catch (UnsupportedEncodingException e) {
                Utils.logError((Exception)e);
                this.setError(6, e.getMessage());
            }
            catch (GeneralSecurityException e) {
                Utils.logError((Exception)e);
                this.setError(6, e.getMessage());
            }
            catch (CMSException e) {
                Utils.logError((Exception)((Object)e));
                this.setError(6, e.getMessage());
            }
            catch (IOException e) {
                Utils.logError((Exception)e);
                this.setError(6, e.getMessage());
            }
            catch (PublicKeyNotFoundException e) {
                this.setError(4);
            }
        }
        return signed;
    }

    public Boolean verify(String signature, String text, Boolean detached) {
        this.Initialize();
        Boolean ok = false;
        if (!this.anyError().booleanValue()) {
            try {
                this._sign.setCertificate(this._cert.getCertificate());
                if (this._standard == Utils.PKCSStandard.PKCS7) {
                    ((PKCS7Signature)this._sign).setDetached(detached);
                }
                ok = this._sign.verify(text.getBytes("UTF-8"), Base64.decodeBase64((String)signature));
            }
            catch (UnsupportedEncodingException e) {
                Utils.logError((Exception)e);
                this.setError(6);
            }
            catch (GeneralSecurityException e) {
                Utils.logError((Exception)e);
                this.setError(6);
            }
            catch (PublicKeyNotFoundException e) {
                this.setError(4);
            }
            catch (SignatureException e) {
                Utils.logError((Exception)e);
                this.setError(6, e.getMessage());
            }
        }
        return ok;
    }

    private void Initialize() {
        if (this.isDirty.booleanValue()) {
            String algorithm = String.format("%swith%s", this._hashAlgorithm, this._signAlgorithm);
            switch (this._standard) {
                case PKCS1: {
                    this._sign = new PKCS1Signature(algorithm, this._cert.getCertificate(), this._cert.getPrivateKey());
                    break;
                }
                case PKCS7: {
                    this._sign = new PKCS7Signature(algorithm, this._cert.getCertificate(), this._cert.getPrivateKey());
                    break;
                }
            }
            this.isDirty = false;
        }
    }

    private void setError(int errorCode) {
        this.setError(errorCode, "");
    }

    private void setError(int errorCode, String errDsc) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this._lastErrorDescription = "Algorithm not supported";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Invalid Algorithm format";
                break;
            }
            case 4: {
                this._lastErrorDescription = "Certificate not initialized";
                break;
            }
            case 5: {
                this._lastErrorDescription = "Certificate does not contain private key";
                break;
            }
            case 6: {
                this._lastErrorDescription = "Signature Exception";
                break;
            }
        }
        if (!errDsc.equals("")) {
            this._lastErrorDescription = !this._lastErrorDescription.equals("") ? String.format("%s - %s", this._lastErrorDescription, errDsc) : errDsc;
        }
    }

    public void setValidateCertificate(Boolean validate) {
        this._validateCertificates = validate;
    }

    public Boolean getValidateCertificate() {
        return this._validateCertificates;
    }

    public void setStandard(String std) {
        Utils.PKCSStandard oldV = this._standard;
        if (std.equals("PKCS7")) {
            this._standard = Utils.PKCSStandard.PKCS7;
        } else if (std.equals("PKCS1")) {
            this._standard = Utils.PKCSStandard.PKCS1;
        } else {
            this.setError(2);
        }
        this.isDirty = this.isDirty != false || oldV != this._standard;
    }

    public String getStandard() {
        return this._standard.toString();
    }

    public void setAlgorithm(String value) {
        this.isDirty = this.isDirty != false || !value.equals(this._alg);
        this._alg = value;
        String[] parts = this._alg.split(" ");
        if (parts.length == 2) {
            String hash = parts[0];
            String sign = parts[1];
            this._hashAlgorithm = hash;
            this._signAlgorithm = sign;
        } else {
            this.setError(3);
        }
    }

    public GXCertificate getCertificate() {
        return this._cert;
    }

    public void setCertificate(GXCertificate cert) {
        this._cert = cert;
    }

    private Boolean anyError() {
        if (this._cert == null || this._cert != null && !this._cert.certLoaded()) {
            this.setError(4);
        }
        return this._lastError != 0;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }
}

