/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography;

import com.genexus.cryptography.GXCertificate;
import com.genexus.cryptography.Utils;
import com.genexus.cryptography.signing.xml.Canonicalizer;
import com.genexus.internet.StringCollection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GXXMLDsig {
    private PrivateKey _pKey;
    private X509Certificate _cert;
    private GXCertificate _gxCert;
    private List<String> _references = new ArrayList<String>();
    private String _canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private boolean _detached = false;
    private StringCollection _keyInfoClauses = new StringCollection(){
        {
            this.add("X509IssuerSerial");
            this.add("X509SubjectName");
            this.add("X509Certificate");
        }
    };
    private int _lastError;
    private String _lastErrorDescription;
    private boolean _validateCertificate;

    private void initialize() {
        this.setError(0);
    }

    public void addReference(String reference) {
        this._references.add(reference);
    }

    public String sign(String xml) {
        return this.signElements(xml, "");
    }

    public String signElements(String xml, String xPath) {
        this.initialize();
        if (!this.anyError().booleanValue()) {
            if (!this._gxCert.hasPrivateKey()) {
                this.setError(5);
                return "";
            }
            try {
                Document doc = Utils.documentFromString((String)Canonicalizer.canonize(xml), (boolean)true);
                if (doc == null) {
                    this.setError(2);
                    return "";
                }
                ArrayList<Element> list = new ArrayList<Element>();
                if (xPath.equals("")) {
                    list.add(doc.getDocumentElement());
                } else {
                    XPath xPathHelper = XPathFactory.newInstance().newXPath();
                    NodeList nodeList = (NodeList)xPathHelper.evaluate(xPath, doc, XPathConstants.NODESET);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        list.add((Element)nodeList.item(i));
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    Element element = (Element)list.get(i);
                    NodeList nodeListSignature = element.getElementsByTagName("Signature");
                    for (int j = 0; j < nodeListSignature.getLength(); ++j) {
                        Node parentSignature = nodeListSignature.item(j).getParentNode();
                        parentSignature.removeChild(nodeListSignature.item(j));
                    }
                    DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
                    Document docToBeSigned = docBuilder.newDocument();
                    docToBeSigned.appendChild(docToBeSigned.importNode(element, true));
                    ElementProxy.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)"");
                    XMLSignature signature = new XMLSignature(docToBeSigned, "", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                    docToBeSigned.getDocumentElement().appendChild(signature.getElement());
                    Transforms transforms = new Transforms(docToBeSigned);
                    transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
                    if (this._references.size() > 0) {
                        for (int j = 0; j < this._references.size(); ++j) {
                            signature.addDocument(this._references.get(j), transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
                        }
                    } else {
                        signature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
                    }
                    this.setKeyInfo(signature);
                    signature.sign((Key)this._gxCert.getPrivateKey());
                    Node p = element.getParentNode();
                    p.replaceChild(doc.importNode(docToBeSigned.getDocumentElement(), true), element);
                }
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                XMLUtils.outputDOMc14nWithComments((Node)doc, (OutputStream)byteArray);
                return new String(byteArray.toByteArray());
            }
            catch (NoSuchAlgorithmException e) {
                Utils.logError((Exception)e);
                this.setError(3);
            }
            catch (InvalidAlgorithmParameterException e) {
                Utils.logError((Exception)e);
            }
            catch (Exception e) {
                Utils.logError((Exception)e);
                this.setError(6, e.getMessage());
            }
        }
        return "";
    }

    public boolean verify(String xml) {
        this.initialize();
        Document doc = null;
        try {
            doc = Utils.documentFromString((String)Canonicalizer.canonize(xml), (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (doc == null) {
            this.setError(2);
            return false;
        }
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            return false;
        }
        try {
            X509Certificate cert;
            Element sigElement = (Element)nl.item(0);
            XMLSignature signature = new XMLSignature(sigElement, "");
            boolean certValid = true;
            if (this._validateCertificate && !(certValid = this._gxCert.verify())) {
                this.setError(7);
            }
            KeyInfo ki = signature.getKeyInfo();
            boolean valid = true;
            if (ki == null) {
                this.setError(8);
            }
            if ((cert = signature.getKeyInfo().getX509Certificate()) == null) {
                PublicKey pk = signature.getKeyInfo().getPublicKey();
                if (pk == null) {
                    this.setError(7);
                }
                valid = signature.checkSignatureValue((Key)pk);
            } else {
                valid = signature.checkSignatureValue(cert);
            }
            if (!valid) {
                this.setError(9);
            }
            return valid && certValid;
        }
        catch (XMLSignatureException e) {
            Utils.logError((Exception)((Object)e));
            this.setError(6);
        }
        catch (XMLSecurityException e) {
            Utils.logError((Exception)((Object)e));
            this.setError(6);
        }
        return false;
    }

    private void setKeyInfo(XMLSignature signature) {
        X509Data x509data = new X509Data(signature.getDocument());
        if (this._keyInfoClauses.getCount() > 0) {
            ArrayList<String> x509DataContent = new ArrayList<String>();
            for (int i = 1; i <= this._keyInfoClauses.getCount(); ++i) {
                String item = this._keyInfoClauses.item(i);
                if (item.equals("X509IssuerSerial")) {
                    x509data.addIssuerSerial(this._gxCert.getCertificate().getIssuerDN().getName(), this._gxCert.getCertificate().getSerialNumber());
                    continue;
                }
                if (item.equals("X509SubjectName")) {
                    x509DataContent.add(this._cert.getIssuerDN().getName());
                    continue;
                }
                if (item.equals("X509Certificate")) {
                    try {
                        x509data.addCertificate(this._gxCert.getCertificate());
                    }
                    catch (XMLSecurityException xMLSecurityException) {}
                    continue;
                }
                if (!item.equals("RSAKeyValue")) continue;
                signature.getKeyInfo().add(this._gxCert.getCertificate().getPublicKey());
            }
        }
        signature.getKeyInfo().add(x509data);
    }

    private void setError(int errorCode) {
        this.setError(errorCode, "");
    }

    private void setError(int errorCode, String errDsc) {
        this._lastError = errorCode;
        switch (errorCode) {
            case 0: {
                this._lastErrorDescription = "";
                break;
            }
            case 1: {
                this._lastErrorDescription = "Cannot sign an empty xml.";
                break;
            }
            case 2: {
                this._lastErrorDescription = "Input XML is not valid";
                break;
            }
            case 3: {
                this._lastErrorDescription = "Invalid Algorithm format";
                break;
            }
            case 4: {
                this._lastErrorDescription = "Certificate not initialized";
                break;
            }
            case 5: {
                this._lastErrorDescription = "Certificate does not contain private key";
                break;
            }
            case 6: {
                this._lastErrorDescription = "Signature Exception";
                break;
            }
            case 7: {
                this._lastErrorDescription = "Certificate is not valid";
                break;
            }
            case 8: {
                this._lastErrorDescription = "Signature element was not found";
                break;
            }
            case 9: {
                this._lastErrorDescription = "Signature is not valid";
                break;
            }
        }
        if (!errDsc.equals("")) {
            this._lastErrorDescription = !this._lastErrorDescription.equals("") ? String.format("%s - %s", this._lastErrorDescription, errDsc) : errDsc;
        }
    }

    public GXCertificate getCertificate() {
        return this._gxCert;
    }

    public void setCertificate(GXCertificate cert) {
        this._gxCert = cert;
        this._pKey = cert.getPrivateKey();
        this._cert = cert.getCertificate();
    }

    private Boolean anyError() {
        if (this._gxCert == null || this._gxCert != null && !this._gxCert.certLoaded()) {
            this.setError(4);
        }
        return this._lastError != 0;
    }

    public int getErrCode() {
        return this._lastError;
    }

    public void setValidateCertificate(Boolean validate) {
        this._validateCertificate = validate;
    }

    public Boolean getValidateCertificate() {
        return this._validateCertificate;
    }

    public String getErrDescription() {
        return this._lastErrorDescription;
    }

    public StringCollection getKeyInfoClauses() {
        return this._keyInfoClauses;
    }
}

