/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.encryption.asymmetric;

import com.genexus.cryptography.Utils;
import com.genexus.cryptography.encryption.asymmetric.IGXAsymEncryption;
import com.genexus.cryptography.exception.AlgorithmNotSupportedException;
import com.genexus.cryptography.exception.EncryptionException;
import com.genexus.cryptography.exception.PrivateKeyNotFoundException;
import com.genexus.cryptography.exception.PublicKeyNotFoundException;
import com.genexus.util.Codecs;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class CipherAsymProvider
implements IGXAsymEncryption {
    private String _algorithm;
    private PublicKey _publicKey;
    private PrivateKey _privateKey;
    private Cipher _cipher;

    public CipherAsymProvider(String algorithm, PublicKey publicKey, PrivateKey privateKey) throws AlgorithmNotSupportedException {
        this._algorithm = algorithm;
        this._publicKey = publicKey;
        this._privateKey = privateKey;
        try {
            this._cipher = Cipher.getInstance(this._algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotSupportedException(e);
        }
        catch (NoSuchPaddingException e) {
            System.err.println(e);
        }
    }

    @Override
    public String encrypt(String data) throws PublicKeyNotFoundException, EncryptionException {
        if (this._publicKey == null) {
            throw new PublicKeyNotFoundException();
        }
        String encryted = "";
        try {
            this._cipher.init(1, this._publicKey);
            encryted = new String(Base64.encodeBase64((byte[])this._cipher.doFinal(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            throw new EncryptionException(encryted, e);
        }
        return encryted;
    }

    @Override
    public String decrypt(String data) throws PrivateKeyNotFoundException, EncryptionException {
        if (this._privateKey == null) {
            throw new PrivateKeyNotFoundException();
        }
        byte[] dataBuffer = null;
        try {
            dataBuffer = Codecs.base64Decode((byte[])data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            Utils.logError((Exception)e1);
        }
        String decrypted = "";
        try {
            this._cipher.init(2, this._privateKey);
            decrypted = new String(this._cipher.doFinal(dataBuffer), "UTF-8");
        }
        catch (Exception e) {
            throw new EncryptionException("Decrypt Error", e);
        }
        return decrypted;
    }
}

