/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.encryption.symmetric;

import com.genexus.cryptography.encryption.symmetric.IGXSymEncryption;
import com.genexus.cryptography.exception.AlgorithmNotSupportedException;
import com.genexus.cryptography.exception.EncryptionException;
import com.genexus.cryptography.exception.InvalidKeyLengthException;
import com.genexus.util.Base64;
import com.genexus.util.Codecs;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherSymProvider
implements IGXSymEncryption {
    private int _keySize;
    private int _blockSize;
    byte[] _key;
    byte[] _iv;
    private Cipher _cipher;
    private String _alg;

    public CipherSymProvider(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyLengthException, AlgorithmNotSupportedException {
        this(algorithm, 0);
    }

    public CipherSymProvider(String algorithm, int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyLengthException, AlgorithmNotSupportedException {
        String[] algParts = algorithm.split("/");
        this._keySize = keySize;
        this._alg = algParts[0];
        this._cipher = Cipher.getInstance(algorithm);
        this._key = this.generateKey(keySize);
    }

    @Override
    public String encrypt(String text) throws EncryptionException {
        try {
            return this.encryption(1, text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String decrypt(String text) throws EncryptionException {
        byte[] data = Base64.decode((String)text);
        return this.encryption(2, data);
    }

    private String encryption(int mode, byte[] data) throws EncryptionException {
        SecretKeySpec key = new SecretKeySpec(this._key, this._alg);
        IvParameterSpec ivParameterSpec = null;
        if (this._iv != null) {
            ivParameterSpec = new IvParameterSpec(this._iv);
        }
        try {
            this._cipher.init(mode, (Key)key, ivParameterSpec);
            this._iv = this._cipher.getIV();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncryptionException("Alghorithm not supported", e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException("Encryption key not valid", e);
        }
        try {
            switch (mode) {
                case 2: {
                    return new String(this._cipher.doFinal(data), "UTF-8");
                }
                case 1: {
                    return new String(Codecs.base64Encode((byte[])this._cipher.doFinal(data)), "UTF-8");
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage(), e);
        }
    }

    private byte[] generateKey(int keysize) throws InvalidKeyLengthException, AlgorithmNotSupportedException {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(this._alg);
            if (keysize > 0) {
                kg.init(keysize / 8);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlgorithmNotSupportedException();
        }
        catch (InvalidParameterException e) {
            throw new InvalidKeyLengthException(e);
        }
        byte[] result = kg.generateKey().getEncoded();
        this._keySize = result.length * 8;
        return result;
    }

    @Override
    public String getIV() {
        return Base64.encodeBytes((byte[])this._iv);
    }

    @Override
    public void setIV(String iv) {
        this._iv = Base64.decode((String)iv);
    }

    @Override
    public String getKey() {
        return Base64.encodeBytes((byte[])this._key);
    }

    @Override
    public void setKey(String Key2) {
        this._key = Base64.decode((String)Key2);
    }

    @Override
    public int getKeySize() {
        return this._keySize;
    }

    @Override
    public void setKeySize(int keySize) throws InvalidKeyLengthException, AlgorithmNotSupportedException {
        this._keySize = keySize;
        this._key = this.generateKey(keySize);
    }

    @Override
    public int getBlockSize() {
        return this._cipher.getBlockSize();
    }

    @Override
    public void setBlockSize(int blockSize) {
        this._blockSize = blockSize;
    }
}

