/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.signing.standards;

import com.genexus.cryptography.exception.PrivateKeyNotFoundException;
import com.genexus.cryptography.exception.PublicKeyNotFoundException;
import com.genexus.cryptography.signing.IPkcsSign;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;

public class PKCS1Signature
implements IPkcsSign {
    private String _algorithm;
    private X509Certificate _cert;
    private PrivateKey _pKey;

    public PKCS1Signature(String algorithm, X509Certificate cert, PrivateKey key) {
        this._algorithm = algorithm;
        this._cert = cert;
        this._pKey = key;
        this.initialize();
    }

    private void initialize() {
    }

    @Override
    public String sign(byte[] data) throws GeneralSecurityException, PrivateKeyNotFoundException {
        if (this._pKey == null) {
            throw new PrivateKeyNotFoundException();
        }
        Signature signatureAlgorithm = Signature.getInstance(this._algorithm);
        signatureAlgorithm.initSign(this._pKey);
        signatureAlgorithm.update(data);
        byte[] digitalSignature = signatureAlgorithm.sign();
        return Base64.encodeBase64String((byte[])digitalSignature);
    }

    @Override
    public boolean verify(byte[] data, byte[] aSignature) throws GeneralSecurityException, PublicKeyNotFoundException {
        if (this._cert == null) {
            throw new PublicKeyNotFoundException();
        }
        PublicKey pKey = this._cert.getPublicKey();
        Signature signatureAlgorithm = Signature.getInstance(this._algorithm);
        signatureAlgorithm.initVerify(pKey);
        signatureAlgorithm.update(data);
        boolean valid = signatureAlgorithm.verify(aSignature);
        return valid;
    }

    @Override
    public void setCertificate(X509Certificate cert) {
        this._cert = cert;
    }

    @Override
    public X509Certificate getCertificate() {
        return this._cert;
    }
}

