/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.cryptography.signing.standards;

import com.genexus.cryptography.Utils;
import com.genexus.cryptography.exception.PrivateKeyNotFoundException;
import com.genexus.cryptography.exception.PublicKeyNotFoundException;
import com.genexus.cryptography.exception.SignatureException;
import com.genexus.cryptography.signing.IPkcsSign;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class PKCS7Signature
implements IPkcsSign {
    private String _algorithm;
    private X509Certificate _cert;
    private PrivateKey _pKey;
    private Boolean _detached;

    public PKCS7Signature(String algorithm) {
        this._algorithm = algorithm;
        this.initialize();
    }

    public PKCS7Signature(String algorithm, X509Certificate cert, PrivateKey key) {
        this._algorithm = algorithm;
        this._cert = cert;
        this._pKey = key;
        this.initialize();
    }

    private void initialize() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public String sign(byte[] data) throws GeneralSecurityException, CMSException, IOException, PublicKeyNotFoundException, PrivateKeyNotFoundException {
        if (this._cert == null) {
            throw new PublicKeyNotFoundException();
        }
        if (this._pKey == null) {
            throw new PrivateKeyNotFoundException();
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(this._cert);
        JcaCertStore certs = new JcaCertStore(certList);
        try {
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner sha1Signer = new JcaContentSignerBuilder(this._algorithm).setProvider("BC").build(this._pKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, this._cert));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, this._detached == false);
            return Base64.encodeBase64String((byte[])sigData.getEncoded());
        }
        catch (OperatorCreationException e) {
            Utils.logError((Exception)((Object)e));
            return "";
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] aSignature) throws GeneralSecurityException, PublicKeyNotFoundException, SignatureException {
        this.initialize();
        CMSProcessableByteArray content = new CMSProcessableByteArray(data);
        int verified = 0;
        CMSSignedData signedData = null;
        try {
            signedData = this._detached.booleanValue() ? new CMSSignedData((CMSProcessable)content, aSignature) : new CMSSignedData(aSignature);
        }
        catch (CMSException e) {
            Utils.logError((Exception)((Object)e));
            throw new SignatureException(e);
        }
        Store certStore = signedData.getCertificates();
        SignerInformationStore signers = signedData.getSignerInfos();
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection certCollection = certStore.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            try {
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert))) continue;
                ++verified;
            }
            catch (Exception e) {
                Utils.logError((Exception)e);
                throw new SignatureException(e);
            }
        }
        return verified > 0;
    }

    public void setDetached(Boolean value) {
        this._detached = value;
    }

    @Override
    public void setCertificate(X509Certificate cert) {
        this._cert = cert;
    }

    @Override
    public X509Certificate getCertificate() {
        return this._cert;
    }
}

