/*
 * Decompiled with CFR 0.152.
 */
package applet;

import applet.controller.DefaultGXCDigitalSignAppletController;
import applet.controller.GXCDigitalSignAppletController;
import applet.ui.AppletPanel;
import applet.ui.MessageDialog;
import configuration.Configuration;
import digitalSign.DigitalSign;
import digitalSign.utils.Utils;
import java.awt.Container;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.xml.bind.DatatypeConverter;
import org.icepdf.core.util.Library;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GXCDigitalSignApplet
extends JApplet {
    private GXCDigitalSignAppletController controller;
    private String base64Text;
    private String documentLocation;
    private Container contentPane;
    private String signType;
    private int pdfCertificationLevel = 0;
    private boolean fileEmbedded;
    private boolean appletEmbedded;
    private String[] docsLocations;
    private String[] docsFriendlyName = null;
    private String[] docsOTP = null;

    @Override
    public void init() {
        try {
            Object object;
            String string;
            System.out.println("Applet Version 1.3.1");
            super.init();
            this.signType = this.getParameter("SIGN_TYPE");
            Class<?> clazz = Class.forName(this.signType);
            DigitalSign digitalSign = (DigitalSign)clazz.newInstance();
            if (this.signType.toUpperCase().contains("PDF")) {
                Library.initializeThreadPool();
            }
            this.controller = new DefaultGXCDigitalSignAppletController(digitalSign);
            this.base64Text = this.getParameter("PLAIN_TEXT");
            this.fileEmbedded = "1".equals(this.getParameter("FILE_EMBEDDED"));
            String string2 = this.getParameter("CERTIFICATE_LOCATION");
            String string3 = this.getParameter("USE_TOKEN");
            try {
                this.pdfCertificationLevel = Integer.parseInt(this.getParameter("PDF_CERTIFICATION_LEVEL"));
            }
            catch (Exception exception) {
                this.pdfCertificationLevel = 0;
            }
            if (this.getParameter("LANGUAGE_LOCALE") != null && !this.getParameter("LANGUAGE_LOCALE").equals("")) {
                Configuration.getInstance(this.getParameter("LANGUAGE_LOCALE"));
            }
            try {
                Configuration.getInstance().addTokenPKCS11LibrariesFromURL(new URL(this.getParameter("TOKEN_LIST")));
            }
            catch (Exception exception) {
                Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, "TOKEN_LIST Error loading: " + this.getParameter("TOKEN_LIST"), exception);
            }
            Configuration.getInstance().loadTempTokenPKCS11Libraries();
            Utils.cleanDirectory();
            String string4 = this.getParameter("DIGITAL_SIGN_RECEIVER");
            String string5 = this.getParameter("DIGITAL_SIGN_RECEIVER_ONE_TIME_PASSWORD");
            String string6 = this.getParameter("FONT_NAME");
            String string7 = this.getParameter("FONT_SIZE");
            String string8 = this.getParameter("XML_INCLUDE_CERTIFICATE");
            boolean bl = string8 != null && string8.trim().equalsIgnoreCase("true");
            String string9 = this.getParameter("PDF_SHOW_SAVE_BUTTON");
            String string10 = this.getParameter("PDF_SHOW_PRINT_BUTTON");
            this.appletEmbedded = this.getParameter("EMBEDDED_APPLET") == null ? true : Boolean.parseBoolean(this.getParameter("EMBEDDED_APPLET"));
            String string11 = this.getParameter("DIGITAL_SIGN_FINISH") == null ? "" : this.getParameter("DIGITAL_SIGN_FINISH");
            String string12 = this.getParameter("DIGITAL_SIGN_MULTIPLE") == null ? "" : this.getParameter("DIGITAL_SIGN_MULTIPLE");
            Boolean bl2 = this.getParameter("MULTIPLE_FILES") == null ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(this.getParameter("MULTIPLE_FILES")));
            if (bl2.booleanValue()) {
                if (this.getParameter("MULTIPLE_DOC_SDT") == null) {
                    this.docsLocations[0] = this.documentLocation = this.getParameter("DOCUMENT_LOCATION");
                    string = "";
                } else {
                    string = this.getParameter("MULTIPLE_DOC_SDT");
                    string = new String(DatatypeConverter.parseBase64Binary((String)string));
                    object = new JSONTokener(string);
                    JSONArray jSONArray = new JSONArray((JSONTokener)object);
                    this.docsLocations = new String[jSONArray.length()];
                    this.docsFriendlyName = new String[jSONArray.length()];
                    this.docsOTP = new String[jSONArray.length()];
                    int n = 0;
                    for (Object object2 : jSONArray) {
                        JSONObject jSONObject = (JSONObject)object2;
                        this.docsOTP[n] = jSONObject.getString("DocumentOTP");
                        this.docsFriendlyName[n] = jSONObject.getString("DocumentFriendlyName");
                        this.docsLocations[n] = jSONObject.getString("DocumentLocation");
                        ++n;
                    }
                }
            } else {
                this.documentLocation = this.getParameter("DOCUMENT_LOCATION");
                this.docsLocations = new String[1];
                this.docsLocations[0] = this.documentLocation;
                string = "";
            }
            this.contentPane = super.getContentPane();
            object = new AppletPanel(this.contentPane, this.controller, string3, string2, this.signType, this.fileEmbedded, this.docsLocations, string9, string10, string5, this.appletEmbedded, string4, this.pdfCertificationLevel, bl, this.base64Text, string6, string7, string11, string12, bl2, string, this.docsFriendlyName, this.docsOTP, this);
        }
        catch (Exception exception) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, exception);
            try {
                String string = Configuration.getInstance().getMessage("APPLET_LOAD_ERROR");
                MessageDialog messageDialog = new MessageDialog(string, 0);
                messageDialog.run();
            }
            catch (Exception exception2) {
                Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, exception2);
                JOptionPane.showMessageDialog(this.contentPane, exception2.getMessage(), "Error", 0);
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

