/*
 * Decompiled with CFR 0.152.
 */
package applet.controller;

import applet.controller.GXCDigitalSignAppletController;
import configuration.Configuration;
import digitalSign.DigitalSign;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.signerStrategy.DefaultSignerKeyStoreStrategy;
import digitalSign.signerStrategy.ISignerKeyStoreStrategy;
import digitalSign.signerStrategy.KeyStoreCetificateBean;
import digitalSign.signerStrategy.TokenSignerKeyStoreStrategy;
import digitalSign.utils.DriverFileFilter;
import digitalSign.utils.OSDetector;
import java.awt.Container;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class DefaultGXCDigitalSignAppletController
extends GXCDigitalSignAppletController {
    private ISignerKeyStoreStrategy signerStrategy = null;
    private String selectedDirver = null;
    private String selectedDirverName = null;

    public DefaultGXCDigitalSignAppletController(DigitalSign digitalSign) {
        super(digitalSign);
    }

    @Override
    public boolean askTokenDriver(Container contentPane) throws DocumentSignException {
        JOptionPane pane = new JOptionPane(Configuration.getInstance().getMessage("ASK_SELECT_TOKEN_QUESETION"));
        Object[] options = new String[]{Configuration.getInstance().getMessage("ASK_SELECT_TOKEN_YES"), Configuration.getInstance().getMessage("ASK_SELECT_TOKEN_NO")};
        pane.setOptions(options);
        JDialog dialogQuestion = pane.createDialog(contentPane, Configuration.getInstance().getMessage("ASK_SELECT_TOKEN_TITLE"));
        dialogQuestion.setVisible(true);
        Object obj = pane.getValue();
        if (obj != null && obj.equals(Configuration.getInstance().getMessage("ASK_SELECT_TOKEN_YES"))) {
            JFileChooser fileChooser = new JFileChooser();
            DriverFileFilter tokenFileFilter = new DriverFileFilter();
            fileChooser.addChoosableFileFilter(tokenFileFilter);
            if (fileChooser.showOpenDialog(contentPane) == 0) {
                this.selectedDirver = fileChooser.getSelectedFile().getAbsolutePath();
                this.selectedDirverName = fileChooser.getSelectedFile().getName();
                if (this.selectedDirverName.contains(".")) {
                    this.selectedDirverName = this.selectedDirverName.substring(0, this.selectedDirverName.lastIndexOf("."));
                    this.selectedDirverName = this.selectedDirverName.replace(" ", "_");
                    this.selectedDirverName = this.selectedDirverName.replace("-", "_");
                    this.selectedDirverName = this.selectedDirverName.replace(".", "_");
                }
                Configuration.getInstance().addTokenPKCS11LibrariesToTemp(OSDetector.getOSFamily() + "_" + this.selectedDirverName, this.selectedDirver);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<KeyStoreCetificateBean> listCertificates(String certificate, String password) throws DocumentSignException {
        try {
            this.setISignerKeyStoreStrategy(certificate, password);
            return this.signerStrategy.listKeyStoreCetificateBean();
        }
        catch (DocumentSignException ex) {
            this.closeISignerKeyStoreStrategy();
            throw ex;
        }
    }

    @Override
    public KeyStoreCetificateBean selectCertificate(Container contentPane, List<KeyStoreCetificateBean> certificates) throws DocumentSignException {
        Object obj = JOptionPane.showInputDialog(contentPane, Configuration.getInstance().getMessage("ASK_CHOSSE_CERTIFICATE_QUESETION"), Configuration.getInstance().getMessage("ASK_CHOSSE_CERTIFICATE_TITLE"), 3, null, certificates.toArray(), null);
        if (obj != null && obj instanceof KeyStoreCetificateBean) {
            return (KeyStoreCetificateBean)obj;
        }
        return null;
    }

    @Override
    public byte[] sign(byte[] unsignedDocument, String certificate, String password, int pdfCertificationLevel, boolean includeXMLSignerCertificate) throws DocumentSignException {
        try {
            this.setISignerKeyStoreStrategy(certificate, password);
            this.digitalSign.setIncludeCertificate(includeXMLSignerCertificate);
            this.digitalSign.setPdfCertificationLevel(pdfCertificationLevel);
            byte[] result = this.digitalSign.signDocument(unsignedDocument);
            return result;
        }
        catch (DocumentSignException ex) {
            this.closeISignerKeyStoreStrategy();
            throw ex;
        }
    }

    @Override
    public void removeLastTokenDriver() throws DocumentSignException {
        Configuration.getInstance().removeTokenPKCS11LibrariesToTemp(OSDetector.getOSFamily() + "_" + this.selectedDirverName);
    }

    @Override
    public void closeSignerStrategy() throws DocumentSignException {
        this.closeISignerKeyStoreStrategy();
    }

    private void setISignerKeyStoreStrategy(String certificate, String password) throws DocumentSignException {
        if (this.signerStrategy == null) {
            this.signerStrategy = certificate == null || certificate.trim().equals("") ? new TokenSignerKeyStoreStrategy(password) : new DefaultSignerKeyStoreStrategy(certificate, password);
            this.digitalSign.setSignerKeyStoreStrategy(this.signerStrategy);
        }
    }

    private void closeISignerKeyStoreStrategy() throws DocumentSignException {
        if (this.signerStrategy != null) {
            this.signerStrategy.close();
            this.selectedDirver = null;
            this.selectedDirverName = null;
            this.signerStrategy = null;
            this.digitalSign.setSignerKeyStoreStrategy(null);
        }
    }
}

