/*
 * Decompiled with CFR 0.152.
 */
package applet.controller;

import applet.GXCDigitalSignApplet;
import applet.controller.GXCDigitalSignAppletController;
import applet.ui.AppletPanel;
import applet.ui.CertificateDialog;
import applet.ui.MessageDialog;
import applet.ui.TableDialog;
import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.exceptions.TokenErrorCode;
import digitalSign.exceptions.TokenLoadException;
import digitalSign.signerStrategy.KeyStoreCetificateBean;
import digitalSign.utils.Codecs;
import digitalSign.utils.Utils;
import finishMultiple.FinishMultipleSign;
import finishMultiple.FinishMultipleSignExecute;
import finishMultiple.FinishMultipleSignExecuteResponse;
import finishMultiple.FinishMultipleSignSoapPort;
import java.applet.Applet;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.xml.ws.Service;
import netscape.javascript.JSObject;
import org.icepdf.core.util.Library;
import sender.DigitalSignReceiver;
import sender.DigitalSignReceiverExecute;
import sender.DigitalSignReceiverExecuteResponse;
import senderMultiple.DigitalSignReceiverMultiple;
import senderMultiple.DigitalSignReceiverMultipleExecute;
import senderMultiple.DigitalSignReceiverMultipleExecuteResponse;

public class SignerButtonListener
implements ActionListener {
    private Container contentPane;
    private GXCDigitalSignAppletController controller;
    private String definedCertificate;
    private String useToken;
    private String signType;
    private String oneTimePassWord;
    private Boolean appletEmbedded;
    private String digitalSignReceiverLocation;
    private int pdfCertificationLevel;
    private Boolean includeCertificate;
    private String digitalSignFinishLocation;
    private String digitalSignMultipleLocation;
    private Boolean digitalSignMultiple;
    private String[] docsOTP;
    private String[] docsFriendlyName;
    private Map<String, String> docsMessages;
    private JSObject browserWindow;
    private JApplet japplet;

    public SignerButtonListener(Container contentPane, GXCDigitalSignAppletController controller, String useToken, String definedCertificate, String signType, String oneTimePassWord, Boolean appletEmbedded, String digitalSignReceiverLocation, int pdfCertificationLevel, Boolean includeCertificate, String digitalSignFinishLocation, String digitalSignMultipleLocation, Boolean digitalSignMultiple, String[] docsOTP, String[] docsFriendlyName, JApplet applet) {
        this.contentPane = contentPane;
        this.controller = controller;
        this.definedCertificate = definedCertificate;
        this.useToken = useToken;
        this.signType = signType;
        this.oneTimePassWord = oneTimePassWord;
        this.appletEmbedded = appletEmbedded;
        this.digitalSignReceiverLocation = digitalSignReceiverLocation;
        this.pdfCertificationLevel = pdfCertificationLevel;
        this.includeCertificate = includeCertificate;
        this.digitalSignFinishLocation = digitalSignFinishLocation;
        this.digitalSignMultipleLocation = digitalSignMultipleLocation;
        this.digitalSignMultiple = digitalSignMultiple;
        this.docsOTP = docsOTP;
        this.docsFriendlyName = docsFriendlyName;
        this.docsMessages = new LinkedHashMap<String, String>();
        if (appletEmbedded.booleanValue()) {
            this.browserWindow = JSObject.getWindow((Applet)applet);
            this.japplet = applet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        this.contentPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean dontUseToken = this.useToken == null || this.useToken.equalsIgnoreCase("0");
            boolean undefinedCertificate = this.definedCertificate == null || this.definedCertificate.isEmpty();
            CertificateDialog dialog = new CertificateDialog(dontUseToken && undefinedCertificate, true);
            if (dialog.run()) {
                String certificate = this.definedCertificate;
                if (undefinedCertificate) {
                    certificate = dialog.getCertificateFileName();
                }
                String password = dialog.getCertificatePassword();
                List<KeyStoreCetificateBean> certificates = null;
                while (certificates == null) {
                    try {
                        certificates = this.controller.listCertificates(certificate, password);
                    }
                    catch (TokenLoadException tex) {
                        if (tex.getErrorCode() == TokenErrorCode.CKR_PIN_INCORRECT) {
                            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, Configuration.getInstance().getMessage("PASSWORD_TOKEN_ERROR"));
                            JOptionPane.showMessageDialog(this.contentPane, Configuration.getInstance().getMessage("PASSWORD_TOKEN_ERROR"), "Error", 0);
                            break;
                        }
                        if (this.controller.askTokenDriver(this.contentPane)) continue;
                        break;
                    }
                }
                if (certificates == null) {
                    this.controller.removeLastTokenDriver();
                } else {
                    KeyStoreCetificateBean cert = null;
                    if (certificates.size() > 1) {
                        cert = this.controller.selectCertificate(this.contentPane, certificates);
                    } else if (certificates.size() == 1) {
                        cert = certificates.get(0);
                    }
                    if (cert != null) {
                        this.controller.setCertificate(cert);
                        List<byte[]> docsToSign = AppletPanel.getDocsToSign();
                        List<Integer> selectedIndexes = AppletPanel.getSelectedIndexes();
                        int signed = 0;
                        for (byte[] documentoFirmar : docsToSign) {
                            String responseResult;
                            Object response;
                            Object parameters;
                            Object digitalSignReceiverSoapPort;
                            Service service;
                            byte[] result = this.controller.sign(documentoFirmar, certificate, password, this.pdfCertificationLevel, this.includeCertificate);
                            if (++signed == docsToSign.size()) {
                                this.controller.closeSignerStrategy();
                            }
                            if (result == null) continue;
                            if (!this.digitalSignMultiple.booleanValue() || this.digitalSignMultipleLocation.equals("")) {
                                service = new DigitalSignReceiver(new URL(this.digitalSignReceiverLocation + "?WSDL"));
                                digitalSignReceiverSoapPort = service.getDigitalSignReceiverSoapPort();
                                parameters = new DigitalSignReceiverExecute();
                                ((DigitalSignReceiverExecute)parameters).setSigneddocumenttype(this.signType);
                                ((DigitalSignReceiverExecute)parameters).setUnsigneddocument(new String(Codecs.base64Encode(documentoFirmar), "UTF-8"));
                                ((DigitalSignReceiverExecute)parameters).setSignatureresult(new String(Codecs.base64Encode(result), "UTF-8"));
                                ((DigitalSignReceiverExecute)parameters).setOnetimepwd(this.oneTimePassWord);
                                response = digitalSignReceiverSoapPort.execute((DigitalSignReceiverExecute)parameters);
                                responseResult = ((DigitalSignReceiverExecuteResponse)response).getResult();
                            } else {
                                service = new DigitalSignReceiverMultiple(new URL(this.digitalSignMultipleLocation + "?WSDL"));
                                digitalSignReceiverSoapPort = service.getDigitalSignReceiverMultipleSoapPort();
                                parameters = new DigitalSignReceiverMultipleExecute();
                                ((DigitalSignReceiverMultipleExecute)parameters).setSigneddocumenttype(this.signType);
                                ((DigitalSignReceiverMultipleExecute)parameters).setUnsigneddocument(new String(Codecs.base64Encode(documentoFirmar), "UTF-8"));
                                ((DigitalSignReceiverMultipleExecute)parameters).setSignatureresult(new String(Codecs.base64Encode(result), "UTF-8"));
                                ((DigitalSignReceiverMultipleExecute)parameters).setUserotp(this.oneTimePassWord);
                                ((DigitalSignReceiverMultipleExecute)parameters).setDocumentotp(this.docsOTP[selectedIndexes.get(signed - 1)]);
                                response = digitalSignReceiverSoapPort.execute((DigitalSignReceiverMultipleExecute)parameters);
                                responseResult = ((DigitalSignReceiverMultipleExecuteResponse)response).getResult();
                            }
                            if (responseResult != null && responseResult.equals("OK")) {
                                if (this.digitalSignMultiple.booleanValue()) {
                                    this.docsMessages.put(this.docsFriendlyName[selectedIndexes.get(signed - 1)], Configuration.getInstance().getMessage("SIGNED"));
                                } else {
                                    this.showSignedDialog();
                                }
                            } else {
                                String message = Configuration.getInstance().getMessage("SERVER_VALIDATION_ERROR");
                                if (responseResult != null) {
                                    message = message + " " + responseResult;
                                }
                                if (this.digitalSignMultiple.booleanValue()) {
                                    this.docsMessages.put(this.docsFriendlyName[selectedIndexes.get(signed - 1)], message);
                                } else {
                                    this.showErrorDialog(message);
                                }
                            }
                            if (signed != docsToSign.size()) continue;
                            this.finishSign();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(ex.getMessage());
        }
        finally {
            this.contentPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void finishSign() {
        try {
            if (this.digitalSignMultiple.booleanValue()) {
                this.showTableDialog(this.docsMessages);
                this.finishMultipleSign();
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(ex.getMessage());
        }
        catch (DocumentSignException ex) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, ex);
            this.showErrorDialog(ex.getMessage());
        }
        if (this.signType.toUpperCase().contains("PDF")) {
            Library.shutdownThreadPool();
        }
        Utils.cleanDirectory();
        if (!this.appletEmbedded.booleanValue()) {
            System.exit(0);
        } else {
            this.browserWindow.eval("mythis.onSignFinish();");
            this.japplet.stop();
        }
        AppletPanel.buttonSetEnabled(false);
    }

    private void finishMultipleSign() throws MalformedURLException, DocumentSignException {
        if (!this.digitalSignFinishLocation.equals("")) {
            FinishMultipleSign finishService = new FinishMultipleSign(new URL(this.digitalSignFinishLocation + "?WSDL"));
            FinishMultipleSignSoapPort finishServiceSoapPort = finishService.getFinishMultipleSignSoapPort();
            FinishMultipleSignExecute finishParameters = new FinishMultipleSignExecute();
            finishParameters.setOnetimepass(this.oneTimePassWord);
            FinishMultipleSignExecuteResponse finishResponse = finishServiceSoapPort.execute(finishParameters);
            String finishResponseResult = finishResponse.getResult();
            if (finishResponseResult != null && !finishResponseResult.equals("ERROR")) {
                if (!finishResponseResult.equals("OK")) {
                    this.showInformationDialog(finishResponseResult);
                } else {
                    this.showInformationDialog(Configuration.getInstance().getMessage("SERVER_FINISH_OK"));
                }
            } else {
                String message = Configuration.getInstance().getMessage("SERVER_FINISH_ERROR");
                this.showErrorDialog(message);
            }
        } else {
            this.showSignedDialog();
        }
    }

    private void showErrorDialog(String errorMessage) {
        try {
            MessageDialog errorDialog = new MessageDialog(errorMessage, 0);
            errorDialog.run();
        }
        catch (DocumentSignException excep) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, excep);
            JOptionPane.showMessageDialog(this.contentPane, excep.getMessage(), "Error", 0);
        }
    }

    private void showSignedDialog() {
        try {
            MessageDialog signedDialog = new MessageDialog(Configuration.getInstance().getMessage("SIGNED"), 1);
            signedDialog.run();
        }
        catch (DocumentSignException excep) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, excep);
            JOptionPane.showMessageDialog(this.contentPane, excep.getMessage(), "Error", 1);
        }
    }

    private void showInformationDialog(String message) {
        try {
            MessageDialog informationDialog = new MessageDialog(message, 1);
            informationDialog.run();
        }
        catch (DocumentSignException excep) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, excep);
            JOptionPane.showMessageDialog(this.contentPane, excep.getMessage(), "Error", 1);
        }
    }

    private void showTableDialog(Map<String, String> map) {
        try {
            TableDialog tdialog = new TableDialog(map);
            tdialog.run();
        }
        catch (Exception excep) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, excep);
            JOptionPane.showMessageDialog(this.contentPane, excep.getMessage(), "Error", 1);
        }
    }
}

