/*
 * Decompiled with CFR 0.152.
 */
package applet.ui;

import applet.controller.GXCDigitalSignAppletController;
import applet.controller.SignerButtonListener;
import applet.ui.CheckListItem;
import applet.ui.ListPanel;
import applet.ui.PdfPanel;
import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;

public class AppletPanel {
    private static String signType;
    private static Boolean fileEmbedded;
    private static String[] docsLocations;
    private static JList list;
    private static List<byte[]> docsData;
    private static JButton boton;
    private static List<Integer> selectedIndexes;

    public AppletPanel(Container contentPane, GXCDigitalSignAppletController controller, String useToken, String definedCertificate, String signType, Boolean fileEmbedded, String[] docsLocations, String showSave, String showPrint, String oneTimePassWord, Boolean appletEmbedded, String digitalSignReceiverLocation, int pdfCertificationLevel, Boolean includeCertificate, String base64Text, String fontName, String fontSize, String digitalSignFinishLocation, String digitalSignMultipleLocation, Boolean digitalSignMultiple, String multipleSDT, String[] docsFriendlyName, String[] docsOTP, JApplet applet) throws DocumentSignException, Exception {
        AppletPanel.signType = signType;
        AppletPanel.fileEmbedded = fileEmbedded;
        AppletPanel.docsLocations = docsLocations;
        contentPane.setLayout(new BorderLayout());
        boton = new JButton(Configuration.getInstance().getMessage("SIGN"));
        boton.addActionListener(new SignerButtonListener(contentPane, controller, useToken, definedCertificate, signType, oneTimePassWord, appletEmbedded, digitalSignReceiverLocation, pdfCertificationLevel, includeCertificate, digitalSignFinishLocation, digitalSignMultipleLocation, digitalSignMultiple, docsOTP, docsFriendlyName, applet));
        if (digitalSignMultiple.booleanValue()) {
            boton.setEnabled(false);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.setBackground(Color.WHITE);
        panel.add(boton);
        contentPane.add((Component)panel, "North");
        if (signType.toUpperCase().contains("PDF")) {
            PdfPanel pdfPanel = new PdfPanel();
            pdfPanel.createPdfPanel(showSave, showPrint);
            if (fileEmbedded.booleanValue()) {
                byte[] doc = Utils.getBinaryData(fileEmbedded, base64Text);
                docsData.add(doc);
            } else if (docsLocations.length == 1) {
                byte[] doc = Utils.getBinaryData(fileEmbedded, docsLocations[0]);
                docsData.add(doc);
            } else {
                DefaultListModel<CheckListItem> model = new DefaultListModel<CheckListItem>();
                list = new JList(model);
                list.setSelectedIndex(0);
                list.setSelectionMode(0);
                int index = 0;
                for (String docLocation : docsLocations) {
                    byte[] doc = Utils.getBinaryData(fileEmbedded, docLocation);
                    docsData.add(doc);
                    model.addElement(new CheckListItem(docsFriendlyName[index]));
                    ++index;
                }
                ListPanel listPanel = new ListPanel(list, contentPane, pdfPanel, docsData, boton);
            }
            pdfPanel.setDocument(docsData.get(0));
            contentPane.add((Component)pdfPanel.getPanel(), "Center");
        } else {
            Font font;
            JTextArea textArea = fileEmbedded != false ? new JTextArea(Utils.getTextData(fileEmbedded, base64Text, docsData)) : new JTextArea(Utils.getTextData(fileEmbedded, docsLocations[0], docsData));
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setSize(400, 400);
            textArea.setEditable(false);
            try {
                font = new Font(fontName, 0, Integer.parseInt(fontSize));
            }
            catch (NumberFormatException ex) {
                font = new Font(fontName, 0, 12);
            }
            textArea.setFont(font);
            contentPane.add(scrollPane);
        }
    }

    public static List<byte[]> getDocsToSign() throws Exception {
        if (signType.toUpperCase().contains("PDF") && !fileEmbedded.booleanValue() && docsLocations.length > 1) {
            int index;
            ArrayList<byte[]> docsToSign = new ArrayList<byte[]>();
            selectedIndexes = new ArrayList<Integer>();
            ListModel lmodel = list.getModel();
            for (index = 0; index < lmodel.getSize(); ++index) {
                CheckListItem element = (CheckListItem)lmodel.getElementAt(index);
                if (!element.isSelected()) continue;
                selectedIndexes.add(index);
            }
            index = 0;
            for (byte[] docData : docsData) {
                if (selectedIndexes.contains(index)) {
                    docsToSign.add(docData);
                }
                ++index;
            }
            return docsToSign;
        }
        return docsData;
    }

    public static List<Integer> getSelectedIndexes() {
        return selectedIndexes;
    }

    public static void buttonSetEnabled(Boolean enable) {
        boton.setEnabled(enable);
    }

    static {
        list = null;
        docsData = new ArrayList<byte[]>();
    }
}

