/*
 * Decompiled with CFR 0.152.
 */
package applet.ui;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class CertificateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton mBrowseForCertButton = new JButton();
    private JTextField mCertFileNameTextField = new JTextField();
    private JLabel mChooseCertFileLabel = new JLabel();
    private JTextField mPasswordTextField = new JPasswordField();
    private JLabel mEnterPasswordLabel = new JLabel();
    private JComboBox mChosseAliasCombo = new JComboBox();
    private JLabel mChosseAliasLabel = new JLabel();
    private JButton mSignButton = new JButton();
    private JButton mCancelButton = new JButton();
    private boolean mResult = false;

    public CertificateDialog(boolean showCertificate, boolean showPassword) throws DocumentSignException {
        try {
            String layoutClassName = Configuration.getInstance().getDialogLayoutElement("LAYOUT_CLASS_NAME");
            if (!layoutClassName.isEmpty()) {
                Class<?> clase = Class.forName(layoutClassName);
                LayoutManager layout = (LayoutManager)clase.newInstance();
                this.getContentPane().setLayout(layout);
            } else {
                this.getContentPane().setLayout(null);
            }
            String[] dimension = Configuration.getInstance().getDialogLayoutElement("DIALOG_DIMENSION").split(",");
            this.setSize(new Integer(dimension[0].trim()), new Integer(dimension[1].trim()));
            String[] dialogBackground = null;
            String background = Configuration.getInstance().getDialogLayoutElement("DIALOG_RGB_BACKGROUND");
            if (background != null) {
                dialogBackground = background.split(",");
            }
            if (dialogBackground == null || dialogBackground.length != 3) {
                this.getContentPane().setBackground(SystemColor.control);
            } else {
                this.getContentPane().setBackground(new Color(new Integer(dialogBackground[0].trim()), new Integer(dialogBackground[1].trim()), new Integer(dialogBackground[2].trim())));
            }
            this.setTitle(Configuration.getInstance().getMessage("SELECT_DIGITAL_CERTIFICATE"));
            String resizable = Configuration.getInstance().getDialogLayoutElement("RESIZABLE");
            this.setResizable(Boolean.valueOf(resizable));
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = this.getSize();
            int centerPosX = (screenSize.width - dialogSize.width) / 2;
            int centerPosY = (screenSize.height - dialogSize.height) / 2;
            this.setLocation(centerPosX, centerPosY);
            if (showCertificate) {
                this.mChooseCertFileLabel.setText(Configuration.getInstance().getMessage("SIGNER_INFORMATION"));
                String[] laberDimension = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_LABEL_DIMENSION").split(",");
                this.mChooseCertFileLabel.setBounds(new Rectangle(new Integer(laberDimension[0].trim()), new Integer(laberDimension[1].trim()), new Integer(laberDimension[2].trim()), new Integer(laberDimension[3].trim())));
                String[] laberFont = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_LABEL_FONT").split(",");
                this.mChooseCertFileLabel.setFont(new Font(laberFont[0], (int)new Integer(laberFont[1].trim()), new Integer(laberFont[2].trim())));
                String[] textFieldDimension = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_TEXT_DIMENSION").split(",");
                this.mCertFileNameTextField.setBounds(new Rectangle(new Integer(textFieldDimension[0].trim()), new Integer(textFieldDimension[1].trim()), new Integer(textFieldDimension[2].trim()), new Integer(textFieldDimension[3].trim())));
                String[] textFieldFont = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_TEXT_FONT").split(",");
                this.mCertFileNameTextField.setFont(new Font(textFieldFont[0], (int)new Integer(textFieldFont[1].trim()), new Integer(textFieldFont[2].trim())));
                String editable = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_TEXT_EDITABLE");
                this.mCertFileNameTextField.setEditable(Boolean.valueOf(editable));
                String[] textFiedBackgroundArray = null;
                String textFiedBackground = Configuration.getInstance().getDialogLayoutElement("CERTIFICATE_FILE_TEXT_RGB_BACKGROUND");
                if (textFiedBackground != null) {
                    textFiedBackgroundArray = textFiedBackground.split(",");
                }
                if (textFiedBackgroundArray == null || textFiedBackgroundArray.length != 3) {
                    this.mCertFileNameTextField.setBackground(SystemColor.control);
                } else {
                    this.mCertFileNameTextField.setBackground(new Color(new Integer(textFiedBackgroundArray[0].trim()), new Integer(textFiedBackgroundArray[1].trim()), new Integer(textFiedBackgroundArray[2].trim())));
                }
                this.mBrowseForCertButton.setText(Configuration.getInstance().getMessage("BROWSE"));
                String[] buttonColorArray = null;
                String buttonColor = Configuration.getInstance().getDialogLayoutElement("BUTTON_RGBCOLOR");
                if (buttonColor != null) {
                    buttonColorArray = buttonColor.split(",");
                }
                if (buttonColorArray == null || buttonColorArray.length != 3) {
                    this.mBrowseForCertButton.setBackground(SystemColor.control);
                } else {
                    this.mBrowseForCertButton.setBackground(new Color(new Integer(buttonColorArray[0].trim()), new Integer(buttonColorArray[1].trim()), new Integer(buttonColorArray[2].trim())));
                }
                String[] browseDimension = Configuration.getInstance().getDialogLayoutElement("BROWSE_BUTTON_DIMENSION").split(",");
                this.mBrowseForCertButton.setBounds(new Rectangle(new Integer(browseDimension[0].trim()), new Integer(browseDimension[1].trim()), new Integer(browseDimension[2].trim()), new Integer(browseDimension[3].trim())));
                this.mBrowseForCertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CertificateDialog.this.browseForCertButton_actionPerformed();
                    }
                });
                this.getContentPane().add((Component)this.mChooseCertFileLabel, null);
                this.getContentPane().add((Component)this.mCertFileNameTextField, null);
                this.getContentPane().add((Component)this.mBrowseForCertButton, null);
            }
            if (showPassword) {
                this.mEnterPasswordLabel.setText(Configuration.getInstance().getMessage("ENTER_PASSWORD"));
                String codeDimension = "PASSWORD_LABEL_ALONE_DIMENSION";
                if (showCertificate) {
                    codeDimension = "PASSWORD_LABEL_DIMENSION";
                }
                String[] laberDimension = Configuration.getInstance().getDialogLayoutElement(codeDimension).split(",");
                this.mEnterPasswordLabel.setBounds(new Rectangle(new Integer(laberDimension[0].trim()), new Integer(laberDimension[1].trim()), new Integer(laberDimension[2].trim()), new Integer(laberDimension[3].trim())));
                String[] labelFont = Configuration.getInstance().getDialogLayoutElement("PASSWORD_LABEL_FONT").split(",");
                this.mEnterPasswordLabel.setFont(new Font(labelFont[0], (int)new Integer(labelFont[1].trim()), new Integer(labelFont[2].trim())));
                codeDimension = "PASSWORD_TEXT_ALONE_DIMENSION";
                if (showCertificate) {
                    codeDimension = "PASSWORD_TEXT_DIMENSION";
                }
                String[] textFieldDimension = Configuration.getInstance().getDialogLayoutElement(codeDimension).split(",");
                this.mPasswordTextField.setBounds(new Rectangle(new Integer(textFieldDimension[0].trim()), new Integer(textFieldDimension[1].trim()), new Integer(textFieldDimension[2].trim()), new Integer(textFieldDimension[3].trim())));
                String[] textFont = Configuration.getInstance().getDialogLayoutElement("PASSWORD_TEXT_FONT").split(",");
                this.mPasswordTextField.setFont(new Font(textFont[0].trim(), (int)new Integer(textFont[1].trim()), new Integer(textFont[2].trim())));
                this.getContentPane().add((Component)this.mEnterPasswordLabel, null);
                this.getContentPane().add((Component)this.mPasswordTextField, null);
            }
            this.mSignButton.setText(Configuration.getInstance().getMessage("SIGN"));
            String[] buttonColorArray = null;
            String buttonColor = Configuration.getInstance().getDialogLayoutElement("BUTTON_RGBCOLOR");
            if (buttonColor != null) {
                buttonColorArray = buttonColor.split(",");
            }
            if (buttonColorArray == null || buttonColorArray.length != 3) {
                this.mSignButton.setBackground(SystemColor.control);
            } else {
                this.mSignButton.setBackground(new Color(new Integer(buttonColorArray[0].trim()), new Integer(buttonColorArray[1].trim()), new Integer(buttonColorArray[2].trim())));
            }
            String[] signButtonDimension = Configuration.getInstance().getDialogLayoutElement("SIGN_BUTTON_DIMENSION").split(",");
            this.mSignButton.setBounds(new Rectangle(new Integer(signButtonDimension[0].trim()), new Integer(signButtonDimension[1].trim()), new Integer(signButtonDimension[2].trim()), new Integer(signButtonDimension[3].trim())));
            this.mSignButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDialog.this.signButton_actionPerformed();
                }
            });
            this.mCancelButton.setText(Configuration.getInstance().getMessage("CANCEL"));
            buttonColorArray = null;
            buttonColor = Configuration.getInstance().getDialogLayoutElement("BUTTON_RGBCOLOR");
            if (buttonColor != null) {
                buttonColorArray = buttonColor.split(",");
            }
            if (buttonColorArray == null || buttonColorArray.length != 3) {
                this.mCancelButton.setBackground(SystemColor.control);
            } else {
                this.mCancelButton.setBackground(new Color(new Integer(buttonColorArray[0].trim()), new Integer(buttonColorArray[1].trim()), new Integer(buttonColorArray[2].trim())));
            }
            String[] cancelButtonDimension = Configuration.getInstance().getDialogLayoutElement("CANCEL_BUTTON_DIMENSION").split(",");
            this.mCancelButton.setBounds(new Rectangle(new Integer(cancelButtonDimension[0].trim()), new Integer(cancelButtonDimension[1].trim()), new Integer(cancelButtonDimension[2].trim()), new Integer(cancelButtonDimension[3].trim())));
            this.mCancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CertificateDialog.this.cancelButton_actionPerformed();
                }
            });
            this.getContentPane().add((Component)this.mSignButton, null);
            this.getContentPane().add((Component)this.mCancelButton, null);
            this.getRootPane().setDefaultButton(this.mSignButton);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    String certFileName = CertificateDialog.this.mCertFileNameTextField.getText();
                    if (certFileName != null && certFileName.length() != 0) {
                        CertificateDialog.this.mPasswordTextField.requestFocus();
                    } else {
                        CertificateDialog.this.mBrowseForCertButton.requestFocus();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    private void browseForCertButton_actionPerformed() {
        JFileChooser fileChooser = new JFileChooser();
        PFXFileFilter pfxFileFilter = new PFXFileFilter();
        fileChooser.addChoosableFileFilter(pfxFileFilter);
        String certFileName = this.mCertFileNameTextField.getText();
        File directory = new File(certFileName).getParentFile();
        fileChooser.setCurrentDirectory(directory);
        if (fileChooser.showOpenDialog(this) == 0) {
            String selectedCertFileName = fileChooser.getSelectedFile().getAbsolutePath();
            this.mCertFileNameTextField.setText(selectedCertFileName);
        }
    }

    private void signButton_actionPerformed() {
        this.mResult = true;
        this.setVisible(false);
        this.setModal(false);
    }

    private void cancelButton_actionPerformed() {
        this.mResult = false;
        this.setVisible(false);
        this.setModal(false);
    }

    public String getCertificateFileName() {
        String certFileName = this.mCertFileNameTextField.getText();
        return certFileName;
    }

    public String getCertificatePassword() {
        String password = this.mPasswordTextField.getText();
        return password;
    }

    public boolean run() {
        this.setModal(true);
        this.setVisible(true);
        return this.mResult;
    }

    private static class PFXFileFilter
    extends FileFilter {
        private PFXFileFilter() {
        }

        @Override
        public boolean accept(File aFile) {
            if (aFile.isDirectory()) {
                return false;
            }
            String fileName = aFile.getName().toUpperCase();
            boolean accepted = fileName.endsWith(".PFX") || fileName.endsWith(".P12");
            return accepted;
        }

        @Override
        public String getDescription() {
            try {
                return Configuration.getInstance().getMessage("CERTIFICATE_KEYSTORE_FILE");
            }
            catch (DocumentSignException ex) {
                Logger.getLogger(CertificateDialog.class.getName()).log(Level.SEVERE, null, ex);
                return "";
            }
        }
    }
}

