/*
 * Decompiled with CFR 0.152.
 */
package applet.ui;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class MessageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JOptionPane jOptionPane;

    public MessageDialog(String message, int code) throws DocumentSignException {
        try {
            Icon icon;
            String layoutClassName = Configuration.getInstance().getDialogLayoutElement("LAYOUT_CLASS_NAME");
            if (!layoutClassName.isEmpty()) {
                Class<?> clase = Class.forName(layoutClassName);
                LayoutManager layout = (LayoutManager)clase.newInstance();
                this.getContentPane().setLayout(layout);
            } else {
                this.getContentPane().setLayout(null);
            }
            String[] dimension = Configuration.getInstance().getDialogLayoutElement("DIALOG_DIMENSION").split(",");
            this.setSize(new Integer(dimension[0].trim()), new Integer(dimension[1].trim()));
            String[] colorArray = null;
            String color = Configuration.getInstance().getDialogLayoutElement("DIALOG_RGB_BACKGROUND");
            if (color != null) {
                colorArray = color.split(",");
            }
            if (colorArray == null || colorArray.length != 3) {
                this.getContentPane().setBackground(SystemColor.control);
            } else {
                this.getContentPane().setBackground(new Color(new Integer(colorArray[0].trim()), new Integer(colorArray[1].trim()), new Integer(colorArray[2].trim())));
            }
            this.setTitle(Configuration.getInstance().getMessage("INFORMATION"));
            String resizable = Configuration.getInstance().getDialogLayoutElement("RESIZABLE");
            this.setResizable(Boolean.valueOf(resizable));
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = this.getSize();
            int centerPosX = (screenSize.width - dialogSize.width) / 2;
            int centerPosY = (screenSize.height - dialogSize.height) / 2;
            this.setLocation(centerPosX, centerPosY);
            switch (code) {
                case 0: {
                    icon = UIManager.getIcon("OptionPane.errorIcon");
                    break;
                }
                case 2: {
                    icon = UIManager.getIcon("OptionPane.warningIcon");
                    break;
                }
                default: {
                    icon = UIManager.getIcon("OptionPane.informationIcon");
                }
            }
            JLabel dialogIcon = new JLabel(icon);
            String[] iconDimension = Configuration.getInstance().getDialogLayoutElement("INFORMATION_ICON_DIMENSION").split(",");
            dialogIcon.setBounds(new Rectangle(new Integer(iconDimension[0].trim()), new Integer(iconDimension[1].trim()), new Integer(iconDimension[2].trim()), new Integer(iconDimension[3].trim())));
            JLabel menssageLabel = new JLabel("<html>" + message + "</html>", 0);
            String[] laberDimension = Configuration.getInstance().getDialogLayoutElement("INFORMATION_LABEL_DIMENSION").split(",");
            String[] labelFont = Configuration.getInstance().getDialogLayoutElement("INFORMATION_LABEL_FONT").split(",");
            menssageLabel.setFont(new Font(labelFont[0], (int)new Integer(labelFont[1].trim()), new Integer(labelFont[2].trim())));
            JScrollPane scrollPane = new JScrollPane(menssageLabel);
            scrollPane.setBounds(new Rectangle(new Integer(laberDimension[0].trim()), new Integer(laberDimension[1].trim()), new Integer(laberDimension[2].trim()), new Integer(laberDimension[3].trim())));
            JButton cancelButton = code == 1 ? new JButton(Configuration.getInstance().getMessage("OK")) : new JButton(Configuration.getInstance().getMessage("CANCEL"));
            String[] buttonColorArray = null;
            String buttonColor = Configuration.getInstance().getDialogLayoutElement("BUTTON_RGBCOLOR");
            if (buttonColor != null) {
                buttonColorArray = buttonColor.split(",");
            }
            if (buttonColorArray == null || buttonColorArray.length != 3) {
                cancelButton.setBackground(SystemColor.control);
            } else {
                cancelButton.setBackground(new Color(new Integer(buttonColorArray[0].trim()), new Integer(buttonColorArray[1].trim()), new Integer(buttonColorArray[2].trim())));
            }
            String[] cancelButtonDimension = Configuration.getInstance().getDialogLayoutElement("INFORMATION_CANCEL_BUTTON_DIMENSION").split(",");
            cancelButton.setBounds(new Rectangle(new Integer(cancelButtonDimension[0].trim()), new Integer(cancelButtonDimension[1].trim()), new Integer(cancelButtonDimension[2].trim()), new Integer(cancelButtonDimension[3].trim())));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.cancelButton_actionPerformed();
                }
            });
            this.getContentPane().add((Component)dialogIcon, null);
            this.getContentPane().add((Component)scrollPane, null);
            this.getContentPane().add((Component)cancelButton, null);
            this.getRootPane().setDefaultButton(cancelButton);
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    private void cancelButton_actionPerformed() {
        this.setVisible(false);
        this.setModal(false);
    }

    public void run() {
        this.setModal(true);
        this.setVisible(true);
    }
}

