/*
 * Decompiled with CFR 0.152.
 */
package applet.ui;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class TableDialog
extends JDialog {
    public TableDialog(Map<String, String> results) throws DocumentSignException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String layoutClassName = Configuration.getInstance().getDialogLayoutElement("LAYOUT_CLASS_NAME");
        if (!layoutClassName.isEmpty()) {
            Class<?> clase = Class.forName(layoutClassName);
            LayoutManager layout = (LayoutManager)clase.newInstance();
            this.getContentPane().setLayout(layout);
        } else {
            this.getContentPane().setLayout(null);
        }
        String[] dimension = Configuration.getInstance().getDialogLayoutElement("DIALOG_DIMENSION").split(",");
        this.setSize(new Integer(dimension[0].trim()), new Integer(dimension[1].trim()));
        String[] colorArray = null;
        String color = Configuration.getInstance().getDialogLayoutElement("DIALOG_RGB_BACKGROUND");
        if (color != null) {
            colorArray = color.split(",");
        }
        if (colorArray == null || colorArray.length != 3) {
            this.getContentPane().setBackground(SystemColor.control);
        } else {
            this.getContentPane().setBackground(new Color(new Integer(colorArray[0].trim()), new Integer(colorArray[1].trim()), new Integer(colorArray[2].trim())));
        }
        this.setTitle(Configuration.getInstance().getMessage("INFORMATION"));
        String resizable = Configuration.getInstance().getDialogLayoutElement("RESIZABLE");
        this.setResizable(Boolean.valueOf(resizable));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        int centerPosX = (screenSize.width - dialogSize.width) / 2;
        int centerPosY = (screenSize.height - dialogSize.height) / 2;
        this.setLocation(centerPosX, centerPosY);
        JTable table = this.buildTable(results);
        table.setAutoResizeMode(4);
        JScrollPane panel = new JScrollPane(table);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        String[] tableDimension = Configuration.getInstance().getDialogLayoutElement("INFORMATION_TABLE").split(",");
        panel.setBounds(new Rectangle(new Integer(tableDimension[0].trim()), new Integer(tableDimension[1].trim()), new Integer(tableDimension[2].trim()), new Integer(tableDimension[3].trim())));
        JButton cancelButton = new JButton(Configuration.getInstance().getMessage("OK"));
        String[] buttonColorArray = null;
        String buttonColor = Configuration.getInstance().getDialogLayoutElement("BUTTON_RGBCOLOR");
        if (buttonColor != null) {
            buttonColorArray = buttonColor.split(",");
        }
        if (buttonColorArray == null || buttonColorArray.length != 3) {
            cancelButton.setBackground(SystemColor.control);
        } else {
            cancelButton.setBackground(new Color(new Integer(buttonColorArray[0].trim()), new Integer(buttonColorArray[1].trim()), new Integer(buttonColorArray[2].trim())));
        }
        String[] cancelButtonDimension = Configuration.getInstance().getDialogLayoutElement("INFORMATION_CANCEL_BUTTON_DIMENSION").split(",");
        cancelButton.setBounds(new Rectangle(new Integer(cancelButtonDimension[0].trim()), new Integer(cancelButtonDimension[1].trim()), new Integer(cancelButtonDimension[2].trim()), new Integer(cancelButtonDimension[3].trim())));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDialog.this.cancelButton_actionPerformed();
            }
        });
        cancelButton.setFocusCycleRoot(true);
        this.getContentPane().add((Component)panel, null);
        this.getContentPane().add((Component)cancelButton, null);
        this.getRootPane().setDefaultButton(cancelButton);
    }

    private void cancelButton_actionPerformed() {
        this.setVisible(false);
        this.setModal(false);
    }

    private JTable buildTable(Map<String, String> mapData) throws DocumentSignException {
        Object[] columnNames = new String[]{Configuration.getInstance().getMessage("DOCUMENT_COLUMN"), Configuration.getInstance().getMessage("RESULT_COLUMN")};
        Object[][] data = new Object[mapData.size()][2];
        int i = 0;
        for (Map.Entry<String, String> entry : mapData.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        return new JTable(data, columnNames);
    }

    public void run() {
        this.setModal(true);
        this.setVisible(true);
    }
}

