/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import applet.GXCDigitalSignApplet;
import configuration.PKCS11Config;
import digitalSign.exceptions.DocumentSignException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static String tempDirectory;
    private static Configuration instance;
    private Properties parameters;
    private ResourceBundle messages;
    private Properties dialogLayout;
    private Properties tokens;

    private Configuration(String language) throws DocumentSignException {
        try {
            this.parameters = new Properties();
            this.parameters.load(Configuration.class.getResourceAsStream("Parameters.properties"));
            Locale locale = new Locale(language);
            this.messages = ResourceBundle.getBundle("configuration.Messages", locale, Configuration.class.getClassLoader());
            this.dialogLayout = new Properties();
            this.dialogLayout.load(Configuration.class.getResourceAsStream("DialogLayout.properties"));
            this.tokens = new Properties();
            this.tokens.load(Configuration.class.getResourceAsStream("Tokens.properties"));
        }
        catch (Exception ex) {
            this.parameters = null;
            this.messages = null;
            this.dialogLayout = null;
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static synchronized Configuration getInstance(String language) throws DocumentSignException {
        if (instance == null) {
            instance = new Configuration(language);
        }
        return instance;
    }

    public static synchronized Configuration getInstance() throws DocumentSignException {
        if (instance == null) {
            instance = new Configuration("es");
        }
        return instance;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public String getMessage(String key) {
        return this.messages.getString(key);
    }

    public String getDialogLayoutElement(String key) {
        return this.dialogLayout.getProperty(key);
    }

    public void addTokenPKCS11LibrariesFromURL(URL url) throws DocumentSignException {
        try {
            URLConnection urlConn = url.openConnection();
            Properties newProp = new Properties();
            InputStream is = urlConn.getInputStream();
            newProp.load(is);
            is.close();
            for (Object key : newProp.keySet()) {
                this.tokens.put(key, newProp.getProperty((String)key));
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public void loadTempTokenPKCS11Libraries() {
        String tempDir = Configuration.getTempDirectory();
        File fileTokenProp = new File(tempDir, "Tokens.properties");
        System.out.println(tempDir);
        if (fileTokenProp.exists() && fileTokenProp.isFile() && fileTokenProp.canRead() && fileTokenProp.canWrite()) {
            try {
                Properties newProp = new Properties();
                FileInputStream is = new FileInputStream(fileTokenProp);
                newProp.load(is);
                ((InputStream)is).close();
                for (Object key : newProp.keySet()) {
                    this.tokens.put(key, newProp.getProperty((String)key));
                }
            }
            catch (Exception ex) {
                fileTokenProp.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenPKCS11LibrariesToTemp(String key) {
        String tempDir = Configuration.getTempDirectory();
        File fileTokenProp = new File(tempDir, "Tokens.properties");
        Properties newProp = new Properties();
        if (fileTokenProp.exists() && fileTokenProp.isFile() && fileTokenProp.canRead() && fileTokenProp.canWrite()) {
            try {
                FileInputStream is = new FileInputStream(fileTokenProp);
                newProp.load(is);
                ((InputStream)is).close();
            }
            catch (Exception ex) {
                Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            finally {
                fileTokenProp.delete();
            }
        }
        try {
            fileTokenProp = new File(tempDir, "Tokens.properties");
            FileOutputStream os = new FileOutputStream(fileTokenProp);
            this.tokens.remove(key);
            newProp.remove(key);
            newProp.store(os, "Auto-generated file.");
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenPKCS11LibrariesToTemp(String key, String value) {
        String tempDir = Configuration.getTempDirectory();
        File fileTokenProp = new File(tempDir, "Tokens.properties");
        Properties newProp = new Properties();
        if (fileTokenProp.exists() && fileTokenProp.isFile() && fileTokenProp.canRead() && fileTokenProp.canWrite()) {
            try {
                FileInputStream is = new FileInputStream(fileTokenProp);
                newProp.load(is);
                ((InputStream)is).close();
            }
            catch (Exception ex) {
                Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            }
            finally {
                fileTokenProp.delete();
            }
        }
        try {
            fileTokenProp = new File(tempDir, "Tokens.properties");
            FileOutputStream os = new FileOutputStream(fileTokenProp);
            this.tokens.put(key, value);
            newProp.put(key, value);
            newProp.store(os, "Auto-generated file.");
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public List<PKCS11Config> getTokenPKCS11Libraries(String osName) {
        ArrayList<PKCS11Config> files = new ArrayList<PKCS11Config>();
        for (Object key : this.tokens.keySet()) {
            String name = (String)key;
            if (!name.toLowerCase().startsWith(osName + "_")) continue;
            files.add(new PKCS11Config(name.substring(name.indexOf("_")), this.tokens.getProperty(name)));
        }
        return files;
    }

    public static String getTempDirectory() {
        if (tempDirectory == null) {
            try {
                File file = File.createTempFile("test_temp_dir", "");
                tempDirectory = file.getParent();
                file.delete();
            }
            catch (Throwable ex) {
                Logger.getLogger(GXCDigitalSignApplet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tempDirectory;
    }

    static {
        instance = null;
    }
}

