/*
 * Decompiled with CFR 0.152.
 */
package digitalSign;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import configuration.Configuration;
import digitalSign.CetificateInformationBean;
import digitalSign.DigitalSign;
import digitalSign.exceptions.DocumentSignException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PDFDigitalSign
extends DigitalSign {
    @Override
    public final byte[] signDocument(byte[] byArray) throws DocumentSignException {
        try {
            PdfReader pdfReader = new PdfReader(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ArrayList arrayList = pdfReader.getAcroFields().getSignatureNames();
            PdfStamper pdfStamper = arrayList.isEmpty() ? PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)byteArrayOutputStream, (char)'\u0000') : PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)byteArrayOutputStream, (char)'\u0000', null, (boolean)true);
            PrivateKey privateKey = this.signerKeyStoreStrategy.getSignerPrivateKey(this.alias);
            if (privateKey != null) {
                PrivateKeySignature privateKeySignature = new PrivateKeySignature(privateKey, Configuration.getInstance().getParameter("PDF_DIGITAL_SIGNATURE_DIGEST_METHOD_NAME"), null);
                BouncyCastleDigest bouncyCastleDigest = new BouncyCastleDigest();
                Certificate[] certificateArray = new Certificate[]{this.signerKeyStoreStrategy.getSignerCertificate(this.alias)};
                PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
                pdfSignatureAppearance.setCertificationLevel(this.pdfCertificationLevel);
                MakeSignature.signDetached((PdfSignatureAppearance)pdfSignatureAppearance, (ExternalDigest)bouncyCastleDigest, (ExternalSignature)privateKeySignature, (Certificate[])certificateArray, null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CMS);
                return byteArrayOutputStream.toByteArray();
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_CERT_ERROR"));
        }
        catch (DocumentSignException documentSignException) {
            throw documentSignException;
        }
        catch (Exception exception) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_ERROR"), exception.getCause());
        }
    }

    @Override
    public final void verifyDigitalSignature(byte[] byArray, byte[] byArray2) throws DocumentSignException {
        this.verifierKeyStoreStrategy.verifyCertificate(this.getSigningCertificate(byArray));
    }

    @Override
    public final CetificateInformationBean getSignerInformation(byte[] byArray) throws DocumentSignException {
        return this.verifierKeyStoreStrategy.getSignerInformation(this.getSigningCertificate(byArray));
    }

    private X509Certificate getSigningCertificate(byte[] byArray) throws DocumentSignException {
        try {
            PdfReader pdfReader = new PdfReader(byArray);
            AcroFields acroFields = pdfReader.getAcroFields();
            ArrayList arrayList = acroFields.getSignatureNames();
            if (arrayList.size() > 0) {
                Security.addProvider((Provider)new BouncyCastleProvider());
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (!acroFields.signatureCoversWholeDocument(string)) continue;
                    PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(string);
                    if (pdfPKCS7.verify()) {
                        return pdfPKCS7.getSigningCertificate();
                    }
                    throw new DocumentSignException(Configuration.getInstance().getMessage("CORRUPT_DOCUMENT"));
                }
                throw new DocumentSignException(Configuration.getInstance().getMessage("NO_SIGNATURE_ELEMENT_ERROR"));
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("NO_SIGNATURE_ELEMENT_ERROR"));
        }
        catch (DocumentSignException documentSignException) {
            throw documentSignException;
        }
        catch (Exception exception) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("VERIFY_DIGITAL_SIGNATURE_ERROR"), exception.getCause());
        }
    }
}

