/*
 * Decompiled with CFR 0.152.
 */
package digitalSign;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.utils.Codecs;
import digitalSign.utils.Utils;

public class PDFTools {
    public static String extraerTextoPDF(String pdfPath) {
        try {
            return PDFTools.extraerTextoPDFInt(Utils.loadByteArrayFromFile(pdfPath));
        }
        catch (DocumentSignException ex) {
            return "ERROR: " + ex.getMessage();
        }
    }

    public static String extraerTextoEncodedIn64(String pdf64Str) {
        try {
            return PDFTools.extraerTextoPDFInt(Codecs.base64Decode64(pdf64Str, "UTF-8"));
        }
        catch (DocumentSignException ex) {
            return "ERROR: " + ex.getMessage();
        }
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    private static String extraerTextoPDFInt(byte[] pdf) throws DocumentSignException {
        try {
            PdfReader reader = new PdfReader(pdf);
            PdfReaderContentParser parser = new PdfReaderContentParser(reader);
            StringBuilder out = new StringBuilder();
            for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                TextExtractionStrategy strategy = (TextExtractionStrategy)parser.processContent(i, (RenderListener)new SimpleTextExtractionStrategy());
                out.append(strategy.getResultantText());
                out.append(System.getProperty("line.separator"));
            }
            return out.toString();
        }
        catch (Exception ex) {
            return "ERROR: " + ex.getMessage();
        }
    }
}

