/*
 * Decompiled with CFR 0.152.
 */
package digitalSign;

import configuration.Configuration;
import digitalSign.CetificateInformationBean;
import digitalSign.DigitalSign;
import digitalSign.exceptions.DocumentSignException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;

public class PlainTextDigitalSign
extends DigitalSign {
    @Override
    public final byte[] signDocument(byte[] document) throws DocumentSignException {
        try {
            Signature signer = Signature.getInstance(Configuration.getInstance().getParameter("PLAIN_TEXT_DIGITAL_SIGNATURE_ALGORITHM_NAME"));
            PrivateKey privateKey = this.signerKeyStoreStrategy.getSignerPrivateKey(this.alias);
            if (privateKey != null) {
                signer.initSign(privateKey);
                signer.update(document);
                byte[] digitalSignature = signer.sign();
                return digitalSignature;
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_CERT_ERROR"));
        }
        catch (DocumentSignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_ERROR"), ex.getCause());
        }
    }

    @Override
    public final void verifyDigitalSignature(byte[] document, byte[] signature) throws DocumentSignException {
        try {
            Signature verifier = Signature.getInstance(Configuration.getInstance().getParameter("PLAIN_TEXT_DIGITAL_SIGNATURE_ALGORITHM_NAME"));
            Certificate signerCertificateFromCA = this.verifierKeyStoreStrategy.getSignerCertificateFromCA();
            this.verifierKeyStoreStrategy.verifyCertificate(signerCertificateFromCA);
            verifier.initVerify(signerCertificateFromCA);
            verifier.update(document);
            boolean verified = verifier.verify(signature);
            if (!verified) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("CORRUPT_DOCUMENT"));
            }
        }
        catch (DocumentSignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("VERIFY_DIGITAL_SIGNATURE_ERROR"), ex.getCause());
        }
    }

    @Override
    public final CetificateInformationBean getSignerInformation(byte[] signature) throws DocumentSignException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

