/*
 * Decompiled with CFR 0.152.
 */
package digitalSign;

import digitalSign.CetificateInformationBean;
import digitalSign.DigitalSign;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.signerStrategy.DefaultSignerKeyStoreStrategy;
import digitalSign.signerStrategy.ISignerKeyStoreStrategy;
import digitalSign.signerStrategy.TokenSignerKeyStoreStrategy;
import digitalSign.utils.Codecs;
import digitalSign.utils.Utils;
import digitalSign.verifierStrategy.IVerifierKeyStoreStrategy;
import digitalSign.verifierStrategy.OcspVerifierKeyStoreStrategy;
import java.util.Date;

public class ServerSideSign {
    private boolean includeXMLSignerCertificate;
    private boolean xmlNamespaceAware = true;
    private int pdfCertificationLevel;

    public boolean isIncludeXMLSignerCertificate() {
        return this.includeXMLSignerCertificate;
    }

    public void setIncludeXMLSignerCertificate(boolean bl) {
        this.includeXMLSignerCertificate = bl;
    }

    public void setXmlNamespaceAware(boolean bl) {
        this.xmlNamespaceAware = bl;
    }

    public int getPdfCertificationLevel() {
        return this.pdfCertificationLevel;
    }

    public void setPdfCertificationLevel(int n) {
        this.pdfCertificationLevel = n;
    }

    public String verifyDigitalSignature(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, Date date) {
        try {
            if (string.equalsIgnoreCase("digitalSign.PDFDigitalSign") || string.equalsIgnoreCase("digitalSign.XMLDigitalSign")) {
                byte[] byArray = Utils.loadByteArrayFromFile(string7);
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string5, bl, date, string4), byArray, null);
            } else {
                byte[] byArray = Utils.loadByteArrayFromFile(string6);
                byte[] byArray2 = null;
                if (string7 != null && !string7.trim().equals("")) {
                    byArray2 = Utils.loadByteArrayFromFile(string7);
                }
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string5, bl, date, string4), byArray, byArray2);
            }
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            return documentSignException.getMessage();
        }
    }

    public String signDocument(String string, String string2, String string3, String string4, String string5, String string6) {
        ISignerKeyStoreStrategy iSignerKeyStoreStrategy = null;
        try {
            byte[] byArray = Utils.loadByteArrayFromFile(string5);
            iSignerKeyStoreStrategy = string2 == null || string2.trim().equals("") ? new TokenSignerKeyStoreStrategy(string3) : new DefaultSignerKeyStoreStrategy(string2, string3);
            Utils.writeFileFromByteArray(string6, this.signDocumentInt(string, string4, iSignerKeyStoreStrategy, byArray));
            iSignerKeyStoreStrategy.close();
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            try {
                if (iSignerKeyStoreStrategy != null) {
                    iSignerKeyStoreStrategy.close();
                }
            }
            catch (DocumentSignException documentSignException2) {
                System.out.println("DocumentSignException ex2");
            }
            return documentSignException.getMessage();
        }
    }

    public String verifyDigitalSignatureEncodedIn64(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, Date date) {
        try {
            if (string.equalsIgnoreCase("digitalSign.PDFDigitalSign") || string.equalsIgnoreCase("digitalSign.XMLDigitalSign")) {
                byte[] byArray = Codecs.base64Decode64(string7, "UTF-8");
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string5, bl, date, string4), byArray, null);
            } else {
                byte[] byArray = Codecs.base64Decode64(string6, "UTF-8");
                byte[] byArray2 = null;
                if (string7 != null && !string7.trim().equals("")) {
                    byArray2 = Codecs.base64Decode64(string7, "UTF-8");
                }
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string5, bl, date, string4), byArray, byArray2);
            }
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            return documentSignException.getMessage();
        }
    }

    public String signDocumentEncodedIn64(String string, String string2, String string3, String string4, String string5, String[] stringArray) {
        ISignerKeyStoreStrategy iSignerKeyStoreStrategy = null;
        try {
            byte[] byArray = Codecs.base64Decode64(string5, "UTF-8");
            iSignerKeyStoreStrategy = string2 == null || string2.trim().equals("") ? new TokenSignerKeyStoreStrategy(string3) : new DefaultSignerKeyStoreStrategy(string2, string3);
            byte[] byArray2 = this.signDocumentInt(string, string4, iSignerKeyStoreStrategy, byArray);
            stringArray[0] = Codecs.base64Encode64(byArray2, "UTF-8");
            iSignerKeyStoreStrategy.close();
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            try {
                if (iSignerKeyStoreStrategy != null) {
                    iSignerKeyStoreStrategy.close();
                }
            }
            catch (DocumentSignException documentSignException2) {
                // empty catch block
            }
            return documentSignException.getMessage();
        }
    }

    public CetificateInformationBean getSignerInformation(String string, String string2) {
        try {
            return this.getSignerInformationInt(string, new OcspVerifierKeyStoreStrategy("", "", "", false, new Date(), ""), Utils.loadByteArrayFromFile(string2));
        }
        catch (DocumentSignException documentSignException) {
            return new CetificateInformationBean("", "");
        }
    }

    public CetificateInformationBean getSignerInformationEncodedIn64(String string, String string2) {
        try {
            return this.getSignerInformationInt(string, new OcspVerifierKeyStoreStrategy("", "", "", false, new Date(), ""), Codecs.base64Decode64(string2, "UTF-8"));
        }
        catch (DocumentSignException documentSignException) {
            return new CetificateInformationBean("", "");
        }
    }

    public CetificateInformationBean getSignerInformation(String string) {
        try {
            return new OcspVerifierKeyStoreStrategy("", "", "", false, new Date(), "").getSignerInformation(string);
        }
        catch (DocumentSignException documentSignException) {
            return new CetificateInformationBean("", "");
        }
    }

    public String EncodeBase64(String string) {
        return Codecs.base64Encode(string, "UTF-8");
    }

    public String DecodeBase64(String string) {
        return Codecs.base64Decode(string, "UTF-8");
    }

    private CetificateInformationBean getSignerInformationInt(String string, IVerifierKeyStoreStrategy iVerifierKeyStoreStrategy, byte[] byArray) throws DocumentSignException {
        DigitalSign digitalSign = null;
        try {
            Class<?> clazz = Class.forName(string);
            digitalSign = (DigitalSign)clazz.newInstance();
            digitalSign.setVerifierKeyStoreStrategy(iVerifierKeyStoreStrategy);
            return digitalSign.getSignerInformation(byArray);
        }
        catch (Exception exception) {
            throw new DocumentSignException(exception.getMessage(), exception.getCause());
        }
    }

    private void verifyDigitalSignatureInt(String string, IVerifierKeyStoreStrategy iVerifierKeyStoreStrategy, byte[] byArray, byte[] byArray2) throws DocumentSignException {
        DigitalSign digitalSign = null;
        try {
            Class<?> clazz = Class.forName(string);
            digitalSign = (DigitalSign)clazz.newInstance();
            digitalSign.setVerifierKeyStoreStrategy(iVerifierKeyStoreStrategy);
        }
        catch (Exception exception) {
            throw new DocumentSignException(exception.getMessage(), exception.getCause());
        }
        if (digitalSign != null) {
            digitalSign.verifyDigitalSignature(byArray, byArray2);
        }
    }

    private byte[] signDocumentInt(String string, String string2, ISignerKeyStoreStrategy iSignerKeyStoreStrategy, byte[] byArray) throws DocumentSignException {
        try {
            Class<?> clazz = Class.forName(string);
            DigitalSign digitalSign = (DigitalSign)clazz.newInstance();
            digitalSign.setAlias(string2);
            digitalSign.setIncludeCertificate(this.includeXMLSignerCertificate);
            digitalSign.setPdfCertificationLevel(this.pdfCertificationLevel);
            digitalSign.setSignerKeyStoreStrategy(iSignerKeyStoreStrategy);
            return digitalSign.signDocument(byArray);
        }
        catch (Exception exception) {
            throw new DocumentSignException(exception.getMessage(), exception.getCause());
        }
    }

    public String verifyDigitalSignatureTrustStore(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, Date date) {
        try {
            if (string.equalsIgnoreCase("digitalSign.PDFDigitalSign") || string.equalsIgnoreCase("digitalSign.XMLDigitalSign")) {
                byte[] byArray = Utils.loadByteArrayFromFile(string9);
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string4, string5, string7, bl, date, string6), byArray, null);
            } else {
                byte[] byArray = Utils.loadByteArrayFromFile(string8);
                byte[] byArray2 = null;
                if (string9 != null && !string9.trim().equals("")) {
                    byArray2 = Utils.loadByteArrayFromFile(string9);
                }
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string4, string5, string7, bl, date, string6), byArray, byArray2);
            }
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            return documentSignException.getMessage();
        }
    }

    public String verifyDigitalSignatureTrustStoreEncodedIn64(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, Date date) {
        try {
            if (string.equalsIgnoreCase("digitalSign.PDFDigitalSign") || string.equalsIgnoreCase("digitalSign.XMLDigitalSign")) {
                byte[] byArray = Codecs.base64Decode64(string9, "UTF-8");
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string4, string5, string7, bl, date, string6), byArray, null);
            } else {
                byte[] byArray = Codecs.base64Decode64(string8, "UTF-8");
                byte[] byArray2 = null;
                if (string9 != null && !string9.trim().equals("")) {
                    byArray2 = Codecs.base64Decode64(string9, "UTF-8");
                }
                this.verifyDigitalSignatureInt(string, new OcspVerifierKeyStoreStrategy(string2, string3, string4, string5, string7, bl, date, string6), byArray, byArray2);
            }
            return "OK";
        }
        catch (DocumentSignException documentSignException) {
            return documentSignException.getMessage();
        }
    }
}

