/*
 * Decompiled with CFR 0.152.
 */
package digitalSign;

import configuration.Configuration;
import digitalSign.CetificateInformationBean;
import digitalSign.DigitalSign;
import digitalSign.X509KeySelector;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.utils.Utils;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDigitalSign
extends DigitalSign {
    @Override
    public final byte[] signDocument(byte[] document) throws DocumentSignException {
        try {
            Document nonSignedDocument = Utils.ByteArrayToDocument(document);
            Element sigParent = nonSignedDocument.getDocumentElement();
            XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance();
            String referenceURI = "";
            List<Transform> transforms = Collections.singletonList(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference ref = sigFactory.newReference(referenceURI, sigFactory.newDigestMethod(Configuration.getInstance().getParameter("XML_DIGITAL_SIGNATURE_DIGEST_METHOD_NAME"), null), transforms, null, null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod(Configuration.getInstance().getParameter("XML_DIGITAL_SIGNATURE_ALGORITHM_NAME"), null), Collections.singletonList(ref));
            PrivateKey privateKey = this.signerKeyStoreStrategy.getSignerPrivateKey(this.alias);
            if (privateKey != null) {
                DOMSignContext dsc = new DOMSignContext(privateKey, (Node)sigParent);
                KeyInfo ki = null;
                if (this.includeCertificate) {
                    KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
                    ArrayList<Certificate> x509Content = new ArrayList<Certificate>();
                    x509Content.add(this.signerKeyStoreStrategy.getSignerCertificate(this.alias));
                    X509Data xd = kif.newX509Data(x509Content);
                    ki = kif.newKeyInfo(Collections.singletonList(xd));
                }
                XMLSignature signature = sigFactory.newXMLSignature(signedInfo, ki);
                signature.sign(dsc);
                return Utils.DocumentToByteArray(nonSignedDocument);
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_CERT_ERROR"));
        }
        catch (DocumentSignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("SIGN_DOCUMENT_ERROR"), ex.getCause());
        }
    }

    @Override
    public final void verifyDigitalSignature(byte[] document, byte[] signature) throws DocumentSignException {
        this.verifierKeyStoreStrategy.verifyCertificate(this.getSigningCertificate(document));
    }

    @Override
    public final CetificateInformationBean getSignerInformation(byte[] document) throws DocumentSignException {
        return this.verifierKeyStoreStrategy.getSignerInformation(this.getSigningCertificate(document));
    }

    private X509Certificate getSigningCertificate(byte[] document) throws DocumentSignException {
        try {
            XMLSignatureFactory factory = XMLSignatureFactory.getInstance();
            XMLSignature extractedSignature = this.extractXMLSignature(factory, document);
            if (extractedSignature.getKeyInfo() != null) {
                X509Data data = (X509Data)extractedSignature.getKeyInfo().getContent().get(0);
                List<?> x509DataContent = data.getContent();
                for (Object content : x509DataContent) {
                    if (!(content instanceof X509Certificate)) continue;
                    return (X509Certificate)content;
                }
                return null;
            }
            return (X509Certificate)this.verifierKeyStoreStrategy.getSignerCertificateFromCA();
        }
        catch (DocumentSignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("VERIFY_DIGITAL_SIGNATURE_ERROR"), ex.getCause());
        }
    }

    private XMLSignature extractXMLSignature(XMLSignatureFactory factory, byte[] document) throws DocumentSignException {
        try {
            DOMValidateContext valContext;
            Document signedDocument = Utils.ByteArrayToDocument(document);
            NodeList signatureNodes = signedDocument.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signatureNodes.getLength() == 0) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("NO_SIGNATURE_ELEMENT_ERROR"));
            }
            Node lastSignature = signatureNodes.item(signatureNodes.getLength() - 1);
            Certificate signerCertificate = this.verifierKeyStoreStrategy.getSignerCertificateFromCA();
            if (signerCertificate != null) {
                this.verifierKeyStoreStrategy.verifyCertificate(signerCertificate);
                valContext = new DOMValidateContext(signerCertificate.getPublicKey(), lastSignature);
            } else {
                valContext = new DOMValidateContext(new X509KeySelector(), lastSignature);
            }
            XMLSignature extractedSignature = factory.unmarshalXMLSignature(valContext);
            boolean validationResult = extractedSignature.validate(valContext);
            if (validationResult) {
                return extractedSignature;
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("CORRUPT_DOCUMENT"));
        }
        catch (DocumentSignException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("VERIFY_DIGITAL_SIGNATURE_ERROR"), ex.getCause());
        }
    }
}

