/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.signerStrategy;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.signerStrategy.ISignerKeyStoreStrategy;
import digitalSign.signerStrategy.KeyStoreCetificateBean;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public abstract class AbstractSignerKeyStoreStrategy
implements ISignerKeyStoreStrategy {
    private KeyStore keyStore;
    protected String signerInfoPass;

    public AbstractSignerKeyStoreStrategy(String signerInfoPass) {
        this.signerInfoPass = signerInfoPass;
    }

    @Override
    public final PrivateKey getSignerPrivateKey(String signerAlias) throws DocumentSignException {
        try {
            char[] password = this.signerInfoPass.toCharArray();
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(this.getAlias(this.keyStore, signerAlias), password);
            return privateKey;
        }
        catch (IOException ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("WRONG_PASSWORD_ERROR"), ex.getCause());
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("GET_PRIVATE_KEY_ERROR"), ex.getCause());
        }
    }

    @Override
    public final Certificate getSignerCertificate(String signerAlias) throws DocumentSignException {
        try {
            X509Certificate certificate = (X509Certificate)this.keyStore.getCertificate(this.getAlias(this.keyStore, signerAlias));
            return certificate;
        }
        catch (IOException ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("WRONG_PASSWORD_ERROR"), ex.getCause());
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("GET_CERTIFICATE_ERROR"), ex.getCause());
        }
    }

    @Override
    public List<KeyStoreCetificateBean> listKeyStoreCetificateBean() throws DocumentSignException {
        ArrayList<KeyStoreCetificateBean> certificates = new ArrayList<KeyStoreCetificateBean>();
        try {
            Enumeration<String> as = this.keyStore.aliases();
            while (as.hasMoreElements()) {
                char[] password;
                String alias = as.nextElement();
                PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(alias, password = this.signerInfoPass.toCharArray());
                if (privateKey == null) continue;
                X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
                String[] aux = cert.getSubjectDN().getName().split(",");
                String cn = aux[0].trim().split("=")[1];
                certificates.add(new KeyStoreCetificateBean(alias, cn));
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("GET_PRIVATE_KEY_ERROR"), ex.getCause());
        }
        return certificates;
    }

    @Override
    public void close() throws DocumentSignException {
        this.keyStore = null;
        this.signerInfoPass = null;
    }

    protected final void initKeyStore() throws DocumentSignException {
        this.keyStore = this.getKeyStore(this.signerInfoPass);
    }

    protected abstract KeyStore getKeyStore(String var1) throws DocumentSignException;

    private String getAlias(KeyStore keyStore, String signerAlias) throws Exception {
        if (signerAlias == null || signerAlias.trim().equals("")) {
            Enumeration<String> enume = keyStore.aliases();
            signerAlias = null;
            while (signerAlias == null && enume.hasMoreElements()) {
                signerAlias = keyStore.aliases().nextElement();
                try {
                    if (keyStore.getKey(signerAlias, this.signerInfoPass.toCharArray()) != null) continue;
                    signerAlias = null;
                }
                catch (Exception ex) {
                    signerAlias = null;
                }
            }
        }
        return signerAlias;
    }
}

