/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.signerStrategy;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.signerStrategy.AbstractSignerKeyStoreStrategy;
import digitalSign.signerStrategy.ISignerKeyStoreStrategy;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;

public final class DefaultSignerKeyStoreStrategy
extends AbstractSignerKeyStoreStrategy
implements ISignerKeyStoreStrategy {
    private String signerInfoPath;

    public DefaultSignerKeyStoreStrategy(String signerInfoPath, String signerInfoPass) throws DocumentSignException {
        super(signerInfoPass);
        this.signerInfoPath = signerInfoPath;
        super.initKeyStore();
    }

    @Override
    protected final KeyStore getKeyStore(String signerInfoPass) throws DocumentSignException {
        try {
            KeyStore keyStore = KeyStore.getInstance(Configuration.getInstance().getParameter("PKCS12_KEYSTORE_TYPE"));
            FileInputStream privateKeyStream = new FileInputStream(this.signerInfoPath);
            char[] password = signerInfoPass.toCharArray();
            keyStore.load(privateKeyStream, password);
            privateKeyStream.close();
            return keyStore;
        }
        catch (Exception ex) {
            try {
                KeyStore keyStore = KeyStore.getInstance(Configuration.getInstance().getParameter("JKS_KEYSTORE_TYPE"));
                FileInputStream privateKeyStream = new FileInputStream(this.signerInfoPath);
                char[] password = signerInfoPass.toCharArray();
                keyStore.load(privateKeyStream, password);
                privateKeyStream.close();
                return keyStore;
            }
            catch (IOException exe) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("WRONG_PASSWORD_ERROR"), exe.getCause());
            }
            catch (Exception exep) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("OPEN_KEYSTORE_ERROR"), exep.getCause());
            }
        }
    }

    @Override
    public final void close() throws DocumentSignException {
        super.close();
        this.signerInfoPath = null;
    }
}

