/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.signerStrategy;

import configuration.Configuration;
import configuration.PKCS11Config;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.exceptions.TokenErrorCode;
import digitalSign.exceptions.TokenLoadException;
import digitalSign.signerStrategy.AbstractSignerKeyStoreStrategy;
import digitalSign.signerStrategy.ISignerKeyStoreStrategy;
import digitalSign.utils.OSDetector;
import digitalSign.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class TokenSignerKeyStoreStrategy
extends AbstractSignerKeyStoreStrategy
implements ISignerKeyStoreStrategy {
    private SunPKCS11 token;
    private CallbackHandler callbackHandler = new CallbackHandler(){

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(TokenSignerKeyStoreStrategy.this.signerInfoPass.toCharArray());
            }
        }
    };

    public TokenSignerKeyStoreStrategy(String signerInfoPass) throws DocumentSignException {
        super(signerInfoPass);
        super.initKeyStore();
    }

    @Override
    protected final KeyStore getKeyStore(String signerInfoPass) throws DocumentSignException {
        TokenErrorCode errorCode = TokenErrorCode.NO_TOKEN_LOADED;
        String lineSep = System.getProperty("line.separator");
        for (PKCS11Config cfg : Configuration.getInstance().getTokenPKCS11Libraries(OSDetector.getOSFamily())) {
            String library = cfg.getLibrary();
            if (library == null || library.trim().equals("")) continue;
            File file = new File(cfg.getLibrary());
            if (file.exists() && file.isFile()) {
                System.out.println("Checking PKCS11Config " + cfg.getName() + "=" + cfg.getLibrary());
                try {
                    long[] slots;
                    PKCS11 p11 = PKCS11.getInstance(library.trim(), "C_GetFunctionList", null, false);
                    for (long slot : slots = p11.C_GetSlotList(true)) {
                        if (library.contains("(")) {
                            File tempDir = this.getTempDir(file);
                            if (this.checkDirectory(tempDir)) {
                                File tmpFile = new File(tempDir, file.getName());
                                if (!tmpFile.exists() || !tmpFile.isFile()) {
                                    Utils.copyFileUsingStream(file, tmpFile);
                                }
                                library = tmpFile.getAbsolutePath();
                                System.out.println("Temp directory " + tempDir.getAbsolutePath());
                            } else {
                                System.out.println("Cant write in temp directory " + tempDir.getAbsolutePath());
                            }
                        }
                        if (library.contains(" ")) {
                            library = '\"' + library + '\"';
                        }
                        StringBuilder strConf = new StringBuilder();
                        strConf.append("name = ");
                        strConf.append(cfg.getName());
                        strConf.append(lineSep);
                        strConf.append("library = ");
                        strConf.append(library.trim());
                        strConf.append(lineSep);
                        strConf.append("slot = ");
                        strConf.append(slot);
                        this.token = new SunPKCS11((InputStream)new ByteArrayInputStream(strConf.toString().getBytes()));
                        try {
                            this.token.logout();
                        }
                        catch (LoginException ex) {
                            // empty catch block
                        }
                        this.token.setCallbackHandler(this.callbackHandler);
                        Security.addProvider(this.token);
                        try {
                            KeyStore keyStore = KeyStore.getInstance(Configuration.getInstance().getParameter("PKCS11_KEYSTORE_TYPE"), this.token);
                            keyStore.load(null, null);
                            return keyStore;
                        }
                        catch (Exception ex2) {
                            try {
                                this.unloadToken();
                            }
                            catch (Exception ex3) {
                                // empty catch block
                            }
                            if (!(ex2.getCause() instanceof FailedLoginException) && (!(ex2.getCause() instanceof PKCS11Exception) || !ex2.getCause().getMessage().contains(TokenErrorCode.CKR_PIN_INCORRECT.getDescription()))) continue;
                            errorCode = TokenErrorCode.CKR_PIN_INCORRECT;
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    continue;
                }
            }
            System.out.println("PKCS11Config " + cfg.getName() + "=" + cfg.getLibrary() + " not found.");
        }
        throw new TokenLoadException(Configuration.getInstance().getMessage("NO_TOKEN_LOADED"), errorCode);
    }

    @Override
    public final void close() throws DocumentSignException {
        super.close();
        this.unloadToken();
    }

    private void unloadToken() throws DocumentSignException {
        if (this.token != null) {
            try {
                this.token.logout();
            }
            catch (Exception ex) {
                throw new DocumentSignException(ex.getMessage(), ex.getCause());
            }
            Security.removeProvider(this.token.getName());
        }
    }

    private File getTempDir(File file) {
        File tmpDir = this.getEnvFile("Temp");
        if (!this.checkDirectory(tmpDir) && !this.checkDirectory(tmpDir = this.getEnvFile("Tmp"))) {
            String sysRoot = System.getenv("SystemRoot");
            if (sysRoot != null) {
                tmpDir = new File(sysRoot, "Temp");
            }
            if (!this.checkDirectory(tmpDir)) {
                File root;
                File next = root = file.getParentFile();
                if (root != null) {
                    while ((next = (root = next).getParentFile()) != null) {
                    }
                }
                if (!(this.checkDirectory(tmpDir = new File(root, "Tmp")) || this.checkDirectory(tmpDir = new File(root, "Temp")) || tmpDir.exists())) {
                    tmpDir.mkdir();
                }
            }
        }
        return tmpDir;
    }

    private File getEnvFile(String env) {
        String strEnv = System.getenv(env);
        if (strEnv != null) {
            return new File(strEnv);
        }
        return null;
    }

    private boolean checkDirectory(File tmpDir) {
        return tmpDir != null && tmpDir.exists() && tmpDir.isDirectory() && tmpDir.canWrite() && !tmpDir.getAbsolutePath().contains("(");
    }
}

