/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.utils;

public class OSDetector {
    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getOSFamily() {
        String os = OSDetector.getOSName();
        if (OSDetector.isWindows(os)) {
            return "windows";
        }
        if (OSDetector.isMac(os)) {
            return "mac";
        }
        if (OSDetector.isUnix(os)) {
            return "linux";
        }
        if (OSDetector.isSolaris(os)) {
            return "solaris";
        }
        return "otro";
    }

    private static boolean isWindows(String os) {
        return os.indexOf("win") >= 0;
    }

    private static boolean isMac(String os) {
        return os.indexOf("mac") >= 0;
    }

    private static boolean isUnix(String os) {
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0 || os.indexOf("aix") > 0;
    }

    private static boolean isSolaris(String os) {
        return os.indexOf("sunos") >= 0;
    }
}

