/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.utils;

import configuration.Configuration;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.utils.Codecs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class Utils {
    public static byte[] loadByteArrayFromFile(String fileName) throws DocumentSignException {
        try {
            if (fileName != null && !fileName.isEmpty()) {
                File file = new File(fileName);
                return Utils.loadByteArrayFromStream(new FileInputStream(file));
            }
            return null;
        }
        catch (IOException ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static byte[] loadByteArrayFromURL(URL url) throws DocumentSignException {
        try {
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            return Utils.loadByteArrayFromStream(con.getInputStream());
        }
        catch (IOException ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    private static byte[] loadByteArrayFromStream(InputStream stream) throws DocumentSignException {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        try {
            byte[] byteChunk = new byte[4096];
            int n = stream.read(byteChunk);
            if (n > 0) {
                if (n > 3 && byteChunk[0] == -17 && byteChunk[1] == -69 && byteChunk[2] == -65) {
                    bais.write(byteChunk, 3, n - 3);
                } else {
                    bais.write(byteChunk, 0, n);
                }
                while ((n = stream.read(byteChunk)) > 0) {
                    bais.write(byteChunk, 0, n);
                }
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw new DocumentSignException(ex.getMessage(), ex.getCause());
                }
            }
        }
        return bais.toByteArray();
    }

    public static void writeFileFromByteArray(String fileName, byte[] fileBytes) throws DocumentSignException {
        try {
            if (fileName != null && fileBytes != null) {
                Utils.writeStreamFromByteArray(new FileOutputStream(fileName), fileBytes);
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static void writeFileFromByteArray(URL url, byte[] fileBytes) throws DocumentSignException {
        try {
            if (url != null && fileBytes != null) {
                Utils.writeStreamFromByteArray(new FileOutputStream(new File(url.toURI())), fileBytes);
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    private static void writeStreamFromByteArray(OutputStream stream, byte[] fileBytes) throws DocumentSignException {
        try {
            if (stream != null && fileBytes != null) {
                stream.write(fileBytes);
                stream.close();
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static Document ByteArrayToDocument(byte[] byteArray) throws DocumentSignException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(byteArray));
            return document;
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static byte[] DocumentToByteArray(Document document) throws DocumentSignException {
        try {
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            return out.toByteArray();
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static byte[] streamToByteArray(InputStream is) throws DocumentSignException {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws DocumentSignException {
        try {
            InputStream is = null;
            OutputStream os = null;
            try {
                int length;
                is = new FileInputStream(source);
                os = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) > 0) {
                    os.write(buffer, 0, length);
                }
            }
            finally {
                is.close();
                os.close();
            }
        }
        catch (Exception ex) {
            throw new DocumentSignException(ex.getMessage(), ex.getCause());
        }
    }

    public static byte[] getBinaryData(Boolean fileEmbedded, String document) throws Exception {
        byte[] documentoFirmar = null;
        if (documentoFirmar == null) {
            documentoFirmar = fileEmbedded != false ? Codecs.base64Decode(document.getBytes("UTF-8")) : Utils.loadByteArrayFromURL(new URL(document));
        }
        return documentoFirmar;
    }

    public static String getTextData(Boolean fileEmbedded, String document, List<byte[]> docsData) throws Exception {
        byte[] content = Utils.getBinaryData(fileEmbedded, document);
        docsData.add(content);
        try {
            return new String(content, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return new String(content);
        }
    }

    public static void cleanDirectory() {
        String tempDir = Configuration.getTempDirectory();
        File dir = new File(tempDir);
        for (File icepdfTmp : dir.listFiles()) {
            if (!icepdfTmp.isFile() || !icepdfTmp.getName().contains("ICEpdfTempFile")) continue;
            icepdfTmp.delete();
        }
    }
}

