/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.verifierStrategy;

import configuration.Configuration;
import digitalSign.CetificateInformationBean;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.verifierStrategy.IVerifierKeyStoreStrategy;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;

public abstract class DefaultVerifierKeyStoreStrategy
implements IVerifierKeyStoreStrategy {
    private String certificateAuthorityPath;
    private String certificateAuthorityRevocationsPath;
    private String signerCertificateFromCAPath;
    private boolean checkNonRepudiation;
    private boolean usesTrustStore;
    private String certificateAuthorityTrustStorePassword;
    private String certificateAuthorityTrustStoreAlias;
    private Date date;

    public DefaultVerifierKeyStoreStrategy(String certificateAuthorityPath, String certificateAuthorityRevocationsPath, String signerCertificateFromCAPath, boolean checkNonRepudiation, Date date) {
        this.certificateAuthorityPath = certificateAuthorityPath;
        this.signerCertificateFromCAPath = signerCertificateFromCAPath;
        this.certificateAuthorityRevocationsPath = certificateAuthorityRevocationsPath;
        this.checkNonRepudiation = checkNonRepudiation;
        this.usesTrustStore = false;
        GregorianCalendar cal1950 = new GregorianCalendar(1950, 1, 1);
        this.date = date.getTime() < cal1950.getTimeInMillis() ? null : date;
    }

    public DefaultVerifierKeyStoreStrategy(String certificateAuthorityTrustStorePath, String certificateAuthorityTrustStorePassword, String certificateAuthorityTrustStoreAlias, String certificateAuthorityRevocationsPath, String signerCertificateFromCAPath, boolean checkNonRepudiation, Date date) {
        this.certificateAuthorityPath = certificateAuthorityTrustStorePath;
        this.signerCertificateFromCAPath = signerCertificateFromCAPath;
        this.certificateAuthorityRevocationsPath = certificateAuthorityRevocationsPath;
        this.checkNonRepudiation = checkNonRepudiation;
        this.usesTrustStore = true;
        this.certificateAuthorityTrustStorePassword = certificateAuthorityTrustStorePassword;
        this.certificateAuthorityTrustStoreAlias = certificateAuthorityTrustStoreAlias;
        GregorianCalendar cal1950 = new GregorianCalendar(1950, 1, 1);
        this.date = date.getTime() < cal1950.getTimeInMillis() ? null : date;
    }

    @Override
    public final Certificate getSignerCertificateFromCA() throws DocumentSignException {
        return this.getCertificate(this.signerCertificateFromCAPath);
    }

    @Override
    public final void verifyCertificate(Certificate signerCertificate) throws DocumentSignException {
        if (signerCertificate == null) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("UNDEFINED_CERTIFICATE_ERROR"));
        }
        this.verifyX509Certificate((X509Certificate)signerCertificate);
    }

    @Override
    public final CetificateInformationBean getSignerInformation(String pathCertificate) throws DocumentSignException {
        return this.getSignerInformation(this.getCertificate(pathCertificate));
    }

    @Override
    public final CetificateInformationBean getSignerInformation(Certificate signingCertificate) throws DocumentSignException {
        if (signingCertificate != null) {
            return this.getX509SignerInformation((X509Certificate)signingCertificate);
        }
        throw new DocumentSignException(Configuration.getInstance().getMessage("UNDEFINED_CERTIFICATE_ERROR"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyX509Certificate(X509Certificate signerCertificate) throws DocumentSignException {
        boolean nonRepudiation;
        boolean digitalSignature;
        Certificate caCert;
        try {
            caCert = this.usesTrustStore ? this.getCertificateFromKeyStore(this.certificateAuthorityPath, this.certificateAuthorityTrustStorePassword, this.certificateAuthorityTrustStoreAlias) : this.getCertificate(this.certificateAuthorityPath);
            signerCertificate.verify(caCert.getPublicKey());
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("UNSIGNED_CERTIFICATE_ERROR"), ex.getCause());
        }
        Certificate certFromCA = this.getSignerCertificateFromCA();
        boolean equals = signerCertificate.equals(certFromCA);
        if (certFromCA != null && !equals) throw new DocumentSignException(Configuration.getInstance().getMessage("INVALID_CERTIFICATE_ERROR"));
        try {
            digitalSignature = signerCertificate.getKeyUsage()[0];
            nonRepudiation = signerCertificate.getKeyUsage()[1];
        }
        catch (Exception ex) {
            digitalSignature = false;
            nonRepudiation = false;
        }
        if (!digitalSignature || this.checkNonRepudiation && !nonRepudiation) throw new DocumentSignException(Configuration.getInstance().getMessage("USAGE_CERTIFICATE_ERROR"));
        if (this.isRevoke(caCert, signerCertificate)) throw new DocumentSignException(Configuration.getInstance().getMessage("REVOKED_CERTIFICATE_ERROR"));
        try {
            if (this.date != null) {
                signerCertificate.checkValidity(this.date);
                return;
            } else {
                signerCertificate.checkValidity();
            }
            return;
        }
        catch (Exception ex) {
            throw new DocumentSignException(Configuration.getInstance().getMessage("VALIDITY_CERTIFICATE_ERROR"), ex.getCause());
        }
    }

    protected boolean isRevoke(Certificate caCert, X509Certificate certificate) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(Configuration.getInstance().getParameter("X509_CERTIFICATE_TYPE"));
            FileInputStream fis = new FileInputStream(this.certificateAuthorityRevocationsPath);
            X509CRL crl = (X509CRL)cf.generateCRL(fis);
            fis.close();
            return crl.isRevoked(certificate);
        }
        catch (Exception ex) {
            return true;
        }
    }

    protected Certificate getCertificate(String path) throws DocumentSignException {
        if (path == null || path.trim().equals("")) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            CertificateFactory cf = CertificateFactory.getInstance(Configuration.getInstance().getParameter("X509_CERTIFICATE_TYPE"));
            return (X509Certificate)cf.generateCertificate(fis);
        }
        catch (Exception ex) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw new DocumentSignException(Configuration.getInstance().getMessage("GET_CERTIFICATE_ERROR"), ex.getCause());
        }
    }

    protected CetificateInformationBean getX509SignerInformation(X509Certificate x509Certificate) {
        return new CetificateInformationBean(((Object)x509Certificate.getIssuerDN()).toString(), ((Object)x509Certificate.getSubjectDN()).toString());
    }

    protected final Certificate getCertificateFromKeyStore(String trustStorePath, String trustStorePass, String trusStoreAlias) throws DocumentSignException {
        try {
            KeyStore keyStore = KeyStore.getInstance(Configuration.getInstance().getParameter("JKS_KEYSTORE_TYPE"));
            FileInputStream privateKeyStream = new FileInputStream(trustStorePath);
            char[] password = trustStorePass.toCharArray();
            keyStore.load(privateKeyStream, password);
            privateKeyStream.close();
            return keyStore.getCertificate(trusStoreAlias);
        }
        catch (Exception ex) {
            try {
                KeyStore keyStore = KeyStore.getInstance(Configuration.getInstance().getParameter("PKCS12_KEYSTORE_TYPE"));
                FileInputStream privateKeyStream = new FileInputStream(trustStorePass);
                char[] password = trustStorePass.toCharArray();
                keyStore.load(privateKeyStream, password);
                privateKeyStream.close();
                return keyStore.getCertificate(trusStoreAlias);
            }
            catch (IOException exe) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("WRONG_PASSWORD_ERROR"), exe.getCause());
            }
            catch (Exception exep) {
                throw new DocumentSignException(Configuration.getInstance().getMessage("OPEN_KEYSTORE_ERROR"), exep.getCause());
            }
        }
    }
}

