/*
 * Decompiled with CFR 0.152.
 */
package digitalSign.verifierStrategy;

import digitalSign.utils.Utils;
import digitalSign.verifierStrategy.DefaultVerifierKeyStoreStrategy;
import digitalSign.verifierStrategy.IVerifierKeyStoreStrategy;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public final class OcspVerifierKeyStoreStrategy
extends DefaultVerifierKeyStoreStrategy
implements IVerifierKeyStoreStrategy {
    private String urlOcspService;

    public OcspVerifierKeyStoreStrategy(String certificateAuthorityPath, String certificateAuthorityRevocationsPath, String signerCertificateFromCAPath, boolean checkNonRepudiation, Date fecha, String urlOcspService) {
        super(certificateAuthorityPath, certificateAuthorityRevocationsPath, signerCertificateFromCAPath, checkNonRepudiation, fecha);
        this.urlOcspService = urlOcspService;
    }

    public OcspVerifierKeyStoreStrategy(String certificateAuthorityTrustStorePath, String certificateAuthorityTrustStorePassword, String certificateAuthorityTrustStoreAlias, String certificateAuthorityRevocationsPath, String signerCertificateFromCAPath, boolean checkNonRepudiation, Date fecha, String urlOcspService) {
        super(certificateAuthorityTrustStorePath, certificateAuthorityTrustStorePassword, certificateAuthorityTrustStoreAlias, certificateAuthorityRevocationsPath, signerCertificateFromCAPath, checkNonRepudiation, fecha);
        this.urlOcspService = urlOcspService;
    }

    @Override
    protected boolean isRevoke(Certificate caCert, X509Certificate certificate) {
        if (this.urlOcspService == null || this.urlOcspService.trim().equals("")) {
            return super.isRevoke(caCert, certificate);
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1), new X509CertificateHolder(caCert.getEncoded()), certificate.getSerialNumber());
            OCSPReqBuilder ocspPeticionBuilder = new OCSPReqBuilder();
            ocspPeticionBuilder.addRequest(id);
            OCSPReq ocspPeticion = ocspPeticionBuilder.build();
            URL url = new URL(this.urlOcspService);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(ocspPeticion.getEncoded());
            dataOut.flush();
            dataOut.close();
            InputStream in = (InputStream)con.getContent();
            byte[] bytes = Utils.streamToByteArray(in);
            OCSPResp ocspResponse = new OCSPResp(bytes);
            int ocspResponseStatus = ocspResponse.getStatus();
            if (0 == ocspResponseStatus) {
                Object responseObject = ocspResponse.getResponseObject();
                BasicOCSPResp basicOCSPResp = (BasicOCSPResp)responseObject;
                SingleResp[] responses = basicOCSPResp.getResponses();
                if (responses.length == 1) {
                    SingleResp resp = responses[0];
                    CertificateStatus certStatus = resp.getCertStatus();
                    if (certStatus == CertificateStatus.GOOD) {
                        return false;
                    }
                    if (certStatus instanceof RevokedStatus) {
                        return true;
                    }
                    return super.isRevoke(caCert, certificate);
                }
                return super.isRevoke(caCert, certificate);
            }
            return super.isRevoke(caCert, certificate);
        }
        catch (Exception ex) {
            return super.isRevoke(caCert, certificate);
        }
    }
}

