/*
 * Decompiled with CFR 0.152.
 */
package verifier;

import configuration.Configuration;
import digitalSign.CetificateInformationBean;
import digitalSign.PDFTools;
import digitalSign.ServerSideSign;
import digitalSign.exceptions.DocumentSignException;
import digitalSign.signerStrategy.AbstractSignerKeyStoreStrategy;
import digitalSign.signerStrategy.DefaultSignerKeyStoreStrategy;
import digitalSign.signerStrategy.KeyStoreCetificateBean;
import digitalSign.signerStrategy.TokenSignerKeyStoreStrategy;
import digitalSign.utils.Codecs;
import digitalSign.utils.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

public class Test
extends JFrame {
    private ServerSideSign serverSideSign = new ServerSideSign();
    private JButton Decode64Button;
    private JButton ExtractPDFText;
    private JButton GetCetInfo;
    private JButton GetPlainButton;
    private JButton GetXMLButton;
    private JButton SignPdfButton;
    private JButton SignPlainButton;
    private JButton SignXMLButton;
    private JButton VerifyPdfButton;
    private JButton VerifyPdfButton1;
    private JButton VerifyPlainButton;
    private JButton VerifyXMLButton;
    private JCheckBox cIncludeXMLSignerCertificate;
    private JTextField certificateAlias;
    private JButton certificateButton;
    private JTextField certificatePath;
    private JPasswordField certificatePwd;
    private JButton documentButton;
    private JTextField documentPath;
    private JButton jButtonListTokenCert;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPaneResult;
    private JPanel mainPanel;
    private JTextArea resultLabel;
    private JButton signButton;
    private JTextField signPath;

    public Test() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.documentButton = new JButton();
        this.documentPath = new JTextField();
        this.certificateButton = new JButton();
        this.certificatePath = new JTextField();
        this.VerifyPlainButton = new JButton();
        this.signButton = new JButton();
        this.signPath = new JTextField();
        this.VerifyXMLButton = new JButton();
        this.VerifyPdfButton = new JButton();
        this.SignPlainButton = new JButton();
        this.SignXMLButton = new JButton();
        this.SignPdfButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.certificatePwd = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.certificateAlias = new JTextField();
        this.GetPlainButton = new JButton();
        this.GetXMLButton = new JButton();
        this.VerifyPdfButton1 = new JButton();
        this.jScrollPaneResult = new JScrollPane();
        this.resultLabel = new JTextArea();
        this.GetCetInfo = new JButton();
        this.ExtractPDFText = new JButton();
        this.Decode64Button = new JButton();
        this.jButtonListTokenCert = new JButton();
        this.cIncludeXMLSignerCertificate = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.documentButton.setText("Select");
        this.documentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.documentButtonActionPerformed(evt);
            }
        });
        this.documentPath.setText("C:\\Temp\\PdfPA.pdf");
        this.documentPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.documentPathActionPerformed(evt);
            }
        });
        this.certificateButton.setText("Select");
        this.certificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.certificateButtonActionPerformed(evt);
            }
        });
        this.certificatePath.setText("C:\\palzuri\\KBs\\FirmaDigital\\CorreoUY\\ANCCA - Prueba PERSONA\\ANCCA - Prueba PERSONA.pfx");
        this.certificatePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.certificatePathActionPerformed(evt);
            }
        });
        this.VerifyPlainButton.setText("Verify Plain Signature");
        this.VerifyPlainButton.setActionCommand("VerifySignature");
        this.VerifyPlainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.VerifyPlainButtonActionPerformed(evt);
            }
        });
        this.signButton.setText("Select");
        this.signButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.signButtonActionPerformed(evt);
            }
        });
        this.VerifyXMLButton.setText("Verify XML Signature");
        this.VerifyXMLButton.setActionCommand("VerifySignature");
        this.VerifyXMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.VerifyXMLButtonActionPerformed(evt);
            }
        });
        this.VerifyPdfButton.setText("Verify PDF Signature");
        this.VerifyPdfButton.setActionCommand("VerifySignature");
        this.VerifyPdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.VerifyPdfButtonActionPerformed(evt);
            }
        });
        this.SignPlainButton.setText("Sign Plain");
        this.SignPlainButton.setActionCommand("VerifySignature");
        this.SignPlainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.SignPlainButtonActionPerformed(evt);
            }
        });
        this.SignXMLButton.setText("Sign XML");
        this.SignXMLButton.setActionCommand("VerifySignature");
        this.SignXMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.SignXMLButtonActionPerformed(evt);
            }
        });
        this.SignPdfButton.setText("Sign PDF");
        this.SignPdfButton.setActionCommand("VerifySignature");
        this.SignPdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.SignPdfButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Certificate Password:");
        this.jLabel2.setText("Certificate:");
        this.jLabel3.setText("Signature:");
        this.jLabel4.setText("Document:");
        this.certificatePwd.setText("Prueba.0");
        this.jLabel5.setText("Certificate Alias:");
        this.certificateAlias.setText("le-011eefdc-7338-4897-809b-951b6ab2316e");
        this.GetPlainButton.setText("Get Plain Signature Info");
        this.GetPlainButton.setActionCommand("VerifySignature");
        this.GetPlainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.GetPlainButtonActionPerformed(evt);
            }
        });
        this.GetXMLButton.setText("Get XML Signature Info");
        this.GetXMLButton.setActionCommand("VerifySignature");
        this.GetXMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.GetXMLButtonActionPerformed(evt);
            }
        });
        this.VerifyPdfButton1.setText("Get PDF Signature Info");
        this.VerifyPdfButton1.setActionCommand("VerifySignature");
        this.VerifyPdfButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.VerifyPdfButton1ActionPerformed(evt);
            }
        });
        this.resultLabel.setColumns(20);
        this.resultLabel.setRows(5);
        this.jScrollPaneResult.setViewportView(this.resultLabel);
        this.GetCetInfo.setText("Get Certificate Info");
        this.GetCetInfo.setActionCommand("VerifySignature");
        this.GetCetInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.GetCetInfoActionPerformed(evt);
            }
        });
        this.ExtractPDFText.setText("Extract PDF Text");
        this.ExtractPDFText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.ExtractPDFTextActionPerformed(evt);
            }
        });
        this.Decode64Button.setText("Decode64");
        this.Decode64Button.setActionCommand("VerifySignature");
        this.Decode64Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.Decode64ButtonActionPerformed(evt);
            }
        });
        this.jButtonListTokenCert.setText("List Certificates in Token");
        this.jButtonListTokenCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.jButtonListTokenCertActionPerformed(evt);
            }
        });
        this.cIncludeXMLSignerCertificate.setLabel("XML Signer Cert");
        this.cIncludeXMLSignerCertificate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.cIncludeXMLSignerCertificateActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2).add(1, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(1).add((Component)this.certificateAlias, -1, 489, Short.MAX_VALUE)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.certificatePwd, -1, 471, Short.MAX_VALUE)).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.certificatePath, -1, 447, Short.MAX_VALUE).add((Component)this.signPath, -1, 447, Short.MAX_VALUE).add((Component)this.documentPath, -1, 447, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.documentButton, -1, -1, Short.MAX_VALUE).add((Component)this.signButton, -1, -1, Short.MAX_VALUE).add((Component)this.certificateButton))).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(14, 14, 14).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.VerifyXMLButton, -2, 173, -2).add((Component)this.VerifyPdfButton, -2, 173, -2).add((Component)this.VerifyPlainButton).add((Component)this.ExtractPDFText, -2, 173, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.SignPlainButton).add((Component)this.SignXMLButton, -1, -1, Short.MAX_VALUE).add((Component)this.SignPdfButton, -1, -1, Short.MAX_VALUE)).add((Component)this.Decode64Button)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add(1, (Component)this.VerifyPdfButton1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonListTokenCert, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2, false).add(1, (Component)this.GetXMLButton, -1, -1, Short.MAX_VALUE).add(1, (Component)this.GetPlainButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2).add((Component)this.GetCetInfo).add((Component)this.cIncludeXMLSignerCertificate)))).addPreferredGap(0, 16, Short.MAX_VALUE))).add(101, 101, 101)).add((Component)this.jScrollPaneResult, -1, 679, Short.MAX_VALUE)).add(20, 20, 20)));
        mainPanelLayout.linkSize(new Component[]{this.VerifyPdfButton, this.VerifyPlainButton, this.VerifyXMLButton}, 1);
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.documentPath, -2, -1, -2).add((Component)this.documentButton)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jLabel3).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.signButton).add((Component)this.signPath, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.certificatePath, -2, -1, -2).add((Component)this.certificateButton)).add(6, 6, 6).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.certificatePwd, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.certificateAlias, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.VerifyPlainButton).addPreferredGap(0).add((Component)this.VerifyXMLButton).addPreferredGap(1).add((Component)this.VerifyPdfButton)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.SignPlainButton).addPreferredGap(0).add((Component)this.SignXMLButton).addPreferredGap(1).add((Component)this.SignPdfButton)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.GetPlainButton).add((Component)this.GetCetInfo)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.GetXMLButton).add((Component)this.cIncludeXMLSignerCertificate)).addPreferredGap(1).add((Component)this.VerifyPdfButton1))).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.ExtractPDFText).add((Component)this.Decode64Button).add((Component)this.jButtonListTokenCert)).addPreferredGap(0).add((Component)this.jScrollPaneResult, -2, -1, -2).addContainerGap()));
        mainPanelLayout.linkSize(new Component[]{this.VerifyPlainButton, this.certificateButton, this.documentButton, this.signButton}, 2);
        mainPanelLayout.linkSize(new Component[]{this.certificatePath, this.documentPath, this.signPath}, 2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.mainPanel, -2, -1, -2).add(196, 196, 196)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void SignPdfButtonActionPerformed(ActionEvent evt) {
        String outFile = this.documentPath.getText().replaceAll("(?i)\\.pdf", "-Signed.pdf");
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        this.serverSideSign.setPdfCertificationLevel(1);
        String res = this.serverSideSign.signDocument("digitalSign.PDFDigitalSign", this.certificatePath.getText(), this.certificatePwd.getText(), this.certificateAlias.getText(), this.documentPath.getText(), outFile);
        if (res.trim().equals("")) {
            this.resultLabel.setText("Result: OK");
        } else {
            this.resultLabel.setText("Result: " + res);
        }
    }

    private void SignXMLButtonActionPerformed(ActionEvent evt) {
        String outFile = this.documentPath.getText().replaceAll("(?i)\\.xml", "-Signed.xml");
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        String res = this.serverSideSign.signDocument("digitalSign.XMLDigitalSign", this.certificatePath.getText(), this.certificatePwd.getText(), this.certificateAlias.getText(), this.documentPath.getText(), outFile);
        if (res.trim().equals("")) {
            this.resultLabel.setText("Result: OK");
        } else {
            this.resultLabel.setText("Result: " + res);
        }
    }

    private void SignPlainButtonActionPerformed(ActionEvent evt) {
        String outFile = this.documentPath.getText() + ".sign";
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        String res = this.serverSideSign.signDocument("digitalSign.PlainTextDigitalSign", this.certificatePath.getText(), this.certificatePwd.getText(), this.certificateAlias.getText(), this.documentPath.getText(), outFile);
        if (res.trim().equals("")) {
            this.resultLabel.setText("Result: OK");
        } else {
            this.resultLabel.setText("Result: " + res);
        }
    }

    private void VerifyPdfButtonActionPerformed(ActionEvent evt) {
        block4: {
            try {
                this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
                String res = this.serverSideSign.verifyDigitalSignature("digitalSign.PDFDigitalSign", Configuration.getInstance().getParameter("CA_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_REVOKE_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_OCSP_SERVICE"), this.certificatePath.getText(), null, this.documentPath.getText(), false, new Date());
                if (res.trim().equals("")) {
                    this.resultLabel.setText(Configuration.getInstance().getMessage("PROPERLY_SIGNED"));
                } else {
                    this.resultLabel.setText("Result: " + res);
                }
            }
            catch (DocumentSignException ex) {
                this.resultLabel.setText(ex.getMessage());
                if (ex.getCause() == null) break block4;
                Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex.getCause());
            }
        }
    }

    private void VerifyXMLButtonActionPerformed(ActionEvent evt) {
        block4: {
            try {
                this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
                String res = this.serverSideSign.verifyDigitalSignature("digitalSign.XMLDigitalSign", Configuration.getInstance().getParameter("CA_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_REVOKE_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_OCSP_SERVICE"), this.certificatePath.getText(), null, this.documentPath.getText(), false, new Date());
                if (res.trim().equals("")) {
                    this.resultLabel.setText(Configuration.getInstance().getMessage("PROPERLY_SIGNED"));
                } else {
                    this.resultLabel.setText("Result: " + res);
                }
            }
            catch (DocumentSignException ex) {
                this.resultLabel.setText(ex.getMessage());
                if (ex.getCause() == null) break block4;
                Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex.getCause());
            }
        }
    }

    private void signButtonActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getParameter("DOCUMENT_DIRITORY"));
            fc.showOpenDialog(this.mainPanel);
            File selelectedFile = fc.getSelectedFile();
            if (selelectedFile != null) {
                this.signPath.setText(selelectedFile.getPath());
            }
        }
        catch (DocumentSignException ex) {
            this.resultLabel.setText(ex.getMessage());
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void VerifyPlainButtonActionPerformed(ActionEvent evt) {
        block4: {
            try {
                this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
                String res = this.serverSideSign.verifyDigitalSignature("digitalSign.PlainTextDigitalSign", Configuration.getInstance().getParameter("CA_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_REVOKE_CERTIFICATE_PATH"), Configuration.getInstance().getParameter("CA_OCSP_SERVICE"), this.certificatePath.getText(), this.documentPath.getText(), this.signPath.getText(), false, new Date());
                if (res.trim().equals("")) {
                    this.resultLabel.setText(Configuration.getInstance().getMessage("PROPERLY_SIGNED"));
                } else {
                    this.resultLabel.setText("Result: " + res);
                }
            }
            catch (DocumentSignException ex) {
                this.resultLabel.setText(ex.getMessage());
                if (ex.getCause() == null) break block4;
                Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex.getCause());
            }
        }
    }

    private void certificateButtonActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getParameter("CERTIFICATE_DIRITORY"));
            fc.showOpenDialog(this.mainPanel);
            File selelectedFile = fc.getSelectedFile();
            if (selelectedFile != null) {
                this.certificatePath.setText(selelectedFile.getPath());
            }
        }
        catch (DocumentSignException ex) {
            this.resultLabel.setText(ex.getMessage());
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void documentButtonActionPerformed(ActionEvent evt) {
        try {
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getParameter("DOCUMENT_DIRITORY"));
            fc.showOpenDialog(this.mainPanel);
            File selelectedFile = fc.getSelectedFile();
            if (selelectedFile != null) {
                this.documentPath.setText(selelectedFile.getPath());
            }
        }
        catch (DocumentSignException ex) {
            this.resultLabel.setText(ex.getMessage());
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void GetPlainButtonActionPerformed(ActionEvent evt) {
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        CetificateInformationBean res = this.serverSideSign.getSignerInformation("digitalSign.PlainTextDigitalSign", this.documentPath.getText());
        if (!res.getIssuerDN().trim().equals("") || !res.getSubjectDN().trim().equals("")) {
            this.resultLabel.setText(res.getIssuerDN() + "\n" + res.getSubjectDN());
        } else {
            this.resultLabel.setText("");
        }
    }

    private void GetXMLButtonActionPerformed(ActionEvent evt) {
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        CetificateInformationBean res = this.serverSideSign.getSignerInformation("digitalSign.XMLDigitalSign", this.documentPath.getText());
        if (!res.getIssuerDN().trim().equals("") || !res.getSubjectDN().trim().equals("")) {
            this.resultLabel.setText(res.getIssuerDN() + "\n" + res.getSubjectDN());
        } else {
            this.resultLabel.setText("");
        }
    }

    private void VerifyPdfButton1ActionPerformed(ActionEvent evt) {
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        CetificateInformationBean res = this.serverSideSign.getSignerInformation("digitalSign.PDFDigitalSign", this.documentPath.getText());
        if (!res.getIssuerDN().trim().equals("") || !res.getSubjectDN().trim().equals("")) {
            this.resultLabel.setText(res.getIssuerDN() + "\n" + res.getSubjectDN());
        } else {
            this.resultLabel.setText("");
        }
    }

    private void GetCetInfoActionPerformed(ActionEvent evt) {
        this.serverSideSign.setIncludeXMLSignerCertificate(this.cIncludeXMLSignerCertificate.isSelected());
        CetificateInformationBean res = this.serverSideSign.getSignerInformation(this.certificatePath.getText());
        if (!res.getIssuerDN().trim().equals("") || !res.getSubjectDN().trim().equals("")) {
            this.resultLabel.setText(res.getIssuerDN() + "\n" + res.getSubjectDN());
        } else {
            this.resultLabel.setText("");
        }
    }

    private void ExtractPDFTextActionPerformed(ActionEvent evt) {
        this.resultLabel.setText(PDFTools.extraerTextoPDF(this.documentPath.getText()));
    }

    private void Decode64ButtonActionPerformed(ActionEvent evt) {
        byte[] document = Codecs.base64Decode64(this.resultLabel.getText(), "UTF-8");
        try {
            Utils.writeFileFromByteArray(this.documentPath.getText(), document);
        }
        catch (DocumentSignException ex) {
            this.resultLabel.setText(ex.getMessage());
        }
    }

    private void jButtonListTokenCertActionPerformed(ActionEvent evt) {
        try {
            AbstractSignerKeyStoreStrategy signerStrategy = null;
            signerStrategy = this.certificatePath.getText() == null || this.certificatePath.getText().trim().equals("") ? new TokenSignerKeyStoreStrategy(this.certificatePwd.getText()) : new DefaultSignerKeyStoreStrategy(this.certificatePath.getText().trim(), this.certificatePwd.getText());
            this.resultLabel.setText("");
            for (KeyStoreCetificateBean bean : signerStrategy.listKeyStoreCetificateBean()) {
                this.resultLabel.setText(this.resultLabel.getText() + "\n" + bean);
            }
        }
        catch (DocumentSignException ex) {
            this.resultLabel.setText(ex.getMessage());
        }
    }

    private void documentPathActionPerformed(ActionEvent evt) {
    }

    private void cIncludeXMLSignerCertificateActionPerformed(ActionEvent evt) {
    }

    private void certificatePathActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] installedLookAndFeels = UIManager.getInstalledLookAndFeels();
            for (int iterator = 0; iterator < installedLookAndFeels.length; ++iterator) {
                UIManager.LookAndFeelInfo info = installedLookAndFeels[iterator];
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Test.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Test().setVisible(true);
            }
        });
    }
}

