/*
 * Decompiled with CFR 0.152.
 */
package verifier;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class TestOCSPClient {
    private static final String URL_OCSP_RESPONDER = "http://ancca.correo.com.uy/ancca/OCSP";
    private static final String URL_OCSP_RESPONDER_ABITAB = "http://www.id.com.uy/asf/servlet/OCSPServlet";

    private static byte[] streamToByteArray(InputStream is) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static X509Certificate getCertificate(String path) {
        if (path == null || path.trim().equals("")) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(fis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static void testOcsp(String urlOcspService, Certificate caCert, X509Certificate certificate) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateID id = new CertificateID(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1), new X509CertificateHolder(caCert.getEncoded()), certificate.getSerialNumber());
            OCSPReqBuilder ocspPeticionBuilder = new OCSPReqBuilder();
            ocspPeticionBuilder.addRequest(id);
            OCSPReq ocspPeticion = ocspPeticionBuilder.build();
            URL url = new URL(urlOcspService);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(ocspPeticion.getEncoded());
            dataOut.flush();
            dataOut.close();
            InputStream in = (InputStream)con.getContent();
            byte[] bytes = TestOCSPClient.streamToByteArray(in);
            OCSPResp ocspRespuesta = new OCSPResp(bytes);
            int estado = ocspRespuesta.getStatus();
            if (0 == estado) {
                Object responseObject = ocspRespuesta.getResponseObject();
                BasicOCSPResp basicOCSPResp = (BasicOCSPResp)responseObject;
                SingleResp[] responses = basicOCSPResp.getResponses();
                if (responses.length == 1) {
                    SingleResp resp = responses[0];
                    CertificateStatus status = resp.getCertStatus();
                    if (status == CertificateStatus.GOOD) {
                        System.out.println("Certificado OK");
                    } else if (status instanceof RevokedStatus) {
                        System.out.println("Certificado REVOCADO");
                    } else {
                        System.out.println("Certificado con estado desconocido, clase de la respuesta = " + status.getClass().getName());
                    }
                } else {
                    System.out.println("No tengo respuesta");
                }
            } else {
                System.out.println("ERROR: " + estado);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String responder = args[0].toUpperCase().contains("ABITAB") ? URL_OCSP_RESPONDER_ABITAB : URL_OCSP_RESPONDER;
        TestOCSPClient.testOcsp(responder, TestOCSPClient.getCertificate(args[1]), TestOCSPClient.getCertificate(args[2]));
    }
}

