/*
 * Decompiled with CFR 0.152.
 */
package verifier;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11;
import verifier.TestVerPKCS11Config;

public class TokenTest {
    public static void main(String[] args) throws Exception {
        TestVerPKCS11Config cfg = new TestVerPKCS11Config(args[0], args[1]);
        final String password = args[2];
        SunPKCS11 token = null;
        String lineSep = System.getProperty("line.separator");
        String library = cfg.getLibrary();
        if (library != null && !library.trim().equals("")) {
            File file = new File(cfg.getLibrary());
            if (file.exists() && file.isFile()) {
                System.out.println("Checking PKCS11Config " + cfg.getName() + "=" + cfg.getLibrary());
                try {
                    long[] slots;
                    PKCS11 p11 = PKCS11.getInstance(library.trim(), "C_GetFunctionList", null, false);
                    for (long slot : slots = p11.C_GetSlotList(true)) {
                        StringBuilder strConf = new StringBuilder();
                        strConf.append("name = ");
                        strConf.append(cfg.getName());
                        strConf.append(lineSep);
                        strConf.append("library = ");
                        strConf.append(library.trim());
                        strConf.append(lineSep);
                        strConf.append("slot = ");
                        strConf.append(slot);
                        token = new SunPKCS11((InputStream)new ByteArrayInputStream(strConf.toString().getBytes()));
                        try {
                            token.logout();
                        }
                        catch (LoginException ex) {
                            System.out.println("No me interesa si falla el logout por las dudas.");
                            ex.printStackTrace();
                        }
                        token.setCallbackHandler(new CallbackHandler(){

                            @Override
                            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                for (int i = 0; i < callbacks.length; ++i) {
                                    if (!(callbacks[i] instanceof PasswordCallback)) continue;
                                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                                    pc.setPassword(password.toCharArray());
                                }
                            }
                        });
                        Security.addProvider(token);
                        try {
                            KeyStore keyStore = KeyStore.getInstance("PKCS11", token);
                            keyStore.load(null, null);
                        }
                        catch (Exception ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("Voy a imprimir error de slot, no necesariamente es malo.");
                    ex.printStackTrace();
                }
            } else {
                System.out.println("PKCS11Config " + cfg.getName() + "=" + cfg.getLibrary() + " not found.");
            }
        }
        if (token != null) {
            System.out.println("OK");
        } else {
            System.out.println("ERROR");
        }
    }
}

