/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import es.mityc.firmaJava.libreria.utilidades.NTo1Link;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilidadCertificados {
    private static final Log logger = LogFactory.getLog(UtilidadCertificados.class);
    private static final String OID_OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    private static final String OID_TS_SIGNING = "1.3.6.1.5.5.7.3.8";

    public static ArrayList<CertPath> getCertPaths(Iterable<X509Certificate> certificates) {
        ArrayList<ArrayList<X509Certificate>> list = UtilidadCertificados.getCertPathsArray(certificates);
        ArrayList<CertPath> certPaths = new ArrayList<CertPath>();
        Iterator<ArrayList<X509Certificate>> itArrays = list.iterator();
        while (itArrays.hasNext()) {
            CertPath cp = UtilidadCertificados.convertCertPath(itArrays.next());
            if (cp == null) continue;
            certPaths.add(cp);
        }
        return certPaths;
    }

    public static ArrayList<ArrayList<X509Certificate>> getCertPathsArray(Iterable<X509Certificate> certificates) {
        ArrayList<ArrayList<X509Certificate>> certPaths = new ArrayList<ArrayList<X509Certificate>>();
        if (certificates != null) {
            ArrayList<NTo1Link<X509Certificate>> list = new ArrayList<NTo1Link<X509Certificate>>();
            Iterator<X509Certificate> itCerts = certificates.iterator();
            while (itCerts.hasNext()) {
                NTo1Link<X509Certificate> nodo = new NTo1Link<X509Certificate>(itCerts.next());
                if (list.contains(nodo)) continue;
                list.add(nodo);
            }
            for (int i = 0; i < list.size(); ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    UtilidadCertificados.linkCerts((NTo1Link)list.get(i), (NTo1Link)list.get(j));
                }
            }
            for (NTo1Link nTo1Link : list) {
                ArrayList<X509Certificate> cp;
                if (nTo1Link.getNumPrevs() != 0 || (cp = UtilidadCertificados.convertCertPathArray(nTo1Link)) == null) continue;
                certPaths.add(cp);
            }
        }
        return certPaths;
    }

    public static ArrayList<ArrayList<X509Certificate>> filterCertPathsArrays(ArrayList<ArrayList<X509Certificate>> list, Filter filter) {
        ArrayList<ArrayList<X509Certificate>> result = new ArrayList<ArrayList<X509Certificate>>();
        for (ArrayList<X509Certificate> certs : list) {
            if (certs == null || certs.size() <= 0) continue;
            if (Filter.OCSP_SIGNER.equals((Object)filter)) {
                if (!UtilidadCertificados.isOCSPSigning(certs.get(0))) continue;
                result.add(certs);
                continue;
            }
            if (Filter.TS_SIGNER.equals((Object)filter)) {
                if (!UtilidadCertificados.isTSSigning(certs.get(0))) continue;
                result.add(certs);
                continue;
            }
            if (Filter.CRL_SIGNER.equals((Object)filter)) {
                if (!UtilidadCertificados.isCRLSigning(certs.get(0))) continue;
                result.add(certs);
                continue;
            }
            if (!Filter.SIGN_SIGNER.equals((Object)filter)) continue;
            result.add(certs);
        }
        return result;
    }

    private static boolean isOCSPSigning(X509Certificate cert) {
        try {
            List<String> list = cert.getExtendedKeyUsage();
            if (list != null) {
                Iterator<String> it = list.iterator();
                while (it.hasNext()) {
                    if (!OID_OCSP_SIGNING.equals(it.next())) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isTSSigning(X509Certificate cert) {
        try {
            List<String> list = cert.getExtendedKeyUsage();
            if (list != null) {
                Iterator<String> it = list.iterator();
                while (it.hasNext()) {
                    if (!OID_TS_SIGNING.equals(it.next())) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isCRLSigning(X509Certificate cert) {
        boolean[] usage = cert.getKeyUsage();
        return cert != null && usage[6];
    }

    private static void linkCerts(NTo1Link<X509Certificate> nodo1, NTo1Link<X509Certificate> nodo2) {
        if (nodo1.getData().getIssuerX500Principal().equals(nodo2.getData().getSubjectX500Principal())) {
            try {
                nodo1.getData().verify(nodo2.getData().getPublicKey());
            }
            catch (InvalidKeyException ex) {
                return;
            }
            catch (CertificateException ex) {
                return;
            }
            catch (NoSuchAlgorithmException ex) {
                return;
            }
            catch (NoSuchProviderException ex) {
                return;
            }
            catch (SignatureException ex) {
                return;
            }
            nodo1.setNext(nodo2);
            nodo2.addPrev(nodo1);
        } else if (nodo2.getData().getIssuerX500Principal().equals(nodo1.getData().getSubjectX500Principal())) {
            try {
                nodo2.getData().verify(nodo1.getData().getPublicKey());
            }
            catch (InvalidKeyException ex) {
                return;
            }
            catch (CertificateException ex) {
                return;
            }
            catch (NoSuchAlgorithmException ex) {
                return;
            }
            catch (NoSuchProviderException ex) {
                return;
            }
            catch (SignatureException ex) {
                return;
            }
            nodo2.setNext(nodo1);
            nodo1.addPrev(nodo2);
        }
    }

    public static CertPath convertCertPath(ArrayList<X509Certificate> certs) {
        CertPath cp = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cp = cf.generateCertPath(certs);
        }
        catch (CertificateException ex) {
            logger.error((Object)"Error al intentar generar CertPaths", (Throwable)ex);
        }
        return cp;
    }

    private static ArrayList<X509Certificate> convertCertPathArray(NTo1Link<X509Certificate> nodo) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        Iterator<NTo1Link<X509Certificate>> itNodo = nodo.iterator();
        while (itNodo.hasNext()) {
            certs.add(itNodo.next().getData());
        }
        return certs;
    }

    public static String getCN(X500Principal dname) {
        Object elemento;
        int indexCN;
        String retorno = null;
        X509Principal nombre = new X509Principal(dname.getName());
        Vector commonNameOIDs = nombre.getOIDs();
        Vector commonName = nombre.getValues();
        int longitudValues = commonName.size();
        if (longitudValues != 0 && (indexCN = commonNameOIDs.indexOf(X509Name.CN)) != -1 && (elemento = commonName.get(indexCN)) instanceof String) {
            retorno = (String)elemento;
        }
        return retorno;
    }

    public static boolean isSameName(X500Principal prin1, X500Principal prin2) {
        X509Name name1 = new X509Name(prin1.getName());
        X509Name name2 = new X509Name(prin2.getName());
        return name1.equals((Object)name2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Filter {
        SIGN_SIGNER,
        CRL_SIGNER,
        OCSP_SIGNER,
        TS_SIGNER;

    }
}

