/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UtilidadFechas {
    private static final String FORMATO_FECHA_CON_MILIS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String FORMATO_FECHA_SIN_MILIS = "yyyy-MM-dd'T'HH:mm:ssZ";

    public static Date parseaFechaXML(String fecha) {
        String res = new String(fecha);
        int t = res.indexOf("T");
        if (t == -1) {
            return null;
        }
        if ((t = res.indexOf(":", t)) == -1) {
            return null;
        }
        if ((t = res.indexOf(":", t + 1)) == -1) {
            return null;
        }
        String formato = res.indexOf(".", t) > -1 ? FORMATO_FECHA_CON_MILIS : FORMATO_FECHA_SIN_MILIS;
        if (res.indexOf(":", t + 1) == -1 && !res.endsWith("Z")) {
            res = res.concat("Z");
        }
        res = res.endsWith("Z") ? res.replace("Z", "+0000") : res.substring(0, res.length() - 3).concat(res.substring(res.length() - 2));
        SimpleDateFormat sdf = new SimpleDateFormat(formato);
        try {
            Date resultado = sdf.parse(res);
            return resultado;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static String formatFechaXML(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMATO_FECHA_SIN_MILIS);
        String resultado = sdf.format(fecha);
        resultado = resultado.substring(0, resultado.length() - 2).concat(":").concat(resultado.substring(resultado.length() - 2));
        return resultado;
    }
}

