/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilidadXadesA {
    private static Log log = LogFactory.getLog(UtilidadXadesA.class);

    public static byte[] obtenerListadoXadesA(String esquemaURI, XMLSignature xmlSig, Element selloA) throws BadFormedSignatureException, FirmaXMLError, XMLSecurityException, IOException {
        ArrayList<Element> referenceNodes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SignedInfo si = xmlSig.getSignedInfo();
        Element firma = xmlSig.getElement();
        CanonicalizationEnum cannon = null;
        cannon = CanonicalizationEnum.getCanonicalization(si.getCanonicalizationMethodURI());
        if (cannon == null || CanonicalizationEnum.UNKNOWN.equals((Object)cannon)) {
            log.warn((Object)("No se reconoce el algoritmo de canonicalizaci\u00f3n " + si.getCanonicalizationMethodURI() + ". Se toma el valor por defecto."));
            cannon = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        }
        if ((referenceNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Reference"))).size() == 0) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "Reference" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + referenceNodes.size());
        }
        Reference referenceNode = null;
        for (int i = 0; i < si.getLength(); ++i) {
            Element nodo;
            referenceNode = si.item(i);
            if (referenceNode == null) continue;
            Element reference = referenceNodes.get(i);
            String referenceUri = reference.getAttribute("URI");
            if (referenceUri != "" && !referenceUri.startsWith("#")) {
                File firmado = new File(referenceUri);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(firmado);
                }
                catch (FileNotFoundException e1) {
                    throw new IOException(I18n.getResource("libreriaxades.validarfirmaxml.error58"));
                }
                byte[] entrada = null;
                fis.read(entrada);
                baos.write(entrada);
                continue;
            }
            if (referenceUri == "" || (nodo = UtilidadTratarNodo.getElementById(xmlSig.getDocument(), referenceUri.substring(1))) == null) continue;
            baos.write(UtilidadTratarNodo.obtenerByte(nodo, UtilidadXadesA.obtenerCanonicalization(nodo, cannon)));
        }
        ArrayList<Element> signedInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        if (signedInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignedInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signedInfoNodes.size());
        }
        baos.write(si.getCanonicalizedOctetStream());
        Element signatureValueNode = null;
        ArrayList<Element> signatureValueNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        if (signatureValueNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signatureValueNodes.size());
        }
        signatureValueNode = signatureValueNodes.get(0);
        baos.write(UtilidadTratarNodo.obtenerByte(signatureValueNode, UtilidadXadesA.obtenerCanonicalization(signatureValueNode, cannon)));
        Element keyInfoNode = null;
        ArrayList<Element> keyInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (keyInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "KeyInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + keyInfoNodes.size());
        }
        keyInfoNode = keyInfoNodes.get(0);
        baos.write(UtilidadTratarNodo.obtenerByte(keyInfoNode, UtilidadXadesA.obtenerCanonicalization(keyInfoNode, cannon)));
        ArrayList<Element> nodosSigTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignatureTimeStamp"));
        for (int i = 0; i < nodosSigTimeStamp.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(nodosSigTimeStamp.get(i), UtilidadXadesA.obtenerCanonicalization(nodosSigTimeStamp.get(i), cannon)));
        }
        ArrayList<Element> counterSignatureNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CounterSignature"));
        for (int i = 0; i < counterSignatureNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(counterSignatureNodes.get(i), UtilidadXadesA.obtenerCanonicalization(counterSignatureNodes.get(i), cannon)));
        }
        ArrayList<Element> completeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
        if (completeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeCertificateRefsNodes.size());
        }
        for (int i = 0; i < completeCertificateRefsNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(completeCertificateRefsNodes.get(i), UtilidadXadesA.obtenerCanonicalization(completeCertificateRefsNodes.get(i), cannon)));
        }
        ArrayList<Element> completeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"));
        if (completeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeRevocationRefsNodes.size());
        }
        for (int i = 0; i < completeRevocationRefsNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(completeRevocationRefsNodes.get(i), UtilidadXadesA.obtenerCanonicalization(completeRevocationRefsNodes.get(i), cannon)));
        }
        ArrayList<Element> attributeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeCertificateRefs"));
        if (attributeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeCertificateRefsNodes.size());
        }
        for (int i = 0; i < attributeCertificateRefsNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(attributeCertificateRefsNodes.get(i), UtilidadXadesA.obtenerCanonicalization(attributeCertificateRefsNodes.get(i), cannon)));
        }
        ArrayList<Element> attributeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeRevocationRefs"));
        if (attributeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeRevocationRefsNodes.size());
        }
        for (int i = 0; i < attributeRevocationRefsNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(attributeRevocationRefsNodes.get(i), UtilidadXadesA.obtenerCanonicalization(attributeRevocationRefsNodes.get(i), cannon)));
        }
        ArrayList<Element> sigAndRefsTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SigAndRefsTimeStamp"));
        if (sigAndRefsTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + sigAndRefsTimeStampNodes.size());
        }
        for (int i = 0; i < sigAndRefsTimeStampNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(sigAndRefsTimeStampNodes.get(i), UtilidadXadesA.obtenerCanonicalization(sigAndRefsTimeStampNodes.get(i), cannon)));
        }
        ArrayList<Element> refsOnlyTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RefsOnlyTimeStamp"));
        if (refsOnlyTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + refsOnlyTimeStampNodes.size());
        }
        for (int i = 0; i < refsOnlyTimeStampNodes.size(); ++i) {
            baos.write(UtilidadTratarNodo.obtenerByte(refsOnlyTimeStampNodes.get(i), UtilidadXadesA.obtenerCanonicalization(refsOnlyTimeStampNodes.get(i), cannon)));
        }
        ArrayList<Element> certificateValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        if (certificateValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + certificateValuesNodes.size());
        }
        baos.write(UtilidadTratarNodo.obtenerByte(certificateValuesNodes.get(0), UtilidadXadesA.obtenerCanonicalization(certificateValuesNodes.get(0), cannon)));
        ArrayList<Element> revocationValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        if (revocationValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + revocationValuesNodes.size());
        }
        baos.write(UtilidadTratarNodo.obtenerByte(revocationValuesNodes.get(0), UtilidadXadesA.obtenerCanonicalization(revocationValuesNodes.get(0), cannon)));
        if (attributeCertificateRefsNodes.size() > 0 && certificateValuesNodes.get(0).getChildNodes().getLength() < completeCertificateRefsNodes.get(0).getChildNodes().getLength()) {
            ArrayList<Element> AttrValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttrAuthoritiesCertValues"));
            if (AttrValuesNodes.size() != 1) {
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + AttrValuesNodes.size());
            }
            baos.write(UtilidadTratarNodo.obtenerByte(AttrValuesNodes.get(0), UtilidadXadesA.obtenerCanonicalization(AttrValuesNodes.get(0), cannon)));
        }
        if (attributeCertificateRefsNodes.size() > 0 && revocationValuesNodes.get(0).getChildNodes().getLength() < completeRevocationRefsNodes.get(0).getChildNodes().getLength()) {
            ArrayList<Element> AttributeRevocationValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeRevocationValues"));
            if (AttributeRevocationValuesNodes.size() != 1) {
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + AttributeRevocationValuesNodes.size());
            }
            baos.write(UtilidadTratarNodo.obtenerByte(AttributeRevocationValuesNodes.get(0), UtilidadXadesA.obtenerCanonicalization(AttributeRevocationValuesNodes.get(0), cannon)));
        }
        ArrayList<Element> archiveTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "ArchiveTimeStamp"));
        for (int i = 0; i < archiveTimeStampNodes.size(); ++i) {
            Element selloANode = archiveTimeStampNodes.get(i);
            if (selloA != null && selloA.equals(selloANode)) break;
            baos.write(UtilidadTratarNodo.obtenerByte(selloANode, UtilidadXadesA.obtenerCanonicalization(archiveTimeStampNodes.get(i), cannon)));
        }
        ObjectContainer object = null;
        Element reference = null;
        String objectId = null;
        String referenceUri = null;
        for (int i = 0; i < xmlSig.getObjectLength(); ++i) {
            object = xmlSig.getObjectItem(i);
            objectId = object.getId();
            boolean incluir = true;
            for (int j = 0; j < referenceNodes.size(); ++j) {
                reference = referenceNodes.get(j);
                referenceUri = reference.getAttribute("URI");
                if (referenceUri == null || !referenceUri.substring(1).equals(objectId)) continue;
                incluir = false;
                break;
            }
            ArrayList<Element> quialifyingProp = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(esquemaURI, "QualifyingProperties"));
            for (int j = 0; j < quialifyingProp.size() && incluir; ++j) {
                if (!quialifyingProp.get(j).equals(object.getElement().getFirstChild())) continue;
                incluir = false;
            }
            if (!incluir) continue;
            baos.write(UtilidadTratarNodo.obtenerByte(object.getElement(), UtilidadXadesA.obtenerCanonicalization(object.getElement(), cannon)));
        }
        return baos.toByteArray();
    }

    private static CanonicalizationEnum obtenerCanonicalization(Element nodo, CanonicalizationEnum porDefecto) throws FirmaXMLError {
        Element nodoCanonicalizationMethod;
        String method;
        NodeList nodosCanonicalizationMethod = nodo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
        CanonicalizationEnum canonicalization = porDefecto;
        if (numNodosCanonicalization > 0 && (canonicalization = CanonicalizationEnum.getCanonicalization(method = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
            throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method);
        }
        return canonicalization;
    }

    public static ArrayList<String> obtenerListadoIdsElementosXadesA(String esquemaURI, XMLSignature xmlSig, Element selloA) throws BadFormedSignatureException, FirmaXMLError, XMLSecurityException {
        ArrayList<String> input = new ArrayList<String>();
        SignedInfo si = xmlSig.getSignedInfo();
        Element firma = xmlSig.getElement();
        ArrayList<Element> referenceNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Reference"));
        if (referenceNodes.size() == 0) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "Reference" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + referenceNodes.size());
        }
        Reference referenceNode = null;
        for (int i = 0; i < referenceNodes.size(); ++i) {
            referenceNode = si.item(i);
            String idRef = referenceNode.getElement().getAttribute("URI");
            if (idRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la URI del nodo Reference");
            }
            input.add(idRef);
        }
        Element signedInfoNode = null;
        ArrayList<Element> signedInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignedInfo"));
        if (signedInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignedInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signedInfoNodes.size());
        }
        signedInfoNode = signedInfoNodes.get(0);
        String idSigInfo = signedInfoNode.getAttribute("Id");
        if (idSigInfo == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SignedInfo");
        }
        input.add("#" + idSigInfo);
        Element signatureValueNode = null;
        ArrayList<Element> signatureValueNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
        if (signatureValueNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + signatureValueNodes.size());
        }
        signatureValueNode = signatureValueNodes.get(0);
        String idSigValue = signatureValueNode.getAttribute("Id");
        if (idSigValue == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SignatureValue");
        }
        input.add("#" + idSigValue);
        Element keyInfoNode = null;
        ArrayList<Element> keyInfoNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"));
        if (keyInfoNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "KeyInfo" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + keyInfoNodes.size());
        }
        keyInfoNode = keyInfoNodes.get(0);
        String idKeyInfo = keyInfoNode.getAttribute("Id");
        if (idKeyInfo == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo KeyInfo");
        }
        input.add("#" + idKeyInfo);
        ArrayList<Element> nodosSigTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignatureTimeStamp"));
        if (nodosSigTimeStamp.size() < 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error21"));
        }
        for (int i = 0; i < nodosSigTimeStamp.size(); ++i) {
            String idSigTimeStamp = nodosSigTimeStamp.get(i).getAttribute("Id");
            if (idSigTimeStamp == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID de un sello de tiempo XAdES-T");
            }
            input.add("#" + idSigTimeStamp);
        }
        ArrayList<Element> counterSignatureNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CounterSignature"));
        for (int i = 0; i < counterSignatureNodes.size(); ++i) {
            String idCounterSig = counterSignatureNodes.get(i).getAttribute("Id");
            if (idCounterSig == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID de una contrafirma");
            }
            input.add("#" + idCounterSig);
        }
        ArrayList<Element> completeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
        if (completeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeCertificateRefsNodes.size());
        }
        for (int i = 0; i < completeCertificateRefsNodes.size(); ++i) {
            String idCompCertRef = completeCertificateRefsNodes.get(i).getAttribute("Id");
            if (idCompCertRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CompleteCertificateRefs");
            }
            input.add("#" + idCompCertRef);
        }
        ArrayList<Element> completeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"));
        if (completeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + completeRevocationRefsNodes.size());
        }
        for (int i = 0; i < completeRevocationRefsNodes.size(); ++i) {
            String idCompRevRef = completeRevocationRefsNodes.get(i).getAttribute("Id");
            if (idCompRevRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CompleteRevocationRefs");
            }
            input.add("#" + idCompRevRef);
        }
        ArrayList<Element> attributeCertificateRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeCertificateRefs"));
        if (attributeCertificateRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeCertificateRefsNodes.size());
        }
        for (int i = 0; i < attributeCertificateRefsNodes.size(); ++i) {
            String idAttrCertRef = attributeCertificateRefsNodes.get(i).getAttribute("Id");
            if (idAttrCertRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo AttributeCertificateRefs");
            }
            input.add("#" + idAttrCertRef);
        }
        ArrayList<Element> attributeRevocationRefsNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "AttributeRevocationRefs"));
        if (attributeRevocationRefsNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + attributeRevocationRefsNodes.size());
        }
        for (int i = 0; i < attributeRevocationRefsNodes.size(); ++i) {
            String idAttrRevRef = attributeRevocationRefsNodes.get(i).getAttribute("Id");
            if (idAttrRevRef == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo AttributeRevocationRefs");
            }
            input.add("#" + idAttrRevRef);
        }
        ArrayList<Element> sigAndRefsTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SigAndRefsTimeStamp"));
        if (sigAndRefsTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + sigAndRefsTimeStampNodes.size());
        }
        for (int i = 0; i < sigAndRefsTimeStampNodes.size(); ++i) {
            String idSigAndRefs = sigAndRefsTimeStampNodes.get(i).getAttribute("Id");
            if (idSigAndRefs == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo SigAndRefsTimeStamp");
            }
            input.add("#" + idSigAndRefs);
        }
        ArrayList<Element> refsOnlyTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RefsOnlyTimeStamp"));
        if (refsOnlyTimeStampNodes.size() > 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "AttributeRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + refsOnlyTimeStampNodes.size());
        }
        for (int i = 0; i < refsOnlyTimeStampNodes.size(); ++i) {
            String refsOnlyTimeStamp = refsOnlyTimeStampNodes.get(i).getAttribute("Id");
            if (refsOnlyTimeStamp == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo RefsOnlyTimeStamp");
            }
            input.add("#" + refsOnlyTimeStamp);
        }
        ArrayList<Element> certificateValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        if (certificateValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CertificateValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + certificateValuesNodes.size());
        }
        String certValueId = certificateValuesNodes.get(0).getAttribute("Id");
        if (certValueId == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo CertificateValues");
        }
        input.add("#" + certValueId);
        ArrayList<Element> revocationValuesNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        if (revocationValuesNodes.size() != 1) {
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "RevocationValues" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + revocationValuesNodes.size());
        }
        String revValuesId = revocationValuesNodes.get(0).getAttribute("Id");
        if (revValuesId == null) {
            throw new BadFormedSignatureException("No se puede recuperar la ID del nodo RevocationValues");
        }
        input.add("#" + revValuesId);
        ArrayList<Element> archiveTimeStampNodes = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "ArchiveTimeStamp"));
        for (int i = 0; i < archiveTimeStampNodes.size(); ++i) {
            Element selloANode = archiveTimeStampNodes.get(i);
            if (selloA != null && selloA.equals(selloANode)) break;
            String aTimeStampId = selloANode.getAttribute("Id");
            if (aTimeStampId == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo ArchiveTimeStamp");
            }
            input.add("#" + aTimeStampId);
        }
        ObjectContainer object = null;
        Element reference = null;
        String objectId = null;
        String referenceUri = null;
        for (int i = 0; i < xmlSig.getObjectLength(); ++i) {
            object = xmlSig.getObjectItem(i);
            objectId = object.getId();
            boolean incluir = true;
            for (int j = 0; j < referenceNodes.size(); ++j) {
                reference = referenceNodes.get(j);
                referenceUri = reference.getAttribute("URI");
                if (referenceUri == null || !referenceUri.substring(1).equals(objectId)) continue;
                incluir = false;
                break;
            }
            ArrayList<Element> quialifyingProp = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(esquemaURI, "QualifyingProperties"));
            for (int j = 0; j < quialifyingProp.size() && incluir; ++j) {
                if (!quialifyingProp.get(j).equals(object.getElement().getFirstChild())) continue;
                incluir = false;
            }
            if (!incluir) continue;
            String objectNodeId = object.getElement().getAttribute("Id");
            if (objectNodeId == null) {
                throw new BadFormedSignatureException("No se puede recuperar la ID del nodo Object");
            }
            input.add("#" + objectNodeId);
        }
        return input;
    }

    public static ArrayList<String> casoDistribuido() {
        ArrayList<String> input = new ArrayList<String>();
        return input;
    }
}

