/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLRef;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLRefsType
extends AbstractXADESElement {
    private ArrayList<CRLRef> crlRefs;

    public CRLRefsType(XAdESSchemas schema) {
        super(schema);
    }

    public CRLRefsType(XAdESSchemas schema, ArrayList<CRLRef> crlRefs) {
        super(schema);
        this.crlRefs = crlRefs;
    }

    public void addCRLRef(CRLRef crlRef) {
        if (this.crlRefs == null) {
            this.crlRefs = new ArrayList();
        }
        this.crlRefs.add(crlRef);
    }

    public ArrayList<CRLRef> getCRLRefs() {
        return this.crlRefs;
    }

    public void setCertificates(ArrayList<CRLRef> crlRefs) {
        this.crlRefs = crlRefs;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CRLRefsType) {
            CRLRefsType cvt = (CRLRefsType)obj;
            ArrayList<CRLRef> comp = cvt.crlRefs;
            if ((this.crlRefs == null || this.crlRefs.isEmpty()) && (comp == null || comp.isEmpty())) {
                return true;
            }
            if (this.crlRefs != null && comp != null && this.crlRefs.size() == comp.size()) {
                Iterator<CRLRef> itThis = this.crlRefs.iterator();
                Iterator<CRLRef> itComp = comp.iterator();
                while (itThis.hasNext()) {
                    if (itThis.next().equals(itComp.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        NodeList nodos = element.getChildNodes();
        ArrayList<CRLRef> temp = new ArrayList<CRLRef>(nodos.getLength());
        for (int i = 0; i < nodos.getLength(); ++i) {
            Node nodo = nodos.item(i);
            if (nodo.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Hijo de CRLRefsType no es un elemento");
            }
            CRLRef crlRef = new CRLRef(this.schema);
            crlRef.load((Element)nodo);
            temp.add(crlRef);
        }
        if (temp.size() == 0) {
            throw new InvalidInfoNodeException("CRLRefsType debe tener al menos un hijo");
        }
        this.crlRefs = temp;
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.crlRefs == null || this.crlRefs.size() == 0) {
            throw new InvalidInfoNodeException("CRLRefsType debe tener al menos un hijo");
        }
        Iterator<CRLRef> it = this.crlRefs.iterator();
        while (it.hasNext()) {
            element.appendChild(it.next().createElement(element.getOwnerDocument(), this.namespaceXDsig, this.namespaceXAdES));
        }
    }

    @Override
    public void addContent(Element element, String namespaceXAdES, String namespaceXDsig) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES, namespaceXDsig);
    }
}

