/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertDigest;
import es.mityc.firmaJava.libreria.xades.elementos.xades.IssuerSerial;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertIDType
extends AbstractXADESElement {
    private CertDigest digest;
    private IssuerSerial issuerSerial;

    public CertIDType(XAdESSchemas schema) {
        super(schema);
    }

    public CertIDType(XAdESSchemas schema, CertDigest digest, IssuerSerial issuerSerial) {
        super(schema);
        this.digest = digest;
        this.issuerSerial = issuerSerial;
    }

    public CertIDType(XAdESSchemas schema, String digestMethod, String digestValue, String issuerName, BigInteger serialNumber) {
        super(schema);
        this.digest = new CertDigest(schema, digestMethod, digestValue);
        this.issuerSerial = new IssuerSerial(schema, issuerName, serialNumber);
    }

    public CertIDType(XAdESSchemas schema, String digestMethod, byte[] digestValue, String issuerName, BigInteger serialNumber) throws InvalidInfoNodeException {
        super(schema);
        this.digest = new CertDigest(schema, digestMethod, digestValue);
        this.issuerSerial = new IssuerSerial(schema, issuerName, serialNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CertIDType) {
            CertIDType cit = (CertIDType)obj;
            if (this.digest == null || this.issuerSerial == null) {
                return false;
            }
            if (!this.digest.equals(cit.digest)) {
                return false;
            }
            if (this.issuerSerial.equals(cit.issuerSerial)) {
                return true;
            }
        }
        return false;
    }

    public void load(Element element) throws InvalidInfoNodeException {
        Node node = CertIDType.getFirstNonvoidNode(element);
        CertDigest digest = new CertDigest(this.getSchema());
        if (!digest.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo CertDigest en CertIDType");
        }
        digest.load((Element)node);
        node = CertIDType.getNextNonvoidNode(node);
        IssuerSerial issuerSerial = new IssuerSerial(this.getSchema());
        if (!issuerSerial.isThisNode(node)) {
            throw new InvalidInfoNodeException("Se esperaba nodo IssuerSerial en CertIDType");
        }
        issuerSerial.load((Element)node);
        this.digest = digest;
        this.issuerSerial = issuerSerial;
    }

    public void setDigest(CertDigest digest) {
        this.digest = digest;
    }

    public void setDigest(String digestMethod, String digestValue) {
        this.digest = new CertDigest(this.schema, digestMethod, digestValue);
    }

    public void setDigest(String digestMethod, byte[] digestValue) throws InvalidInfoNodeException {
        this.digest = new CertDigest(this.schema, digestMethod, digestValue);
    }

    public CertDigest getCertDigest() {
        return this.digest;
    }

    public void setIssuerSerial(String issuerName, BigInteger serialNumber) {
        this.issuerSerial = new IssuerSerial(this.schema, issuerName, serialNumber);
    }

    public void setIssuerSerial(IssuerSerial issuerSerial) {
        this.issuerSerial = issuerSerial;
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }
}

