/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.QualifierEnum;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class IdentifierType
extends AbstractXADESElement {
    private URI uri;
    private QualifierEnum qualifier = null;

    public IdentifierType(XAdESSchemas schema) {
        super(schema);
    }

    public IdentifierType(XAdESSchemas schema, URI uri, QualifierEnum qualifier) {
        super(schema);
        this.uri = uri;
        this.qualifier = qualifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IdentifierType) {
            IdentifierType it = (IdentifierType)obj;
            if (this.uri.equals(it.uri)) {
                return true;
            }
        }
        return false;
    }

    public void load(Element element) throws InvalidInfoNodeException {
        Node node = IdentifierType.getFirstNonvoidNode(element);
        if (node.getNodeType() != 3) {
            throw new InvalidInfoNodeException("Nodo IdentifierType no contiene CDATA como primer valor");
        }
        this.qualifier = QualifierEnum.getQualifierEnum(element.getAttribute("Qualifier"));
        String data = node.getNodeValue();
        if (data == null) {
            throw new InvalidInfoNodeException("No hay URI en nodo IdentifierType");
        }
        try {
            data = data.replace(" ", "%20");
            this.uri = new URI(data);
        }
        catch (URISyntaxException ex) {
            throw new InvalidInfoNodeException("URI malformada en nodo IdentifierType", ex);
        }
    }

    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.uri == null) {
            throw new InvalidInfoNodeException("No hay informaci\u00f3n de URI para nodo IdentifierType");
        }
        element.setTextContent(this.uri.toString());
        if (this.qualifier != null) {
            element.setAttributeNS(null, "Qualifier", this.qualifier.toString());
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public QualifierEnum getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(QualifierEnum qualifier) {
        this.qualifier = qualifier;
    }
}

