/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.xades.policy;

import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PoliciesTool {
    public static void insertPolicyNode(Element signNode, String namespaceDS, String namespaceXAdES, XAdESSchemas schema, SignaturePolicyIdentifier spi) throws PolicyException {
        Node node;
        Element policy;
        NodeList list = signNode.getElementsByTagNameNS(schema.getSchemaUri(), "SignedSignatureProperties");
        if (list.getLength() != 1 || list.item(0).getNodeType() != 1) {
            throw new PolicyException("No hay nodo SignedSignatureProperties claro al que aplicar la pol\u00edtica");
        }
        try {
            policy = spi.createElement(signNode.getOwnerDocument(), namespaceDS, namespaceXAdES);
        }
        catch (InvalidInfoNodeException ex) {
            throw new PolicyException("Error en la creaci\u00f3n de la pol\u00edtica:" + ex.getMessage(), ex);
        }
        NombreNodo SIGNING_TIME = new NombreNodo(schema.getSchemaUri(), "SigningTime");
        NombreNodo SIGNING_CERTIFICATE = new NombreNodo(schema.getSchemaUri(), "SigningCertificate");
        NombreNodo SIGNATURE_POLICY_IDENTIFIER = new NombreNodo(schema.getSchemaUri(), "SignaturePolicyIdentifier");
        Element signedSignatureProperties = (Element)list.item(0);
        for (node = signedSignatureProperties.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) {
                throw new PolicyException("Error en el formato de SignedSignatureProperties");
            }
            NombreNodo nombre = new NombreNodo(node.getNamespaceURI(), node.getLocalName());
            if (!nombre.equals(SIGNING_TIME) && !nombre.equals(SIGNING_CERTIFICATE)) break;
        }
        if (node != null && SIGNATURE_POLICY_IDENTIFIER.equals(new NombreNodo(node.getNamespaceURI(), node.getLocalName()))) {
            signedSignatureProperties.replaceChild(policy, node);
        } else {
            signedSignatureProperties.insertBefore(policy, node);
        }
    }
}

