/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import uy.ub.agesic.fd.config.ConfigurationUtil;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.exceptions.CRLVerificationException;

public class CRLValidation {
    static MessagesUtil msgUtil = new MessagesUtil(null);

    private CRLValidation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateCertificate(X509Certificate cert) throws CRLVerificationException {
        try {
            ConfigurationUtil cfgUtil = new ConfigurationUtil(null);
            List<String> crlDistPoints = CRLValidation.getCrlDistributionPoints(cert);
            if (crlDistPoints == null || crlDistPoints.isEmpty()) {
                String crlDP = cfgUtil.getValue("CRL_DEFAULT_URL");
                if (crlDP == null || crlDP.equalsIgnoreCase("")) throw new CRLVerificationException(msgUtil.getValue("MSG_CRLValidation_ERROR_GENERAL"));
                X509CRL crl = CRLValidation.downloadCRL(crlDP);
                if (!crl.isRevoked(cert)) return;
                throw new CRLVerificationException(msgUtil.getValue("MSG_CRLValidation_REVOCATION") + crlDP);
            } else {
                for (String crlDP : crlDistPoints) {
                    X509CRL crl = CRLValidation.downloadCRL(crlDP);
                    if (!crl.isRevoked(cert)) continue;
                    throw new CRLVerificationException(msgUtil.getValue("MSG_CRLValidation_REVOCATION") + crlDP);
                }
            }
            return;
        }
        catch (Exception ex) {
            if (!(ex instanceof CRLVerificationException)) throw new CRLVerificationException(msgUtil.getValue("MSG_CRLValidation_ERROR_GENERAL"));
            throw (CRLVerificationException)ex;
        }
    }

    private static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, CRLVerificationException, NamingException {
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            X509CRL crl = CRLValidation.downloadCRLFromWeb(crlURL);
            return crl;
        }
        throw new CRLVerificationException(msgUtil.getValue("MSG_CRLValidation_CONNECTION") + crlURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            X509CRL crl;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = crl = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateParsingException, IOException {
        byte[] crldpExt = cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (crldpExt == null) {
            ArrayList<String> emptyList = new ArrayList<String>();
            return emptyList;
        }
        ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
        DERObject derObjCrlDP = oAsnInStream.readObject();
        DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
        byte[] crldpExtOctets = dosCrlDP.getOctets();
        ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
        DERObject derObj2 = oAsnInStream2.readObject();
        CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)derObj2);
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
            for (int j = 0; j < genNames.length; ++j) {
                if (genNames[j].getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genNames[j].getName()).getString();
                crlUrls.add(url);
            }
        }
        return crlUrls;
    }
}

