/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.business.validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.dto.MensajesDTO;
import uy.ub.agesic.fd.exceptions.BusinessException;
import uy.ub.agesic.fd.holder.ProcesoHolder;

public class ClientValidation {
    private static final Logger LOGGER = Logger.getLogger(ClientValidation.class.getName());
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    MessagesUtil msgUtil = new MessagesUtil(null);

    public boolean validationSendFilesSigned() throws BusinessException {
        try {
            if (this.holder == null) {
                LOGGER.log(Level.SEVERE, "holder instancia, fail validation");
                return false;
            }
            if (this.holder.getProceso() == null) {
                LOGGER.log(Level.SEVERE, "Datos de proceso, fail validation");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)this.holder.getProceso().getIdentificador())) {
                LOGGER.log(Level.SEVERE, "Identificador, fail validation");
                return false;
            }
            if (StringUtils.isBlank((CharSequence)this.holder.getProceso().getClaveSeguridad())) {
                LOGGER.log(Level.SEVERE, "Clave de seguridad, fail validation");
                return false;
            }
            if (this.holder.getSofisFile().isEmpty()) {
                LOGGER.log(Level.SEVERE, "Sofis File is empty. fail validation");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception ", e);
            return false;
        }
    }

    public boolean validationRequestSendFilesSigned(MensajesDTO dto) throws BusinessException {
        try {
            if (dto == null) {
                LOGGER.log(Level.SEVERE, "Mensaje de respuesta es null, fail validation: ", this.msgUtil.getValue("MSG_ERROR_COMUNICACION_DOCUMENTOS"));
                return false;
            }
            if (dto.getMensajeError() != null) {
                LOGGER.log(Level.SEVERE, "Error encontrado en el request, fail validation: ", this.msgUtil.getValue(dto.getMensajeError()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception ", e);
            return false;
        }
    }
}

