/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import uy.ub.agesic.fd.application.AppViewer;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.StageUtil;

public class ConfigurationController
implements Initializable {
    private static final Logger logger = Logger.getLogger(AppViewer.class.getName());
    private Preferences prefs = Preferences.userRoot().node("PREFERENCES");
    @FXML
    private TextField txfHost = new TextField();
    @FXML
    private TextField txfPort = new TextField();
    private TextField txfUser = new TextField();
    private TextField txfPass = new TextField();
    @FXML
    private CheckBox cbxAutorizoEnvioEstadisticas;
    @FXML
    private Button btnAceptar;
    @FXML
    private Button btnCancelar;
    @FXML
    private Hyperlink hlTermsAndConds;
    @FXML
    private Hyperlink btnSearchCedula;
    @FXML
    private Hyperlink btnDeleteCedula;
    @FXML
    private TextField txfDriverCedula;
    @FXML
    private Hyperlink btnSearchTokenAbitab;
    @FXML
    private Hyperlink btnDeleteTokenAbitab;
    @FXML
    private TextField txfDriverTokenAbitab;
    @FXML
    private Hyperlink btnSearchTokenCorreo;
    @FXML
    private Hyperlink btnDeleteTokenCorreo;
    @FXML
    private TextField txfDriverTokenCorreo;
    @FXML
    private Button btnSearchImageSign;
    @FXML
    private Button btnDeleteImageSign;
    @FXML
    private ImageView imageSign;
    private MessagesUtil msgUtil = new MessagesUtil(null);
    private File signImageFile;
    private boolean borrarImagen = false;
    @FXML
    private Label lblImagen;
    private static long IMAGE_SIZE = 500000L;
    private static long IMAGE_WIDTH = 400L;
    private static long IMAGE_HEIGHT = 250L;
    @FXML
    private CheckBox checkFirmaAvanzada;
    @FXML
    private CheckBox checkFirmadoPor;
    @FXML
    private CheckBox checkDocumento;
    @FXML
    private CheckBox checkFecha;
    @FXML
    private CheckBox checkAutoridad;
    @FXML
    private RadioButton radioButSi;
    @FXML
    private RadioButton radioButNo;
    ToggleGroup toggleGroup = new ToggleGroup();

    public void initialize(URL url, ResourceBundle rb) {
        this.txfHost.setText(this.prefs.get("HOST", ""));
        this.txfPort.setText(this.prefs.get("PORT", ""));
        this.txfUser.setText(this.prefs.get("USER", ""));
        this.txfPass.setText(this.prefs.get("PASS", ""));
        this.radioButSi.setToggleGroup(this.toggleGroup);
        this.radioButNo.setToggleGroup(this.toggleGroup);
        String configValor = this.prefs.get("CUSTOMIZE_SIGNATURE", "");
        if ("true".equalsIgnoreCase(configValor)) {
            this.radioButSi.setSelected(true);
        } else if ("false".equalsIgnoreCase(configValor)) {
            this.radioButNo.setSelected(true);
            this.checkFirmaAvanzada.setDisable(true);
            this.checkAutoridad.setDisable(true);
            this.checkDocumento.setDisable(true);
            this.checkFecha.setDisable(true);
            this.checkFirmadoPor.setDisable(true);
        }
        this.checkFirmaAvanzada.setSelected("true".equalsIgnoreCase(this.prefs.get("SIGN_INC_FIRMA_AVAZADA", "")));
        this.checkAutoridad.setSelected("true".equalsIgnoreCase(this.prefs.get("SIGN_INC_AUTORIDAD", "")));
        this.checkDocumento.setSelected("true".equalsIgnoreCase(this.prefs.get("SIGN_INC_DOCUMENTO", "")));
        this.checkFecha.setSelected("true".equalsIgnoreCase(this.prefs.get("SIGN_INC_FECHA", "")));
        this.checkFirmadoPor.setSelected("true".equalsIgnoreCase(this.prefs.get("SIGN_INC_FIRMADO_POR", "")));
        this.txfPort.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("[0-9]*")) {
                    ConfigurationController.this.txfPort.setText(oldValue);
                }
            }
        });
        this.hlTermsAndConds.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.openLink(new ActionEvent());
            }
        });
        if (!this.prefs.getBoolean("AUTORIZO_ENVIO_ESTADISTICAS", false)) {
            this.cbxAutorizoEnvioEstadisticas.setSelected(Boolean.FALSE.booleanValue());
        } else {
            this.cbxAutorizoEnvioEstadisticas.setSelected(Boolean.TRUE.booleanValue());
        }
        this.txfDriverCedula.setText(this.prefs.get("PATH_DRIVER_CEDULA", ""));
        this.txfDriverTokenAbitab.setText(this.prefs.get("PATH_DRIVER_TOKEN_ABITAB", ""));
        this.txfDriverTokenCorreo.setText(this.prefs.get("PATH_DRIVER_TOKEN_CORREO", ""));
        ImageView findCedula = new ImageView(new Image(this.getClass().getResourceAsStream("/images/search.png")));
        ImageView deleteCedula = new ImageView(new Image(this.getClass().getResourceAsStream("/images/delete.png")));
        this.btnSearchCedula.setGraphic((Node)findCedula);
        this.btnDeleteCedula.setGraphic((Node)deleteCedula);
        this.btnSearchCedula.setText("");
        this.btnDeleteCedula.setText("");
        ImageView findTokenAbitab = new ImageView(new Image(this.getClass().getResourceAsStream("/images/search.png")));
        ImageView deleteTokenAbitab = new ImageView(new Image(this.getClass().getResourceAsStream("/images/delete.png")));
        this.btnSearchTokenAbitab.setGraphic((Node)findTokenAbitab);
        this.btnSearchTokenAbitab.setText("");
        this.btnDeleteTokenAbitab.setGraphic((Node)deleteTokenAbitab);
        this.btnDeleteTokenAbitab.setText("");
        ImageView findTokenCorreo = new ImageView(new Image(this.getClass().getResourceAsStream("/images/search.png")));
        ImageView deleteTokenCorreo = new ImageView(new Image(this.getClass().getResourceAsStream("/images/delete.png")));
        this.btnSearchTokenCorreo.setGraphic((Node)findTokenCorreo);
        this.btnDeleteTokenCorreo.setGraphic((Node)deleteTokenCorreo);
        this.btnSearchTokenCorreo.setText("");
        this.btnDeleteTokenCorreo.setText("");
        if (!this.prefs.get("IMAGE_SIGN_URI", "").equals("")) {
            this.imageSign.setImage(new Image("file:" + this.prefs.get("IMAGE_SIGN_URI", null)));
        } else {
            this.imageSign.setImage(new Image(this.getClass().getResourceAsStream("/images/no_image.png")));
        }
        ImageView findImagenFirma = new ImageView(new Image(this.getClass().getResourceAsStream("/images/config.png")));
        ImageView deleteImagenFirma = new ImageView(new Image(this.getClass().getResourceAsStream("/images/delete.png")));
        this.btnSearchImageSign.setGraphic((Node)findImagenFirma);
        this.btnDeleteImageSign.setGraphic((Node)deleteImagenFirma);
        this.lblImagen.setText("Imagen (" + IMAGE_SIZE / 1000L + " kb, " + IMAGE_WIDTH + " x " + IMAGE_HEIGHT + " px)");
    }

    private void aceptar() {
        this.prefs.put("HOST", this.txfHost.getText());
        this.prefs.put("PORT", this.txfPort.getText());
        this.prefs.put("USER", this.txfUser.getText());
        this.prefs.put("PASS", this.txfPass.getText());
        if (this.cbxAutorizoEnvioEstadisticas.isSelected()) {
            this.prefs.putBoolean("AUTORIZO_ENVIO_ESTADISTICAS", Boolean.TRUE);
        } else {
            this.prefs.putBoolean("AUTORIZO_ENVIO_ESTADISTICAS", Boolean.FALSE);
        }
        this.prefs.put("PATH_DRIVER_CEDULA", this.txfDriverCedula.getText());
        this.prefs.put("PATH_DRIVER_TOKEN_ABITAB", this.txfDriverTokenAbitab.getText());
        this.prefs.put("PATH_DRIVER_TOKEN_CORREO", this.txfDriverTokenCorreo.getText());
        this.prefs.put("SIGN_INC_FIRMA_AVAZADA", this.checkFirmaAvanzada.isSelected() ? "true" : "false");
        this.prefs.put("SIGN_INC_AUTORIDAD", this.checkAutoridad.isSelected() ? "true" : "false");
        this.prefs.put("SIGN_INC_DOCUMENTO", this.checkDocumento.isSelected() ? "true" : "false");
        this.prefs.put("SIGN_INC_FECHA", this.checkFecha.isSelected() ? "true" : "false");
        this.prefs.put("SIGN_INC_FIRMADO_POR", this.checkFirmadoPor.isSelected() ? "true" : "false");
        if (this.radioButSi.isSelected()) {
            this.prefs.put("CUSTOMIZE_SIGNATURE", "true");
        } else {
            this.prefs.put("CUSTOMIZE_SIGNATURE", "false");
        }
        if (this.borrarImagen) {
            this.prefs.put("IMAGE_SIGN_URI", "");
        } else if (this.signImageFile != null) {
            try {
                String userHome = System.getProperty("user.home");
                Path appDir = Paths.get(userHome, ".firmagubuy", "images");
                File appDirFile = appDir.toFile();
                if (!appDirFile.exists()) {
                    appDirFile.mkdirs();
                }
                Path outputFile = appDir.resolve("imagen-firma.png");
                BufferedImage image = ImageIO.read(this.signImageFile);
                ImageIO.write((RenderedImage)image, "png", outputFile.toFile());
                this.prefs.put("IMAGE_SIGN_URI", outputFile.toString());
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigurationController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @FXML
    private void accept(ActionEvent event) {
        this.aceptar();
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
    }

    @FXML
    private void onCustomizeSignature(ActionEvent event) {
        if (this.radioButSi.isSelected()) {
            this.checkFirmaAvanzada.setDisable(false);
            this.checkAutoridad.setDisable(false);
            this.checkDocumento.setDisable(false);
            this.checkFecha.setDisable(false);
            this.checkFirmadoPor.setDisable(false);
        } else {
            this.checkFirmaAvanzada.setDisable(true);
            this.checkAutoridad.setDisable(true);
            this.checkDocumento.setDisable(true);
            this.checkFecha.setDisable(true);
            this.checkFirmadoPor.setDisable(true);
        }
    }

    @FXML
    private void pressAccept(KeyEvent ke) {
        if (ke.getCode() == KeyCode.ENTER) {
            this.aceptar();
            Node nodeClose = (Node)ke.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void cancel(ActionEvent event) {
        StageUtil stage = new StageUtil();
        stage.close((Event)event);
    }

    @FXML
    private void pressCancel(KeyEvent ke) {
        if (ke.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)ke.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
        }
    }

    @FXML
    private void openLink(ActionEvent event) {
        AppViewer app = new AppViewer();
        app.openBrowser("https://www.gub.uy/agencia-gobierno-electronico-sociedad-informacion-conocimiento/comunicacion/publicaciones/condiciones-uso-firmagubuy");
    }

    @FXML
    private void pressCheck(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            if (this.cbxAutorizoEnvioEstadisticas.isSelected()) {
                this.cbxAutorizoEnvioEstadisticas.setSelected(false);
            } else {
                this.cbxAutorizoEnvioEstadisticas.setSelected(true);
            }
        }
    }

    @FXML
    private void buscarDriverCedula(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECT_DRIVER"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("DRIVER_EXTENSION"), new String[]{"*.so", "*.dll", "*.dylib"})});
        StageUtil stage = new StageUtil();
        File file = chooser.showOpenDialog((Window)stage.getStage());
        if (file != null) {
            this.txfDriverCedula.setText(file.getAbsolutePath());
        } else {
            this.txfDriverCedula.setText("");
        }
    }

    private void buscarDriverCedulaPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.buscarDriverCedula(null);
        }
    }

    @FXML
    private void borrarDriverCedula(ActionEvent event) {
        this.txfDriverCedula.setText("");
    }

    private void borrarDriverCedulaPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.borrarDriverCedula(null);
        }
    }

    @FXML
    private void buscarDriverTokenAbitab(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECT_DRIVER"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("DRIVER_EXTENSION"), new String[]{"*.so", "*.dll", "*.dylib"})});
        StageUtil stage = new StageUtil();
        File file = chooser.showOpenDialog((Window)stage.getStage());
        if (file != null) {
            this.txfDriverTokenAbitab.setText(file.getAbsolutePath());
        } else {
            this.txfDriverTokenAbitab.setText("");
        }
    }

    private void buscarDriverTokenAbitabPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.buscarDriverTokenAbitab(null);
        }
    }

    @FXML
    private void borrarDriverTokenAbitab(ActionEvent event) {
        this.txfDriverTokenAbitab.setText("");
    }

    private void borrarDriverTokenAbitabPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.borrarDriverTokenAbitab(null);
        }
    }

    @FXML
    private void buscarDriverTokenCorreo(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECT_DRIVER"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("DRIVER_EXTENSION"), new String[]{"*.so", "*.dll", "*.dylib"})});
        StageUtil stage = new StageUtil();
        File file = chooser.showOpenDialog((Window)stage.getStage());
        if (file != null) {
            this.txfDriverTokenCorreo.setText(file.getAbsolutePath());
        } else {
            this.txfDriverTokenCorreo.setText("");
        }
    }

    private void buscarDriverTokenCorreoPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.buscarDriverTokenCorreo(null);
        }
    }

    @FXML
    private void borrarDriverTokenCorreo(ActionEvent event) {
        this.txfDriverTokenCorreo.setText("");
    }

    private void borrarDriverTokenCorreoPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.borrarDriverTokenCorreo(null);
        }
    }

    @FXML
    private void buscarImagenFirma(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECT_SIGN_FILE"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("SIGN_FILE_EXTENSION"), new String[]{"*.jpeg", "*.jpg", "*.png"})});
        StageUtil stage = new StageUtil();
        File file = chooser.showOpenDialog((Window)stage.getStage());
        if (file != null) {
            if (file.length() > IMAGE_SIZE) {
                AlertasUtil alerta = new AlertasUtil();
                alerta.displayAlertInfo(this.msgUtil.getValue("MSG_ERROR_TAMANIO_IMAGEN"));
                return;
            }
            long imageHeight = 0L;
            long imageWidth = 0L;
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
                imageHeight = image.getHeight();
                imageWidth = image.getWidth();
                if (imageHeight > IMAGE_HEIGHT || imageWidth > IMAGE_WIDTH) {
                    AlertasUtil alerta = new AlertasUtil();
                    alerta.displayAlertInfo(this.msgUtil.getValue("MSG_ERROR_DIMENSION_IMAGEN"));
                    return;
                }
                this.imageSign.setImage(new Image(file.toURI().toString()));
                this.signImageFile = file;
                this.borrarImagen = false;
            }
            catch (IOException ex) {
                Logger.getLogger(ConfigurationController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        this.imageSign = null;
    }

    @FXML
    private void buscarImagenFirmaPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.buscarImagenFirma(null);
        }
    }

    @FXML
    private void borrarImagenFirma(ActionEvent event) {
        this.signImageFile = null;
        this.imageSign.setImage(new Image(this.getClass().getResourceAsStream("/images/no_image.png")));
        this.borrarImagen = true;
    }

    @FXML
    private void borrarImagenFirmaPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.borrarImagenFirma(null);
        }
    }
}

