/*
 * Decompiled with CFR 0.152.
 */
package uy.ub.agesic.fd.controllers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import uy.ub.agesic.fd.config.MessagesUtil;
import uy.ub.agesic.fd.controllers.DisplayFilesController;
import uy.ub.agesic.fd.dto.ProcesoDTO;
import uy.ub.agesic.fd.dto.UbicacionFirma;
import uy.ub.agesic.fd.holder.ProcesoHolder;
import uy.ub.agesic.fd.holder.StageHolder;
import uy.ub.agesic.fd.pdf.PDFBoxSofisUtil;
import uy.ub.agesic.fd.pdf.PDFValidadate;
import uy.ub.agesic.fd.utils.AlertasUtil;
import uy.ub.agesic.fd.utils.OtherUtils;
import uy.ub.agesic.fd.utils.ProgressBarTableCellCustom;
import uy.ub.agesic.fd.utils.ShowDocumentSofis;
import uy.ub.agesic.fd.utils.SofisFile;
import uy.ub.agesic.fd.utils.StageUtil;
import uy.ub.agesic.fd.xml.XMLValidadate;

public class DragAndDropController
implements Initializable {
    @FXML
    private TableView<SofisFile> tableFiles;
    @FXML
    private Hyperlink linkCambiarDispositivo;
    @FXML
    private Button btnUbicarFirma;
    @FXML
    private Button btnBuscarArchivos;
    @FXML
    private Button btnFirmarTodo;
    @FXML
    private Label lblDragDrop;
    @FXML
    private TableColumn<SofisFile, String> tblColumnNombre;
    @FXML
    private TableColumn<SofisFile, String> tblColumnTamanio;
    @FXML
    private ImageView logoAgesic;
    AlertasUtil alerta = new AlertasUtil();
    MessagesUtil msgUtil = new MessagesUtil(null);
    private ProcesoHolder holder = ProcesoHolder.getInstance();
    private StageHolder stageHolder = StageHolder.getInstance();
    private static final Logger logger = Logger.getLogger(DragAndDropController.class.getName());
    private List<SofisFile> documents = new ArrayList<SofisFile>();
    ObservableList<SofisFile> dataList = FXCollections.observableList(this.documents);
    TableColumn buttonColumn = new TableColumn("");
    Callback<TableColumn<SofisFile, String>, TableCell<SofisFile, String>> cellButtonAction = new Callback<TableColumn<SofisFile, String>, TableCell<SofisFile, String>>(){

        public TableCell<SofisFile, String> call(TableColumn<SofisFile, String> param) {
            return null;
        }
    };
    Callback<TableColumn<SofisFile, String>, TableCell<SofisFile, String>> cellProgressBar = new Callback<TableColumn<SofisFile, String>, TableCell<SofisFile, String>>(){

        public TableCell<SofisFile, String> call(TableColumn<SofisFile, String> param) {
            return null;
        }
    };
    @FXML
    private Button btnCancelar;

    public void initialize(URL url, ResourceBundle rb) {
        Image imageLogo = new Image(this.getClass().getResourceAsStream("/images/agesic-color.png"));
        this.logoAgesic.setImage(imageLogo);
        Label placeHolderTable = new Label();
        placeHolderTable.setText(this.msgUtil.getValue("MSG_NO_FOUND_FILES"));
        placeHolderTable.setStyle("-fx-font-size: 20;");
        this.tableFiles.setPlaceholder((Node)placeHolderTable);
        this.lblDragDrop.setMaxWidth(Double.MAX_VALUE);
        this.lblDragDrop.setAlignment(Pos.CENTER);
        this.statusButtonAction();
        this.btnBuscarArchivos.requestFocus();
    }

    @FXML
    private void cambiarDispositivo(ActionEvent event) {
        try {
            Image imageLogo = new Image(this.getClass().getResourceAsStream("/images/agesic-color.png"));
            this.logoAgesic.setImage(imageLogo);
            StageUtil stageUtil = new StageUtil();
            stageUtil.close((Event)event);
            stageUtil.open((Event)event, "SeleccionDispositivoFirma");
        }
        catch (Exception e) {
            System.out.println(e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    @FXML
    private void buscarArchivos(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(this.msgUtil.getValue("MSG_SELECTED_DOCUMENTS_PDF_XML"));
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(this.msgUtil.getValue("MSG_SELECTED_DOCUMENTS_PDF_XML"), new String[]{"*.pdf", "*.xml"})});
        StageUtil stage = new StageUtil();
        if (this.cargarListaDocumentos(chooser.showOpenMultipleDialog((Window)stage.getStage()))) {
            this.showFiles();
        }
    }

    @FXML
    private void pressFindFile(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.buscarArchivos(new ActionEvent());
        }
    }

    @FXML
    private void ubicacionFirma(ActionEvent event) {
        try {
            this.holder.setSofisFile(this.documents);
            StageUtil stage = new StageUtil();
            stage.close((Event)event);
            this.stageHolder.setResizable(true);
            DisplayFilesController dispay = new DisplayFilesController();
            dispay.initialize(this.stageHolder.getStage());
            this.stageHolder.setResizable(false);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "start ubicacionFirma()::: ", e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    @FXML
    private void pressUbicacionFirma(KeyEvent event) {
        try {
            if (event.getCode() == KeyCode.ENTER) {
                this.holder.setSofisFile(this.documents);
                Node nodeClose = (Node)event.getSource();
                Stage stage = (Stage)nodeClose.getScene().getWindow();
                stage.close();
                this.stageHolder.setResizable(true);
                DisplayFilesController dispay = new DisplayFilesController();
                dispay.initialize(this.stageHolder.getStage());
                this.stageHolder.setResizable(false);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "start ubicacionFirma()::: ", e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
        }
    }

    @FXML
    private void pressFirmarTodo(KeyEvent event) throws IOException {
        if (event.getCode() == KeyCode.ENTER) {
            this.firmarTodo(new ActionEvent());
        }
    }

    @FXML
    private void firmarTodo(ActionEvent event) throws IOException {
        File selectedDirectory;
        StageUtil stage = new StageUtil();
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.msgUtil.getValue("MSG_SELECTED_DIRECTORY"));
        if (this.documents != null && !this.documents.isEmpty() && this.documents.get(0).getPath() != null) {
            File initialDirectory = new File(this.documents.get(0).getPath());
            directoryChooser.setInitialDirectory(new File(initialDirectory.getParent()));
        }
        if ((selectedDirectory = directoryChooser.showDialog((Window)stage.getStage())) != null) {
            this.holder.setDirectorySignedFiles(selectedDirectory.getAbsolutePath() + File.separator);
        }
        if (StringUtils.isBlank((CharSequence)this.holder.getDirectorySignedFiles())) {
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_VALIDATION"), this.msgUtil.getValue("MSG_NO_SELECTED_DIRECTORY"));
            return;
        }
        this.asignarUbicacionesFirma();
        this.holder.setSofisFile(this.documents);
        stage.openShowAndWait((Event)event, "Firmar");
    }

    @FXML
    void handleFileOverEvent(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        } else {
            event.consume();
        }
    }

    @FXML
    void handleFileDroppedEvent(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (this.cargarListaDocumentos(db.getFiles())) {
            this.showFiles();
        }
    }

    private boolean cargarListaDocumentos(List<File> files) {
        try {
            if (files != null) {
                for (File file : files) {
                    ArrayList lsUbicacionesFirma = new ArrayList();
                    String tipo = null;
                    if (PDFValidadate.isPDF(file)) {
                        tipo = "pdf";
                    } else if (XMLValidadate.isXML(file)) {
                        tipo = "xml";
                        this.btnUbicarFirma.setVisible(false);
                    }
                    if (tipo == null) {
                        this.alerta.displayAlertError(this.msgUtil.getValue("ERROR_FILE_FAIL"), this.msgUtil.getValue("ERROR_FILE_FAIL_DESC") + ": " + file.getName());
                        return false;
                    }
                    OtherUtils util = new OtherUtils();
                    if (!this.documents.stream().anyMatch(x -> x.getNombre().equals(file.getName()))) {
                        this.documents.add(new SofisFile(file.getName(), UUID.randomUUID().toString(), FileUtils.readFileToByteArray((File)file), file.length() / 1024L + " kb", OtherUtils.randomNumber(), util.waitTime(), util.pauseTime(), tipo, file.getAbsolutePath()));
                        continue;
                    }
                    this.alerta.displayAlertError(this.msgUtil.getValue("ERROR_FILE_FAIL"), this.msgUtil.getValue("ERROR_FILE_NAME_EXIST") + file.getName());
                    logger.log(Level.SEVERE, this.msgUtil.getValue("ERROR_FILE_FAIL") + " {0}", file.getName());
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_GENERAL"), this.msgUtil.getValue("ERROR_FILE_FAIL"));
            logger.log(Level.SEVERE, DragAndDropController.class.getName(), ex);
            return false;
        }
    }

    private void showFiles() {
        try {
            if (this.tableFiles.getColumns().size() > 2) {
                this.tableFiles.getColumns().remove(3);
                this.tableFiles.getColumns().remove(2);
            }
            this.dataList = FXCollections.observableList(this.documents);
            this.tblColumnNombre.setCellValueFactory((Callback)new PropertyValueFactory("nombre"));
            this.tblColumnNombre.setStyle("-fx-alignment: BASELINE_LEFT; -fx-padding: 0 15 0 15;");
            this.tblColumnTamanio.setCellValueFactory((Callback)new PropertyValueFactory("tamanio"));
            this.tblColumnTamanio.setStyle("-fx-alignment: BASELINE_CENTER; -fx-padding: 1 15 0 15;");
            TableColumn statusCol = new TableColumn("ESTADO");
            statusCol.setCellValueFactory((Callback)new PropertyValueFactory("message"));
            statusCol.setPrefWidth(135.0);
            statusCol.setStyle("-fx-alignment: BASELINE_CENTER;");
            TableColumn progressCol = new TableColumn("PROGRESO");
            progressCol.setCellValueFactory((Callback)new PropertyValueFactory("progress"));
            progressCol.setCellFactory(ProgressBarTableCellCustom.forTableColumn());
            this.tableFiles.setItems(this.dataList);
            this.addButtonsTable();
            this.buttonColumn.setCellFactory(this.cellButtonAction);
            this.buttonColumn.setPrefWidth(115.0);
            this.tableFiles.getColumns().addAll((Object[])new TableColumn[]{progressCol});
            this.startProcess();
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "StartProcess task ", ex);
        }
    }

    private void deleteItem(SofisFile sofisFile) {
        AlertasUtil alerta = new AlertasUtil();
        boolean delete = alerta.displayAlertYesNo(this.msgUtil.getValue("MSG_DELETE_FILE"), this.msgUtil.getValue("MSG_DELETE_FILE_CONFIRM"));
        if (delete) {
            this.documents.remove((Object)sofisFile);
            this.showFiles();
        }
    }

    private void viewItem(SofisFile sofisFile) {
        try {
            ShowDocumentSofis.showDocument(sofisFile.getPath());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, DragAndDropController.class.getName(), ex);
        }
    }

    private void addButtonsTable() {
        this.cellButtonAction = new Callback<TableColumn<SofisFile, String>, TableCell<SofisFile, String>>(){

            public TableCell call(TableColumn<SofisFile, String> param) {
                TableCell<SofisFile, String> cell = new TableCell<SofisFile, String>(){
                    private final Button viewButton = new Button("");
                    private final Button deleteButton = new Button("");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.viewButton.setFocusTraversable(false);
                            this.deleteButton.setFocusTraversable(false);
                            this.deleteButton.setOnAction(event -> DragAndDropController.this.deleteItem((SofisFile)((Object)((Object)this.getTableView().getItems().get(this.getIndex())))));
                            this.viewButton.setOnAction(event -> DragAndDropController.this.viewItem((SofisFile)((Object)((Object)this.getTableView().getItems().get(this.getIndex())))));
                            Image imageView = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/view.png"));
                            Image imageDelete = new Image(((Object)((Object)this)).getClass().getResourceAsStream("/images/delete.png"));
                            this.deleteButton.setGraphic((Node)new ImageView(imageDelete));
                            this.viewButton.setGraphic((Node)new ImageView(imageView));
                            HBox hBoxContendButton = new HBox(new Node[]{this.viewButton, this.deleteButton});
                            hBoxContendButton.setSpacing(5.0);
                            this.setGraphic((Node)hBoxContendButton);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.tableFiles.getColumns().addAll((Object[])new TableColumn[]{this.buttonColumn});
    }

    private void startProcess() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(this.tableFiles.getItems().size(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        for (SofisFile task : this.tableFiles.getItems()) {
            executor.execute((Runnable)((Object)task));
        }
        this.statusButtonAction();
    }

    private void asignarUbicacionesFirma() throws IOException {
        for (SofisFile doc : this.documents) {
            if (!doc.getTipo().equalsIgnoreCase("pdf")) continue;
            doc.getUbicacionesFirma().add(this.asignarUbicacionFirma(doc.getBytes()));
        }
    }

    private UbicacionFirma asignarUbicacionFirma(byte[] bt) throws IOException {
        return new UbicacionFirma(PDFBoxSofisUtil.numeroPaginasDeDocumento(bt) - 1, this.msgUtil.getIntValue("PDFSIGNATURE_APPEARANCE_POS_llx"), this.msgUtil.getIntValue("PDFSIGNATURE_APPEARANCE_POS_lly"), this.msgUtil.getIntValue("PDFSIGNATURE_APPEARANCE_POS_urx"), this.msgUtil.getIntValue("PDFSIGNATURE_APPEARANCE_POS_ury"));
    }

    private void statusButtonAction() {
        if (this.documents.isEmpty() || this.tableFiles.getItems().isEmpty()) {
            this.btnFirmarTodo.setDisable(true);
            this.btnUbicarFirma.setDisable(true);
        } else {
            this.btnFirmarTodo.setDisable(false);
            this.btnUbicarFirma.setDisable(false);
        }
    }

    @FXML
    private void cancelar(ActionEvent event) {
        try {
            StageUtil stage = new StageUtil();
            stage.close((Event)event);
            ProcesoDTO proceso = new ProcesoDTO();
            proceso.setMetodoFirma(this.holder.getProceso().getMetodoFirma());
            String jxml = "SeleccionDispositivoFirma";
            this.holder.setProceso(proceso);
            stage.open((Event)event, jxml);
            return;
        }
        catch (Exception e) {
            System.out.println(e);
            this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
            return;
        }
    }

    @FXML
    private void pressCancel(KeyEvent ke) {
        if (ke.getCode() == KeyCode.ENTER) {
            Node nodeClose = (Node)ke.getSource();
            Stage stage = (Stage)nodeClose.getScene().getWindow();
            stage.close();
            Platform.exit();
            System.exit(0);
        }
    }

    @FXML
    private void cambiarDispositivoPress(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            try {
                Image imageLogo = new Image(this.getClass().getResourceAsStream("/images/agesic-color.png"));
                this.logoAgesic.setImage(imageLogo);
                StageUtil stageUtil = new StageUtil();
                Node nodeClose = (Node)event.getSource();
                Stage stage = (Stage)nodeClose.getScene().getWindow();
                stage.close();
                stageUtil.open((Event)event, "SeleccionDispositivoFirma");
            }
            catch (IOException e) {
                System.out.println(e);
                this.alerta.displayAlertError(this.msgUtil.getValue("MSG_ERROR_NAVEGACION"), this.msgUtil.getValue("MSG_ERROR_NAVEGACION_DES"));
            }
        }
    }
}

